/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.ForceRollSegmentsHandler;
import io.confluent.rest.ResponseContainer;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import kafka.tier.common.RestServerUtil;
import kafka.tier.tools.TierOrchestratorUtils;
import kafka.tier.tools.commands.ForceRollSegmentsCommandRequest;
import kafka.tier.tools.commands.ForceRollSegmentsCommandResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.kafka.clients.admin.AdminClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceRollSegmentsOrchestrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForceRollSegmentsOrchestrator.class);
    private final AdminClient adminClient;
    private final CloseableHttpClient httpClient;
    private final Integer restServerPort;
    private static final String HTTP_PREFIX = "http://";
    static final ObjectMapper OBJECT_MAPPER = ForceRollSegmentsHandler.OBJECT_MAPPER;

    public ForceRollSegmentsOrchestrator(AdminClient adminClient, Integer restServerPort) {
        this(adminClient, RestServerUtil.buildHttpClient(), restServerPort);
    }

    ForceRollSegmentsOrchestrator(AdminClient adminClient, CloseableHttpClient httpClient, Integer restServerPort) {
        this.adminClient = adminClient;
        this.httpClient = httpClient;
        this.restServerPort = restServerPort;
    }

    public ForceRollSegmentsCommandResponse forceRollSegmentsForCluster(String logicalClusterId) throws ExecutionException, InterruptedException, JsonProcessingException {
        LOGGER.info("Force rolling segments associated with tenant: {} for all brokers in the cluster.", (Object)logicalClusterId);
        Map<Integer, String> brokerToUrlMap = TierOrchestratorUtils.getBrokerToUrlMap(this.adminClient, this.restServerPort, LOGGER);
        ForceRollSegmentsCommandResponse forceRollSegmentsCommandResponse = new ForceRollSegmentsCommandResponse();
        for (Map.Entry<Integer, String> brokerAndUrl : brokerToUrlMap.entrySet()) {
            ForceRollSegmentsHandler.ForceRollSegmentsRequest request = new ForceRollSegmentsHandler.ForceRollSegmentsRequest(logicalClusterId);
            String response = this.forceRollSegments(new ForceRollSegmentsCommandRequest(brokerAndUrl.getValue(), request));
            this.parseForceRollSegmentsResponse(forceRollSegmentsCommandResponse, response, brokerAndUrl.getKey());
        }
        LOGGER.debug(TierOrchestratorUtils.prettyPrint(OBJECT_MAPPER, forceRollSegmentsCommandResponse));
        return forceRollSegmentsCommandResponse;
    }

    public ForceRollSegmentsCommandResponse forceRollSegmentsForBroker(String logicalClusterId, int brokerId) throws ExecutionException, InterruptedException, JsonProcessingException {
        String brokerUrl = TierOrchestratorUtils.getBrokerUrlIfBrokerExists(this.adminClient, this.restServerPort, brokerId, LOGGER);
        ForceRollSegmentsCommandResponse forceRollSegmentsCommandResponse = new ForceRollSegmentsCommandResponse();
        ForceRollSegmentsHandler.ForceRollSegmentsRequest request = new ForceRollSegmentsHandler.ForceRollSegmentsRequest(logicalClusterId);
        String response = this.forceRollSegments(new ForceRollSegmentsCommandRequest(brokerUrl, request));
        this.parseForceRollSegmentsResponse(forceRollSegmentsCommandResponse, response, brokerId);
        LOGGER.debug(TierOrchestratorUtils.prettyPrint(OBJECT_MAPPER, forceRollSegmentsCommandResponse));
        return forceRollSegmentsCommandResponse;
    }

    private String forceRollSegments(ForceRollSegmentsCommandRequest request) throws JsonProcessingException {
        LOGGER.info("Force rolling segments for broker {} with request: {}", (Object)request.brokerUrl(), (Object)TierOrchestratorUtils.prettyPrint(OBJECT_MAPPER, request.request()));
        return RestServerUtil.sendRequestTryHttps(request, this.httpClient);
    }

    private void parseForceRollSegmentsResponse(ForceRollSegmentsCommandResponse forceRollSegmentsCommandResponse, String response, Integer broker) throws JsonProcessingException {
        if (response == null) {
            forceRollSegmentsCommandResponse.getFailed().add(new ForceRollSegmentsCommandResponse.BrokerDetail(broker, false, null));
        } else {
            boolean fail;
            ForceRollSegmentsHandler.ForceRollSegmentsResponse result = (ForceRollSegmentsHandler.ForceRollSegmentsResponse)ForceRollSegmentsOrchestrator.OBJECT_MAPPER.readValue((String)response, new TypeReference<ResponseContainer<ForceRollSegmentsHandler.ForceRollSegmentsResponse>>(){}).data.attributes;
            boolean bl = fail = !result.failedPartitions().isEmpty();
            if (fail) {
                forceRollSegmentsCommandResponse.getFailed().add(new ForceRollSegmentsCommandResponse.BrokerDetail(broker, true, result.failedPartitions()));
            } else {
                forceRollSegmentsCommandResponse.getSuccess().add(new ForceRollSegmentsCommandResponse.BrokerDetail(broker, true, result.failedPartitions()));
            }
        }
    }
}

