/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tools.RestoreRawInput;
import kafka.tier.tools.common.RestoreRawInputInfoLocal;
import kafka.tier.tools.common.RestoreRawOutputInfoLocal;

public class RestoreRawLocalInput
extends RestoreRawInput<RestoreRawInputInfoLocal, RestoreRawOutputInfoLocal> {
    @Override
    public File getFtpsForTopicPartition(RestoreRawInputInfoLocal input, TierObjectStore objectStore) {
        return input.path().toFile();
    }

    @Override
    public Boolean getRestoreLogStartOffset(RestoreRawInputInfoLocal input) {
        return input.fenceEventInfo().freezeMergedLogStartOffset();
    }

    @Override
    public RestoreRawOutputInfoLocal getRawOutputInfo(RestoreRawInputInfoLocal input, String restore) {
        return new RestoreRawOutputInfoLocal(input, restore);
    }

    @Override
    public void writeOutputFile(List<RestoreRawOutputInfoLocal> outputs, File outputFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputFile);
        RestoreRawOutputInfoLocal.writeJsonToFile(outputs, fos);
        fos.close();
    }
}

