/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.IOException;
import java.util.Properties;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.utils.Utils;

public class TierToolsUtils {
    public static final String COMMAND_POSITIONAL = "command";
    public static final String NAME = "kafka-tier-metadata-recovery";
    public static final String ADMIN_CONFIG = "admin.config";
    public static final String ADMIN_CONFIG_DOC = "path to admin client configs";
    public static final String BOOTSTRAP_SERVERS = "bootstrap-servers";
    public static final String BOOTSTRAP_SERVERS_DOC = "Comma-separated list of broker urls (host:port) to connect to. This is required for all commands.";
    public static final Integer DEFAULT_REST_SERVER_PORT_OVERRIDE = 9080;
    public static final String REST_SERVER_PORT_OVERRIDE = "rest-server-port-override";
    public static final String REST_SERVER_PORT_OVERRIDE_DOC = String.format("Port to override the rest server port. This is optional for all commands. Defaults to %d", DEFAULT_REST_SERVER_PORT_OVERRIDE);
    public static final String BROKER_IDS = "broker-ids";
    public static final String BROKER_IDS_DOC = "Runs the operation only on the specified brokers supplied as a comma-separated list. (i.e., 0,1,2,3)";
    public static final String ALL_BROKERS = "all-brokers";
    public static final String ALL_BROKERS_DOC = "Runs the operation for all brokers in the cluster";

    public static AdminClient getAdminClient(String adminConfigFile, String bootstrapServers) throws IOException {
        Properties properties = new Properties();
        if (adminConfigFile != null) {
            properties = Utils.loadProps(adminConfigFile);
        }
        properties.put("bootstrap.servers", bootstrapServers);
        properties.put("connections.max.idle.ms", (Object)10000);
        properties.put("request.timeout.ms", (Object)5000);
        return AdminClient.create(properties);
    }
}

