/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.remote.config.poller;

import io.confluent.remote.config.poller.RemoteConfigConfiguration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigDef;

public class PollingRemoteConfigConfiguration
extends RemoteConfigConfiguration {
    public static final String REFRESH_INTERVAL_SEC_CONFIG = "refresh.interval.sec";
    public static final Long DEFAULT_REFRESH_INTERVAL = TimeUnit.MINUTES.toSeconds(1L);
    public static final String REFRESH_INTERVAL_SEC_DOC = "Polling interval for checking updates. The default interval is suitable for production environments and usually does notneed to be changed.";

    public static ConfigDef defineConfigs(ConfigDef base) {
        return Optional.ofNullable(base).map(ConfigDef::new).orElse(new ConfigDef()).defineInternal(REFRESH_INTERVAL_SEC_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_REFRESH_INTERVAL, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, REFRESH_INTERVAL_SEC_DOC);
    }

    public PollingRemoteConfigConfiguration(ConfigDef config, Map<?, ?> originals, boolean doLog) {
        super(PollingRemoteConfigConfiguration.defineConfigs(config), originals, doLog);
    }

    public Long getRefreshIntervalMs() {
        return 1000L * this.getLong(REFRESH_INTERVAL_SEC_CONFIG);
    }
}

