/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security;

import io.confluent.kafka.security.PemUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PemUtilsTest {
    PemUtilsTest() {
    }

    @Test
    public void testLoadPublicKey() throws Exception {
        InputStream resourceAsStream = this.getClass().getResourceAsStream("/publickey.pem");
        PublicKey publicKey = PemUtils.loadPublicKey((InputStream)resourceAsStream);
        Assertions.assertEquals((Object)"RSA", (Object)publicKey.getAlgorithm());
        Assertions.assertEquals((Object)"X.509", (Object)publicKey.getFormat());
    }

    @Test
    public void testWritePublicKey() throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(2048);
        KeyPair keyPair = generator.generateKeyPair();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PemUtils.writePublicKey((OutputStream)out, (PublicKey)keyPair.getPublic());
        String outputString = out.toString("utf8");
        Assertions.assertTrue((boolean)outputString.startsWith("-----BEGIN PUBLIC KEY-----\n"));
        Assertions.assertTrue((boolean)outputString.endsWith("-----END PUBLIC KEY-----\n"));
    }

    @Test
    public void testReadKeyPair() throws Exception {
        PipedInputStream in = new PipedInputStream();
        final PipedOutputStream out = new PipedOutputStream(in);
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(2048);
        final KeyPair keyPair = generator.generateKeyPair();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PemUtils.writeKeyPair((OutputStream)out, (KeyPair)keyPair);
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        KeyPair loadedKeyPair = PemUtils.loadKeyPair((InputStream)in);
        in.close();
        Assertions.assertEquals((Object)keyPair.getPublic(), (Object)loadedKeyPair.getPublic());
        Assertions.assertEquals((Object)keyPair.getPrivate(), (Object)loadedKeyPair.getPrivate());
    }

    @Test
    void testReadKeyPairPkcs8Key() throws IOException {
        String pvtKeyFilePath = "pkcs8KeypairUnencrypted.pem";
        InputStream resourceAsStream = ClassLoader.getSystemResourceAsStream(pvtKeyFilePath);
        KeyPair keyPair = PemUtils.loadKeyPair((InputStream)resourceAsStream);
        Assertions.assertNotNull((Object)keyPair);
    }

    @Test
    void testReadKeyPairPkcs8KeyEncryptedDefaultProvider() throws IOException {
        String pvtKeyFilePath = "pkcs8KeypairEncrypted_PBE-SHA1-3DES.pem";
        InputStream resourceAsStream = ClassLoader.getSystemResourceAsStream(pvtKeyFilePath);
        KeyPair keyPair = PemUtils.loadKeyPair((InputStream)resourceAsStream, (String)"secretpass");
        Assertions.assertNotNull((Object)keyPair);
    }

    @Test
    void testReadKeyPairPkcs8KeyEncryptedBouncyCastleProvider() throws IOException {
        BouncyCastleProvider bcProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bcProvider);
        String pvtKeyFilePath = "pkcs8KeypairEncrypted.pem";
        InputStream resourceAsStream = ClassLoader.getSystemResourceAsStream(pvtKeyFilePath);
        KeyPair keyPair = PemUtils.loadKeyPair((InputStream)resourceAsStream, (String)"secretpass");
        Assertions.assertNotNull((Object)keyPair);
        Security.removeProvider(bcProvider.getName());
    }
}

