/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.Uuid;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClusterLinkListingTest {
    private final String linkName = "linkName";
    private final Uuid linkId = Uuid.randomUuid();
    private final String remoteClusterId = "remoteClusterId;";
    private final String localClusterId = "localClusterId;";
    private final Optional<Collection<String>> topics = Optional.of(Collections.singletonList("topic"));

    @Test
    public void testAvailableWithUnknownLinkState() {
        ClusterLinkListing notAvailableListing = new ClusterLinkListing("linkName", this.linkId, "remoteClusterId;", "localClusterId;", this.topics, ClusterLinkError.NO_ERROR, null, ClusterLinkDescription.LinkState.UNKNOWN);
        Assertions.assertFalse((boolean)notAvailableListing.available());
    }

    @Test
    public void testAvailableWithKnownLinkState() {
        ClusterLinkListing availableListing = new ClusterLinkListing("linkName", this.linkId, "remoteClusterId;", "localClusterId;", this.topics, ClusterLinkError.NO_ERROR, null, ClusterLinkDescription.LinkState.ACTIVE);
        Assertions.assertTrue((boolean)availableListing.available());
        ClusterLinkListing notAvailableListing = new ClusterLinkListing("linkName", this.linkId, "remoteClusterId;", "localClusterId;", this.topics, ClusterLinkError.NO_ERROR, null, ClusterLinkDescription.LinkState.FAILED);
        Assertions.assertFalse((boolean)notAvailableListing.available());
    }
}

