/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import org.apache.kafka.clients.admin.EvenClusterLoadPlanBrokerStats;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EvenClusterLoadPlanBrokerStatsTest {
    @Test
    public void testGetPrintableForm() {
        int brokerId = 0;
        String host = "host1";
        double diskMb = 35209.719;
        double diskPercent = 14.03274;
        double cpuPercent = 23.619;
        double leaderNetworkIn = 9833.179;
        double followerNetworkIn = 13814.7;
        double networkOut = 29368.961;
        double potentialNetworkOut = 75145.148;
        int leaders = 47;
        int replicas = 71;
        EvenClusterLoadPlanBrokerStats brokerStats = new EvenClusterLoadPlanBrokerStats(brokerId, host, diskMb, diskPercent, cpuPercent, leaderNetworkIn, followerNetworkIn, networkOut, potentialNetworkOut, leaders, replicas);
        String printableForm = brokerStats.getPrintableForm();
        Assertions.assertTrue((boolean)printableForm.contains("BROKER:"));
        Assertions.assertTrue((boolean)printableForm.contains("id: " + brokerId));
        Assertions.assertTrue((boolean)printableForm.contains("host: " + host));
        Assertions.assertTrue((boolean)printableForm.contains(String.format("disk: %.2fMB/%.2f%%", diskMb, diskPercent)));
        Assertions.assertTrue((boolean)printableForm.contains(String.format("cpu: %.2f", cpuPercent)));
        Assertions.assertTrue((boolean)printableForm.contains(String.format("leader network in: %.2f", leaderNetworkIn)));
        Assertions.assertTrue((boolean)printableForm.contains(String.format("follower network in: %.2f", followerNetworkIn)));
        Assertions.assertTrue((boolean)printableForm.contains(String.format("network out: %.2f", networkOut)));
        Assertions.assertTrue((boolean)printableForm.contains(String.format("potential network out: %.2f", potentialNetworkOut)));
        Assertions.assertTrue((boolean)printableForm.contains(String.format("leaders/replicas: %d/%d", leaders, replicas)));
    }
}

