/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.kafka.clients.admin.internals.AdminApiDriver;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.PartitionLeaderStrategy;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PartitionLeaderStrategyIntegrationTest {
    private static final long TIMEOUT_MS = 5000L;
    private static final long RETRY_BACKOFF_MS = 100L;
    private static final Node NODE_1 = new Node(1, "host1", 9092);
    private static final Node NODE_2 = new Node(2, "host2", 9092);
    private final LogContext logContext = new LogContext();
    private final MockTime time = new MockTime();

    private AdminApiDriver<TopicPartition, Void> buildDriver(PartitionLeaderStrategy.PartitionLeaderFuture<Void> result) {
        return new AdminApiDriver((AdminApiHandler)new MockApiHandler(), result, this.time.milliseconds() + 5000L, 100L, 100L, this.logContext);
    }

    @Test
    public void testCachingRepeatedRequest() {
        HashMap partitionLeaderCache = new HashMap();
        TopicPartition tp0 = new TopicPartition("T", 0);
        TopicPartition tp1 = new TopicPartition("T", 1);
        Set<TopicPartition> requestKeys = Set.of(tp0, tp1);
        PartitionLeaderStrategy.PartitionLeaderFuture result = new PartitionLeaderStrategy.PartitionLeaderFuture(requestKeys, partitionLeaderCache);
        AdminApiDriver<TopicPartition, Void> driver = this.buildDriver((PartitionLeaderStrategy.PartitionLeaderFuture<Void>)result);
        List requestSpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)requestSpecs.size());
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).scope.destinationBrokerId());
        Assertions.assertEquals(requestKeys, (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).keys);
        Map<TopicPartition, Integer> leaders = Map.of(tp0, 1, tp1, 2);
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(0), (AbstractResponse)this.metadataResponseWithPartitionLeaders(leaders), Node.noNode());
        Assertions.assertFalse((boolean)((KafkaFuture)result.all().get(tp0)).isDone());
        Assertions.assertFalse((boolean)((KafkaFuture)result.all().get(tp1)).isDone());
        Assertions.assertEquals((int)1, (Integer)((Integer)partitionLeaderCache.get(tp0)));
        Assertions.assertEquals((int)2, (Integer)((Integer)partitionLeaderCache.get(tp1)));
        requestSpecs = driver.poll();
        Assertions.assertEquals((int)2, (int)requestSpecs.size());
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).scope.destinationBrokerId());
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)1)).scope.destinationBrokerId());
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(0), (AbstractResponse)this.listOffsetsResponseSuccess(((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).keys), NODE_1);
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(1), (AbstractResponse)this.listOffsetsResponseSuccess(((AdminApiDriver.RequestSpec)requestSpecs.get((int)1)).keys), NODE_2);
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp0)).isDone());
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp1)).isDone());
        result = new PartitionLeaderStrategy.PartitionLeaderFuture(requestKeys, partitionLeaderCache);
        driver = this.buildDriver((PartitionLeaderStrategy.PartitionLeaderFuture<Void>)result);
        requestSpecs = driver.poll();
        Assertions.assertEquals((int)2, (int)requestSpecs.size());
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).scope.destinationBrokerId());
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)1)).scope.destinationBrokerId());
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(0), (AbstractResponse)this.listOffsetsResponseSuccess(((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).keys), NODE_1);
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(1), (AbstractResponse)this.listOffsetsResponseSuccess(((AdminApiDriver.RequestSpec)requestSpecs.get((int)1)).keys), NODE_2);
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp0)).isDone());
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp1)).isDone());
    }

    @Test
    public void testCachingOverlappingRequests() {
        HashMap partitionLeaderCache = new HashMap();
        TopicPartition tp0 = new TopicPartition("T", 0);
        TopicPartition tp1 = new TopicPartition("T", 1);
        TopicPartition tp2 = new TopicPartition("T", 2);
        TopicPartition tp3 = new TopicPartition("T", 3);
        Set<TopicPartition> requestKeys = Set.of(tp0, tp1);
        PartitionLeaderStrategy.PartitionLeaderFuture result = new PartitionLeaderStrategy.PartitionLeaderFuture(requestKeys, partitionLeaderCache);
        AdminApiDriver<TopicPartition, Void> driver = this.buildDriver((PartitionLeaderStrategy.PartitionLeaderFuture<Void>)result);
        List requestSpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)requestSpecs.size());
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).scope.destinationBrokerId());
        Assertions.assertEquals(requestKeys, (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).keys);
        Map<TopicPartition, Integer> leaders = Map.of(tp0, 1, tp1, 2);
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(0), (AbstractResponse)this.metadataResponseWithPartitionLeaders(leaders), Node.noNode());
        Assertions.assertFalse((boolean)((KafkaFuture)result.all().get(tp0)).isDone());
        Assertions.assertFalse((boolean)((KafkaFuture)result.all().get(tp1)).isDone());
        Assertions.assertEquals((int)1, (Integer)((Integer)partitionLeaderCache.get(tp0)));
        Assertions.assertEquals((int)2, (Integer)((Integer)partitionLeaderCache.get(tp1)));
        requestSpecs = driver.poll();
        Assertions.assertEquals((int)2, (int)requestSpecs.size());
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).scope.destinationBrokerId());
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)1)).scope.destinationBrokerId());
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(0), (AbstractResponse)this.listOffsetsResponseSuccess(((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).keys), NODE_1);
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(1), (AbstractResponse)this.listOffsetsResponseSuccess(((AdminApiDriver.RequestSpec)requestSpecs.get((int)1)).keys), NODE_2);
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp0)).isDone());
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp1)).isDone());
        requestKeys = Set.of(tp1, tp2);
        result = new PartitionLeaderStrategy.PartitionLeaderFuture(requestKeys, partitionLeaderCache);
        driver = this.buildDriver((PartitionLeaderStrategy.PartitionLeaderFuture<Void>)result);
        requestSpecs = driver.poll();
        Assertions.assertEquals((int)2, (int)requestSpecs.size());
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).scope.destinationBrokerId());
        Assertions.assertEquals(Collections.singleton(tp2), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).keys);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)1)).scope.destinationBrokerId());
        leaders = Map.of(tp2, 1);
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(0), (AbstractResponse)this.metadataResponseWithPartitionLeaders(leaders), Node.noNode());
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(1), (AbstractResponse)this.listOffsetsResponseSuccess(((AdminApiDriver.RequestSpec)requestSpecs.get((int)1)).keys), NODE_2);
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp1)).isDone());
        Assertions.assertFalse((boolean)((KafkaFuture)result.all().get(tp2)).isDone());
        Assertions.assertEquals((int)1, (Integer)((Integer)partitionLeaderCache.get(tp0)));
        Assertions.assertEquals((int)2, (Integer)((Integer)partitionLeaderCache.get(tp1)));
        Assertions.assertEquals((int)1, (Integer)((Integer)partitionLeaderCache.get(tp2)));
        requestSpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)requestSpecs.size());
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).scope.destinationBrokerId());
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(0), (AbstractResponse)this.listOffsetsResponseSuccess(((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).keys), NODE_1);
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp1)).isDone());
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp2)).isDone());
        requestKeys = Set.of(tp0, tp1, tp2);
        result = new PartitionLeaderStrategy.PartitionLeaderFuture(requestKeys, partitionLeaderCache);
        driver = this.buildDriver((PartitionLeaderStrategy.PartitionLeaderFuture<Void>)result);
        requestSpecs = driver.poll();
        Assertions.assertEquals((int)2, (int)requestSpecs.size());
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).scope.destinationBrokerId());
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)1)).scope.destinationBrokerId());
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(0), (AbstractResponse)this.listOffsetsResponseSuccess(((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).keys), NODE_1);
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(1), (AbstractResponse)this.listOffsetsResponseSuccess(((AdminApiDriver.RequestSpec)requestSpecs.get((int)1)).keys), NODE_2);
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp0)).isDone());
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp1)).isDone());
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp2)).isDone());
        requestKeys = Set.of(tp0, tp1, tp2, tp3);
        result = new PartitionLeaderStrategy.PartitionLeaderFuture(requestKeys, partitionLeaderCache);
        driver = this.buildDriver((PartitionLeaderStrategy.PartitionLeaderFuture<Void>)result);
        requestSpecs = driver.poll();
        Assertions.assertEquals((int)3, (int)requestSpecs.size());
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).scope.destinationBrokerId());
        Assertions.assertEquals(Collections.singleton(tp3), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).keys);
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)1)).scope.destinationBrokerId());
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)2)).scope.destinationBrokerId());
        leaders = Map.of(tp3, 2);
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(0), (AbstractResponse)this.metadataResponseWithPartitionLeaders(leaders), Node.noNode());
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(1), (AbstractResponse)this.listOffsetsResponseSuccess(((AdminApiDriver.RequestSpec)requestSpecs.get((int)1)).keys), NODE_1);
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(2), (AbstractResponse)this.listOffsetsResponseSuccess(((AdminApiDriver.RequestSpec)requestSpecs.get((int)2)).keys), NODE_2);
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp0)).isDone());
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp1)).isDone());
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp2)).isDone());
        Assertions.assertFalse((boolean)((KafkaFuture)result.all().get(tp3)).isDone());
        Assertions.assertEquals((int)1, (Integer)((Integer)partitionLeaderCache.get(tp0)));
        Assertions.assertEquals((int)2, (Integer)((Integer)partitionLeaderCache.get(tp1)));
        Assertions.assertEquals((int)1, (Integer)((Integer)partitionLeaderCache.get(tp2)));
        Assertions.assertEquals((int)2, (Integer)((Integer)partitionLeaderCache.get(tp3)));
        requestSpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)requestSpecs.size());
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).scope.destinationBrokerId());
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(0), (AbstractResponse)this.listOffsetsResponseSuccess(((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).keys), NODE_2);
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp0)).isDone());
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp1)).isDone());
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp2)).isDone());
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp3)).isDone());
    }

    @Test
    public void testNotLeaderFulfillmentError() {
        HashMap partitionLeaderCache = new HashMap();
        TopicPartition tp0 = new TopicPartition("T", 0);
        TopicPartition tp1 = new TopicPartition("T", 1);
        Set<TopicPartition> requestKeys = Set.of(tp0, tp1);
        PartitionLeaderStrategy.PartitionLeaderFuture result = new PartitionLeaderStrategy.PartitionLeaderFuture(requestKeys, partitionLeaderCache);
        AdminApiDriver<TopicPartition, Void> driver = this.buildDriver((PartitionLeaderStrategy.PartitionLeaderFuture<Void>)result);
        List requestSpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)requestSpecs.size());
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).scope.destinationBrokerId());
        Assertions.assertEquals(requestKeys, (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).keys);
        Map<TopicPartition, Integer> leaders = Map.of(tp0, 1, tp1, 2);
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(0), (AbstractResponse)this.metadataResponseWithPartitionLeaders(leaders), Node.noNode());
        Assertions.assertFalse((boolean)((KafkaFuture)result.all().get(tp0)).isDone());
        Assertions.assertFalse((boolean)((KafkaFuture)result.all().get(tp1)).isDone());
        Assertions.assertEquals((int)1, (Integer)((Integer)partitionLeaderCache.get(tp0)));
        Assertions.assertEquals((int)2, (Integer)((Integer)partitionLeaderCache.get(tp1)));
        requestSpecs = driver.poll();
        Assertions.assertEquals((int)2, (int)requestSpecs.size());
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).scope.destinationBrokerId());
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)1)).scope.destinationBrokerId());
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(0), (AbstractResponse)this.listOffsetsResponseSuccess(((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).keys), NODE_1);
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(1), (AbstractResponse)this.listOffsetsResponseFailure(((AdminApiDriver.RequestSpec)requestSpecs.get((int)1)).keys, Errors.NOT_LEADER_OR_FOLLOWER), NODE_2);
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp0)).isDone());
        Assertions.assertFalse((boolean)((KafkaFuture)result.all().get(tp1)).isDone());
        requestSpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)requestSpecs.size());
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).scope.destinationBrokerId());
        leaders = Map.of(tp1, 1);
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(0), (AbstractResponse)this.metadataResponseWithPartitionLeaders(leaders), Node.noNode());
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp0)).isDone());
        Assertions.assertFalse((boolean)((KafkaFuture)result.all().get(tp1)).isDone());
        Assertions.assertEquals((int)1, (Integer)((Integer)partitionLeaderCache.get(tp0)));
        Assertions.assertEquals((int)1, (Integer)((Integer)partitionLeaderCache.get(tp1)));
        requestSpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)requestSpecs.size());
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).scope.destinationBrokerId());
        driver.onResponse(this.time.milliseconds(), (AdminApiDriver.RequestSpec)requestSpecs.get(0), (AbstractResponse)this.listOffsetsResponseSuccess(((AdminApiDriver.RequestSpec)requestSpecs.get((int)0)).keys), NODE_1);
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp0)).isDone());
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp1)).isDone());
    }

    @Test
    public void testFatalLookupError() {
        TopicPartition tp0 = new TopicPartition("T", 0);
        HashMap partitionLeaderCache = new HashMap();
        PartitionLeaderStrategy.PartitionLeaderFuture result = new PartitionLeaderStrategy.PartitionLeaderFuture(Collections.singleton(tp0), partitionLeaderCache);
        AdminApiDriver<TopicPartition, Void> driver = this.buildDriver((PartitionLeaderStrategy.PartitionLeaderFuture<Void>)result);
        List requestSpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)requestSpecs.size());
        AdminApiDriver.RequestSpec spec = (AdminApiDriver.RequestSpec)requestSpecs.get(0);
        Assertions.assertEquals(Collections.singleton(tp0), (Object)spec.keys);
        driver.onFailure(this.time.milliseconds(), spec, (Throwable)new UnknownServerException());
        Assertions.assertTrue((boolean)((KafkaFuture)result.all().get(tp0)).isDone());
        TestUtils.assertFutureThrows((Future)result.all().get(tp0), UnknownServerException.class);
        Assertions.assertEquals(Collections.emptyList(), (Object)driver.poll());
    }

    @Test
    public void testRetryLookupAfterDisconnect() {
        TopicPartition tp0 = new TopicPartition("T", 0);
        HashMap partitionLeaderCache = new HashMap();
        PartitionLeaderStrategy.PartitionLeaderFuture result = new PartitionLeaderStrategy.PartitionLeaderFuture(Collections.singleton(tp0), partitionLeaderCache);
        AdminApiDriver<TopicPartition, Void> driver = this.buildDriver((PartitionLeaderStrategy.PartitionLeaderFuture<Void>)result);
        List requestSpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)requestSpecs.size());
        AdminApiDriver.RequestSpec spec = (AdminApiDriver.RequestSpec)requestSpecs.get(0);
        Assertions.assertEquals(Collections.singleton(tp0), (Object)spec.keys);
        driver.onFailure(this.time.milliseconds(), spec, (Throwable)new DisconnectException());
        List retrySpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)retrySpecs.size());
        AdminApiDriver.RequestSpec retrySpec = (AdminApiDriver.RequestSpec)retrySpecs.get(0);
        Assertions.assertEquals(Collections.singleton(tp0), (Object)retrySpec.keys);
        Assertions.assertEquals((long)this.time.milliseconds(), (long)retrySpec.nextAllowedTryMs);
        Assertions.assertEquals(Collections.emptyList(), (Object)driver.poll());
    }

    private MetadataResponse metadataResponseWithPartitionLeaders(Map<TopicPartition, Integer> mapping) {
        MetadataResponseData response = new MetadataResponseData();
        mapping.forEach((tp, brokerId) -> response.topics().add((ImplicitLinkedHashCollection.Element)new MetadataResponseData.MetadataResponseTopic().setName(tp.topic()).setPartitions(Collections.singletonList(new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(tp.partition()).setLeaderId(brokerId.intValue())))));
        return new MetadataResponse(response, ApiKeys.METADATA.latestVersion());
    }

    private ListOffsetsResponse listOffsetsResponseSuccess(Set<TopicPartition> keys) {
        ListOffsetsResponseData response = new ListOffsetsResponseData();
        keys.forEach(tp -> {
            ListOffsetsResponseData.ListOffsetsPartitionResponse partResponse = new ListOffsetsResponseData.ListOffsetsPartitionResponse().setPartitionIndex(tp.partition());
            ListOffsetsResponseData.ListOffsetsTopicResponse topicResponse = new ListOffsetsResponseData.ListOffsetsTopicResponse().setName(tp.topic()).setPartitions(Collections.singletonList(partResponse));
            response.topics().add(topicResponse);
        });
        return new ListOffsetsResponse(response);
    }

    private ListOffsetsResponse listOffsetsResponseFailure(Set<TopicPartition> keys, Errors error) {
        ListOffsetsResponseData response = new ListOffsetsResponseData();
        keys.forEach(tp -> {
            ListOffsetsResponseData.ListOffsetsPartitionResponse partResponse = new ListOffsetsResponseData.ListOffsetsPartitionResponse().setPartitionIndex(tp.partition()).setErrorCode(error.code());
            ListOffsetsResponseData.ListOffsetsTopicResponse topicResponse = new ListOffsetsResponseData.ListOffsetsTopicResponse().setName(tp.topic()).setPartitions(Collections.singletonList(partResponse));
            response.topics().add(topicResponse);
        });
        return new ListOffsetsResponse(response);
    }

    private class MockApiHandler
    extends AdminApiHandler.Batched<TopicPartition, Void> {
        private final PartitionLeaderStrategy partitionLeaderStrategy;

        private MockApiHandler() {
            this.partitionLeaderStrategy = new PartitionLeaderStrategy(PartitionLeaderStrategyIntegrationTest.this.logContext);
        }

        public String apiName() {
            return "mock-api";
        }

        public AbstractRequest.Builder<?> buildBatchedRequest(int brokerId, Set<TopicPartition> keys) {
            return new MetadataRequest.Builder(new MetadataRequestData());
        }

        public AdminApiHandler.ApiResult<TopicPartition, Void> handleResponse(Node broker, Set<TopicPartition> keys, AbstractResponse abstractResponse) {
            ListOffsetsResponse response = (ListOffsetsResponse)abstractResponse;
            HashMap completed = new HashMap();
            HashMap failed = new HashMap();
            ArrayList unmapped = new ArrayList();
            response.topics().forEach(topic -> topic.partitions().forEach(partition -> {
                TopicPartition tp = new TopicPartition(topic.name(), partition.partitionIndex());
                if (partition.errorCode() != Errors.NONE.code()) {
                    ApiException exception = Errors.forCode((short)partition.errorCode()).exception();
                    if (exception instanceof NotLeaderOrFollowerException || exception instanceof LeaderNotAvailableException) {
                        unmapped.add(tp);
                    } else if (!(exception instanceof RetriableException)) {
                        failed.put(tp, Errors.forCode((short)partition.errorCode()).exception());
                    }
                } else {
                    completed.put(tp, null);
                }
            }));
            return new AdminApiHandler.ApiResult(completed, failed, unmapped);
        }

        public PartitionLeaderStrategy lookupStrategy() {
            return this.partitionLeaderStrategy;
        }
    }
}

