/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.AbstractHeartbeatRequestManager;
import org.apache.kafka.clients.consumer.internals.AbstractMembershipManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.CoordinatorRequestManager;
import org.apache.kafka.clients.consumer.internals.MemberState;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.ShareHeartbeatRequestManager;
import org.apache.kafka.clients.consumer.internals.ShareMembershipManager;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.clients.consumer.internals.events.ErrorEvent;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ShareGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ShareGroupHeartbeatRequest;
import org.apache.kafka.common.requests.ShareGroupHeartbeatResponse;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ShareHeartbeatRequestManagerTest {
    private static final String DEFAULT_GROUP_ID = "groupId";
    private static final String DEFAULT_MEMBER_ID = "member-id";
    private static final int DEFAULT_MEMBER_EPOCH = 1;
    private static final int DEFAULT_HEARTBEAT_INTERVAL_MS = 1000;
    private static final int DEFAULT_MAX_POLL_INTERVAL_MS = 10000;
    private static final long DEFAULT_RETRY_BACKOFF_MS = 80L;
    private static final long DEFAULT_RETRY_BACKOFF_MAX_MS = 1000L;
    private static final double DEFAULT_HEARTBEAT_JITTER_MS = 0.0;
    private static final String SHARE_CONSUMER_COORDINATOR_METRICS = "consumer-share-coordinator-metrics";
    private Time time;
    private Timer pollTimer;
    private CoordinatorRequestManager coordinatorRequestManager;
    private SubscriptionState subscriptions;
    private Metadata metadata;
    private ShareHeartbeatRequestManager heartbeatRequestManager;
    private ShareMembershipManager membershipManager;
    private AbstractHeartbeatRequestManager.HeartbeatRequestState heartbeatRequestState;
    private ShareHeartbeatRequestManager.HeartbeatState heartbeatState;
    private BackgroundEventHandler backgroundEventHandler;
    private Metrics metrics;
    private LogContext logContext;

    @BeforeEach
    public void setUp() {
        this.time = new MockTime();
        this.pollTimer = (Timer)Mockito.spy((Object)this.time.timer(10000L));
        this.coordinatorRequestManager = (CoordinatorRequestManager)Mockito.mock(CoordinatorRequestManager.class);
        this.subscriptions = (SubscriptionState)Mockito.mock(SubscriptionState.class);
        this.backgroundEventHandler = (BackgroundEventHandler)Mockito.mock(BackgroundEventHandler.class);
        this.membershipManager = (ShareMembershipManager)Mockito.mock(ShareMembershipManager.class);
        this.heartbeatState = (ShareHeartbeatRequestManager.HeartbeatState)Mockito.mock(ShareHeartbeatRequestManager.HeartbeatState.class);
        this.metadata = (Metadata)Mockito.mock(ConsumerMetadata.class);
        this.metrics = new Metrics(this.time);
        this.logContext = new LogContext();
        ConsumerConfig config = (ConsumerConfig)Mockito.mock(ConsumerConfig.class);
        this.heartbeatRequestState = (AbstractHeartbeatRequestManager.HeartbeatRequestState)Mockito.spy((Object)new AbstractHeartbeatRequestManager.HeartbeatRequestState(this.logContext, this.time, 1000L, 80L, 1000L, 0.0));
        this.heartbeatRequestManager = new ShareHeartbeatRequestManager(this.logContext, this.pollTimer, config, this.coordinatorRequestManager, this.membershipManager, this.heartbeatState, this.heartbeatRequestState, this.backgroundEventHandler, this.metrics);
        Mockito.when((Object)this.coordinatorRequestManager.coordinator()).thenReturn(Optional.of(new Node(1, "localhost", 9999)));
    }

    private void createHeartbeatRequestStateWithZeroHeartbeatInterval() {
        this.heartbeatRequestState = (AbstractHeartbeatRequestManager.HeartbeatRequestState)Mockito.spy((Object)new AbstractHeartbeatRequestManager.HeartbeatRequestState(this.logContext, this.time, 0L, 80L, 1000L, 0.0));
        this.heartbeatRequestManager = this.createHeartbeatRequestManager(this.coordinatorRequestManager, this.membershipManager, this.heartbeatState, this.heartbeatRequestState, this.backgroundEventHandler);
    }

    private void createHeartbeatStateAndRequestManager() {
        this.heartbeatState = new ShareHeartbeatRequestManager.HeartbeatState(this.subscriptions, this.membershipManager);
        this.heartbeatRequestManager = this.createHeartbeatRequestManager(this.coordinatorRequestManager, this.membershipManager, this.heartbeatState, this.heartbeatRequestState, this.backgroundEventHandler);
    }

    @Test
    public void testHeartbeatOnStartup() {
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
        this.createHeartbeatRequestStateWithZeroHeartbeatInterval();
        Assertions.assertEquals((long)0L, (long)this.heartbeatRequestManager.maximumTimeToWait(this.time.milliseconds()));
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        NetworkClientDelegate.PollResult result2 = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result2.unsentRequests.size());
    }

    @Test
    public void testSuccessfulHeartbeatTiming() {
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size(), (String)"No heartbeat should be sent while interval has not expired");
        Assertions.assertEquals((long)this.heartbeatRequestState.timeToNextHeartbeatMs(this.time.milliseconds()), (long)result.timeUntilNextPollMs);
        this.assertNextHeartbeatTiming(1000L);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size(), (String)"A heartbeat should be sent when interval expires");
        NetworkClientDelegate.UnsentRequest inflightReq = (NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0);
        Assertions.assertEquals((long)1000L, (long)this.heartbeatRequestState.timeToNextHeartbeatMs(this.time.milliseconds()), (String)"Heartbeat timer was not reset to the interval when the heartbeat request was sent.");
        long partOfInterval = 333L;
        this.time.sleep(partOfInterval);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size(), (String)"No heartbeat should be sent while only part of the interval has passed");
        Assertions.assertEquals((long)(1000L - partOfInterval), (long)this.heartbeatRequestState.timeToNextHeartbeatMs(this.time.milliseconds()), (String)"Time to next interval was not properly updated.");
        inflightReq.handler().onComplete(this.createHeartbeatResponse(inflightReq, Errors.NONE));
        this.assertNextHeartbeatTiming(1000L - partOfInterval);
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.SHARE_GROUP_HEARTBEAT)
    public void testFirstHeartbeatIncludesRequiredInfoToJoinGroupAndGetAssignments(short version) {
        this.createHeartbeatStateAndRequestManager();
        this.createHeartbeatRequestStateWithZeroHeartbeatInterval();
        this.time.sleep(1000L);
        String topic = "topic1";
        Set<String> set = Collections.singleton(topic);
        Mockito.when((Object)this.subscriptions.subscription()).thenReturn(set);
        this.subscriptions.subscribeToShareGroup(set);
        this.mockJoiningMemberData();
        Assertions.assertEquals((long)0L, (long)this.heartbeatRequestManager.maximumTimeToWait(this.time.milliseconds()));
        NetworkClientDelegate.PollResult pollResult = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)pollResult.unsentRequests.size());
        NetworkClientDelegate.UnsentRequest request = (NetworkClientDelegate.UnsentRequest)pollResult.unsentRequests.get(0);
        Assertions.assertInstanceOf(ShareGroupHeartbeatRequest.Builder.class, (Object)request.requestBuilder());
        ShareGroupHeartbeatRequest heartbeatRequest = (ShareGroupHeartbeatRequest)request.requestBuilder().build(version);
        Assertions.assertTrue((boolean)heartbeatRequest.data().memberId().isEmpty());
        Assertions.assertEquals((int)0, (int)heartbeatRequest.data().memberEpoch());
        Assertions.assertEquals(Collections.singletonList(topic), (Object)heartbeatRequest.data().subscribedTopicNames());
        Assertions.assertEquals((Object)DEFAULT_GROUP_ID, (Object)heartbeatRequest.data().groupId());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSkippingHeartbeat(boolean shouldSkipHeartbeat) {
        this.createHeartbeatRequestStateWithZeroHeartbeatInterval();
        Mockito.when((Object)this.membershipManager.shouldSkipHeartbeat()).thenReturn((Object)shouldSkipHeartbeat);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        if (!shouldSkipHeartbeat) {
            Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
            Assertions.assertEquals((long)0L, (long)result.timeUntilNextPollMs);
        } else {
            Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
            Assertions.assertEquals((long)Long.MAX_VALUE, (long)result.timeUntilNextPollMs);
        }
    }

    @Test
    public void testTimerNotDue() {
        this.time.sleep(100L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
        Assertions.assertEquals((long)900L, (long)result.timeUntilNextPollMs);
        Assertions.assertEquals((long)900L, (long)this.heartbeatRequestManager.maximumTimeToWait(this.time.milliseconds()));
        Mockito.when((Object)this.subscriptions.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.membershipManager.shouldSkipHeartbeat()).thenReturn((Object)true);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)result.timeUntilNextPollMs);
    }

    @Test
    public void testHeartbeatNotSentIfAnotherOneInFlight() {
        this.time.sleep(1000L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        NetworkClientDelegate.UnsentRequest inflightReq = (NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0);
        this.time.sleep(1000L);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size(), (String)"No heartbeat should be sent while a previous one in-flight");
        this.time.sleep(1000L);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size(), (String)"No heartbeat should be sent when the interval expires if there is a previous heartbeat request in-flight");
        inflightReq.handler().onComplete(this.createHeartbeatResponse(inflightReq, Errors.NONE));
        this.time.sleep(80L);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size(), (String)"A next heartbeat should be sent on the first poll after receiving a response that took longer than the interval, waiting only for the minimal backoff.");
    }

    @Test
    public void testHeartbeatOutsideInterval() {
        Mockito.when((Object)this.membershipManager.shouldSkipHeartbeat()).thenReturn((Object)false);
        Mockito.when((Object)this.membershipManager.shouldHeartbeatNow()).thenReturn((Object)true);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        Assertions.assertEquals((long)1000L, (long)result.timeUntilNextPollMs);
        Assertions.assertEquals((long)1000L, (long)this.heartbeatRequestManager.maximumTimeToWait(this.time.milliseconds()));
        ((ShareMembershipManager)Mockito.verify((Object)this.membershipManager)).onHeartbeatRequestGenerated();
    }

    @Test
    public void testNetworkTimeout() {
        this.createHeartbeatRequestStateWithZeroHeartbeatInterval();
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        ((NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0)).handler().onFailure(this.time.milliseconds(), (RuntimeException)new TimeoutException("timeout"));
        ((ShareMembershipManager)Mockito.verify((Object)this.membershipManager)).onHeartbeatFailure(true);
        ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler, (VerificationMode)Mockito.never())).add((BackgroundEvent)ArgumentMatchers.any());
        this.time.sleep(79L);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
        this.time.sleep(1L);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
    }

    @Test
    public void testFailureOnFatalException() {
        this.time.sleep(1000L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        ((NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0)).handler().onFailure(this.time.milliseconds(), (RuntimeException)((Object)new KafkaException("fatal")));
        ((ShareMembershipManager)Mockito.verify((Object)this.membershipManager)).transitionToFatal();
        ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler)).add((BackgroundEvent)ArgumentMatchers.any());
    }

    @Test
    public void testNoCoordinator() {
        Mockito.when((Object)this.coordinatorRequestManager.coordinator()).thenReturn(Optional.empty());
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)result.timeUntilNextPollMs);
        Assertions.assertEquals((long)1000L, (long)this.heartbeatRequestManager.maximumTimeToWait(this.time.milliseconds()));
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
    }

    @ParameterizedTest
    @MethodSource(value={"errorProvider"})
    public void testHeartbeatResponseOnErrorHandling(Errors error, boolean isFatal) {
        this.time.sleep(1000L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        Mockito.when((Object)this.subscriptions.hasAutoAssignedPartitions()).thenReturn((Object)true);
        ClientResponse response = this.createHeartbeatResponse((NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0), error);
        ((NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0)).handler().onComplete(response);
        ShareGroupHeartbeatResponse mockResponse = (ShareGroupHeartbeatResponse)response.responseBody();
        switch (error) {
            case NONE: {
                ((ShareMembershipManager)Mockito.verify((Object)this.membershipManager)).onHeartbeatSuccess(mockResponse);
                this.assertNextHeartbeatTiming(1000L);
                break;
            }
            case COORDINATOR_LOAD_IN_PROGRESS: {
                ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler, (VerificationMode)Mockito.never())).add((BackgroundEvent)ArgumentMatchers.any());
                this.assertNextHeartbeatTiming(80L);
                break;
            }
            case COORDINATOR_NOT_AVAILABLE: 
            case NOT_COORDINATOR: {
                ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler, (VerificationMode)Mockito.never())).add((BackgroundEvent)ArgumentMatchers.any());
                ((CoordinatorRequestManager)Mockito.verify((Object)this.coordinatorRequestManager)).markCoordinatorUnknown((String)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
                this.assertNextHeartbeatTiming(0L);
                break;
            }
            case UNKNOWN_MEMBER_ID: {
                ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler, (VerificationMode)Mockito.never())).add((BackgroundEvent)ArgumentMatchers.any());
                this.assertNextHeartbeatTiming(0L);
                break;
            }
            default: {
                if (isFatal) {
                    Mockito.when((Object)this.coordinatorRequestManager.coordinator()).thenReturn(Optional.empty());
                    this.ensureFatalError(error);
                    break;
                }
                ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler, (VerificationMode)Mockito.never())).add((BackgroundEvent)ArgumentMatchers.any());
                this.assertNextHeartbeatTiming(0L);
            }
        }
        if (error != Errors.NONE) {
            ((ShareMembershipManager)Mockito.verify((Object)this.membershipManager)).onHeartbeatFailure(false);
        }
        if (!isFatal) {
            this.time.sleep(1000L);
            result = this.heartbeatRequestManager.poll(this.time.milliseconds());
            Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"The cluster does not support the share group protocol. To use share groups, the cluster must have the share group protocol enabled."})
    public void testUnsupportedVersionGeneratedOnTheBroker(String errorMsg) {
        this.mockResponseWithException(new UnsupportedVersionException(errorMsg), true);
        ArgumentCaptor errorEventArgumentCaptor = ArgumentCaptor.forClass(ErrorEvent.class);
        ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler)).add((BackgroundEvent)errorEventArgumentCaptor.capture());
        ErrorEvent errorEvent = (ErrorEvent)errorEventArgumentCaptor.getValue();
        Assertions.assertInstanceOf(Errors.UNSUPPORTED_VERSION.exception().getClass(), (Object)errorEvent.error());
        Assertions.assertEquals((Object)errorMsg, (Object)errorEvent.error().getMessage());
        Mockito.clearInvocations((Object[])new BackgroundEventHandler[]{this.backgroundEventHandler});
    }

    @ParameterizedTest
    @ValueSource(strings={"The cluster does not support the share group protocol. To use share groups, the cluster must have the share group protocol enabled."})
    public void testUnsupportedVersionGeneratedOnTheClient(String errorMsg) {
        this.mockResponseWithException(new UnsupportedVersionException(errorMsg), false);
        ArgumentCaptor errorEventArgumentCaptor = ArgumentCaptor.forClass(ErrorEvent.class);
        ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler)).add((BackgroundEvent)errorEventArgumentCaptor.capture());
        ErrorEvent errorEvent = (ErrorEvent)errorEventArgumentCaptor.getValue();
        Assertions.assertInstanceOf(Errors.UNSUPPORTED_VERSION.exception().getClass(), (Object)errorEvent.error());
        Assertions.assertEquals((Object)errorMsg, (Object)errorEvent.error().getMessage());
        Mockito.clearInvocations((Object[])new BackgroundEventHandler[]{this.backgroundEventHandler});
    }

    private void mockResponseWithException(UnsupportedVersionException exception, boolean isFromBroker) {
        this.time.sleep(1000L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        Mockito.when((Object)this.subscriptions.hasAutoAssignedPartitions()).thenReturn((Object)true);
        ClientResponse response = this.createHeartbeatResponseWithException((NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0), exception, isFromBroker);
        ((NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0)).handler().onComplete(response);
    }

    @Test
    public void testHeartbeatState() {
        this.mockJoiningMemberData();
        this.heartbeatState = new ShareHeartbeatRequestManager.HeartbeatState(this.subscriptions, this.membershipManager);
        this.createHeartbeatRequestStateWithZeroHeartbeatInterval();
        ShareGroupHeartbeatRequestData data = this.heartbeatState.buildRequestData();
        Assertions.assertEquals((Object)DEFAULT_GROUP_ID, (Object)data.groupId());
        Assertions.assertEquals((Object)"", (Object)data.memberId());
        Assertions.assertEquals((int)0, (int)data.memberEpoch());
        Assertions.assertEquals(Collections.emptyList(), (Object)data.subscribedTopicNames());
        this.membershipManager.onHeartbeatRequestGenerated();
        Mockito.when((Object)this.membershipManager.state()).thenReturn((Object)MemberState.STABLE);
        Mockito.when((Object)this.subscriptions.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptions.rebalanceListener()).thenReturn(Optional.empty());
        this.mockStableMemberData();
        data = this.heartbeatState.buildRequestData();
        Assertions.assertEquals((Object)DEFAULT_GROUP_ID, (Object)data.groupId());
        Assertions.assertEquals((Object)DEFAULT_MEMBER_ID, (Object)data.memberId());
        Assertions.assertEquals((int)1, (int)data.memberEpoch());
        Assertions.assertNull((Object)data.subscribedTopicNames());
        this.membershipManager.onHeartbeatRequestGenerated();
        String topic = "topic1";
        this.subscriptions.subscribe(Collections.singleton(topic), Optional.empty());
        Mockito.when((Object)this.subscriptions.subscription()).thenReturn(Collections.singleton(topic));
        this.mockRejoiningMemberData();
        data = this.heartbeatState.buildRequestData();
        Assertions.assertEquals((Object)DEFAULT_GROUP_ID, (Object)data.groupId());
        Assertions.assertEquals((Object)DEFAULT_MEMBER_ID, (Object)data.memberId());
        Assertions.assertEquals((int)0, (int)data.memberEpoch());
        Assertions.assertEquals(Collections.singletonList(topic), (Object)data.subscribedTopicNames());
        this.membershipManager.onHeartbeatRequestGenerated();
        data = this.heartbeatState.buildRequestData();
        Assertions.assertEquals((Object)DEFAULT_GROUP_ID, (Object)data.groupId());
        Assertions.assertEquals((Object)DEFAULT_MEMBER_ID, (Object)data.memberId());
        Assertions.assertEquals((int)0, (int)data.memberEpoch());
        Assertions.assertEquals(Collections.singletonList(topic), (Object)data.subscribedTopicNames());
        ShareGroupHeartbeatResponseData.TopicPartitions tpTopic1 = new ShareGroupHeartbeatResponseData.TopicPartitions();
        Uuid topicId = Uuid.randomUuid();
        tpTopic1.setTopicId(topicId);
        tpTopic1.setPartitions(Collections.singletonList(0));
        ShareGroupHeartbeatResponseData.Assignment assignmentTopic1 = new ShareGroupHeartbeatResponseData.Assignment();
        assignmentTopic1.setTopicPartitions(Collections.singletonList(tpTopic1));
        ShareGroupHeartbeatResponse rs1 = new ShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData().setHeartbeatIntervalMs(1000).setMemberId(DEFAULT_MEMBER_ID).setMemberEpoch(1).setAssignment(assignmentTopic1));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, "topic1"));
        this.membershipManager.onHeartbeatSuccess(rs1);
    }

    @Test
    public void testPollTimerExpiration() {
        this.heartbeatRequestManager = this.createHeartbeatRequestManager(this.coordinatorRequestManager, this.membershipManager, this.heartbeatState, this.heartbeatRequestState, this.backgroundEventHandler);
        Mockito.when((Object)this.membershipManager.shouldSkipHeartbeat()).thenReturn((Object)false);
        this.time.sleep(10000L);
        this.assertHeartbeat(this.heartbeatRequestManager, 1000);
        ((ShareMembershipManager)Mockito.verify((Object)this.membershipManager)).transitionToSendingLeaveGroup(true);
        ((ShareHeartbeatRequestManager.HeartbeatState)Mockito.verify((Object)this.heartbeatState)).reset();
        ((AbstractHeartbeatRequestManager.HeartbeatRequestState)Mockito.verify((Object)this.heartbeatRequestState)).reset();
        ((ShareMembershipManager)Mockito.verify((Object)this.membershipManager)).onHeartbeatRequestGenerated();
        Mockito.when((Object)this.membershipManager.shouldSkipHeartbeat()).thenReturn((Object)true);
        this.assertNoHeartbeat(this.heartbeatRequestManager);
        this.heartbeatRequestManager.resetPollTimer(this.time.milliseconds());
        Assertions.assertTrue((boolean)this.pollTimer.notExpired());
        ((ShareMembershipManager)Mockito.verify((Object)this.membershipManager)).maybeRejoinStaleMember();
        Mockito.when((Object)this.membershipManager.shouldSkipHeartbeat()).thenReturn((Object)false);
        this.assertHeartbeat(this.heartbeatRequestManager, 1000);
    }

    @Test
    public void testPollTimerExpirationShouldNotMarkMemberStaleIfMemberAlreadyLeaving() {
        Mockito.when((Object)this.membershipManager.shouldSkipHeartbeat()).thenReturn((Object)false);
        Mockito.when((Object)this.membershipManager.isLeavingGroup()).thenReturn((Object)true);
        this.time.sleep(10000L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        ((ShareMembershipManager)Mockito.verify((Object)this.membershipManager, (VerificationMode)Mockito.never())).transitionToSendingLeaveGroup(ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size(), (String)"A heartbeat request should be generated to complete the ongoing leaving operation that was triggered before the poll timer expired.");
    }

    @Test
    public void testHeartbeatMetrics() {
        Assertions.assertNotNull((Object)this.getMetric("heartbeat-response-time-max"));
        Assertions.assertNotNull((Object)this.getMetric("heartbeat-rate"));
        Assertions.assertNotNull((Object)this.getMetric("heartbeat-total"));
        Assertions.assertNotNull((Object)this.getMetric("last-heartbeat-seconds-ago"));
        this.time.sleep(1000L);
        this.assertHeartbeat(this.heartbeatRequestManager, 1000);
        this.time.sleep(1000L);
        Assertions.assertEquals((Object)1.0, (Object)this.getMetric("heartbeat-total").metricValue());
        Assertions.assertEquals((Object)TimeUnit.MILLISECONDS.toSeconds(1000L), (Object)this.getMetric("last-heartbeat-seconds-ago").metricValue());
        this.assertHeartbeat(this.heartbeatRequestManager, 1000);
        Assertions.assertEquals((double)0.06, (double)((Double)this.getMetric("heartbeat-rate").metricValue()), (double)0.005);
        Assertions.assertEquals((Object)2.0, (Object)this.getMetric("heartbeat-total").metricValue());
        Random rand = new Random();
        int randomSleepS = rand.nextInt(11);
        this.time.sleep((long)(randomSleepS * 1000));
        Assertions.assertEquals((Object)randomSleepS, (Object)this.getMetric("last-heartbeat-seconds-ago").metricValue());
    }

    private void assertHeartbeat(ShareHeartbeatRequestManager hrm, int nextPollMs) {
        NetworkClientDelegate.PollResult pollResult = hrm.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)pollResult.unsentRequests.size());
        Assertions.assertEquals((long)nextPollMs, (long)pollResult.timeUntilNextPollMs);
        ((NetworkClientDelegate.UnsentRequest)pollResult.unsentRequests.get(0)).handler().onComplete(this.createHeartbeatResponse((NetworkClientDelegate.UnsentRequest)pollResult.unsentRequests.get(0), Errors.NONE));
    }

    private void assertNoHeartbeat(ShareHeartbeatRequestManager hrm) {
        NetworkClientDelegate.PollResult pollResult = hrm.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)pollResult.unsentRequests.size());
    }

    private void assertNextHeartbeatTiming(long expectedTimeToNextHeartbeatMs) {
        long currentTimeMs = this.time.milliseconds();
        Assertions.assertEquals((long)expectedTimeToNextHeartbeatMs, (long)this.heartbeatRequestState.timeToNextHeartbeatMs(currentTimeMs));
        if (expectedTimeToNextHeartbeatMs != 0L) {
            Assertions.assertFalse((boolean)this.heartbeatRequestState.canSendRequest(currentTimeMs));
            this.time.sleep(expectedTimeToNextHeartbeatMs);
        }
        Assertions.assertTrue((boolean)this.heartbeatRequestState.canSendRequest(this.time.milliseconds()));
    }

    private void ensureFatalError(Errors expectedError) {
        ((ShareMembershipManager)Mockito.verify((Object)this.membershipManager)).transitionToFatal();
        ArgumentCaptor errorEventArgumentCaptor = ArgumentCaptor.forClass(ErrorEvent.class);
        ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler)).add((BackgroundEvent)errorEventArgumentCaptor.capture());
        ErrorEvent errorEvent = (ErrorEvent)errorEventArgumentCaptor.getValue();
        Assertions.assertInstanceOf(expectedError.exception().getClass(), (Object)errorEvent.error(), (String)"The fatal error propagated to the app thread does not match the error received in the heartbeat response.");
        this.ensureHeartbeatStopped();
    }

    private void ensureHeartbeatStopped() {
        this.time.sleep(1000L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
    }

    private static Collection<Arguments> errorProvider() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{Errors.NONE, false}), Arguments.of((Object[])new Object[]{Errors.COORDINATOR_NOT_AVAILABLE, false}), Arguments.of((Object[])new Object[]{Errors.COORDINATOR_LOAD_IN_PROGRESS, false}), Arguments.of((Object[])new Object[]{Errors.NOT_COORDINATOR, false}), Arguments.of((Object[])new Object[]{Errors.GROUP_AUTHORIZATION_FAILED, true}), Arguments.of((Object[])new Object[]{Errors.INVALID_REQUEST, true}), Arguments.of((Object[])new Object[]{Errors.UNKNOWN_MEMBER_ID, false}), Arguments.of((Object[])new Object[]{Errors.FENCED_MEMBER_EPOCH, false}), Arguments.of((Object[])new Object[]{Errors.UNSUPPORTED_ASSIGNOR, true}), Arguments.of((Object[])new Object[]{Errors.UNSUPPORTED_VERSION, true}), Arguments.of((Object[])new Object[]{Errors.UNRELEASED_INSTANCE_ID, true}), Arguments.of((Object[])new Object[]{Errors.GROUP_MAX_SIZE_REACHED, true}));
    }

    private ClientResponse createHeartbeatResponse(NetworkClientDelegate.UnsentRequest request, Errors error) {
        ShareGroupHeartbeatResponseData data = new ShareGroupHeartbeatResponseData().setErrorCode(error.code()).setHeartbeatIntervalMs(1000).setMemberId(DEFAULT_MEMBER_ID).setMemberEpoch(1);
        if (error != Errors.NONE) {
            data.setErrorMessage("stubbed error message");
        }
        ShareGroupHeartbeatResponse response = new ShareGroupHeartbeatResponse(data);
        return new ClientResponse(new RequestHeader(ApiKeys.SHARE_GROUP_HEARTBEAT, ApiKeys.SHARE_GROUP_HEARTBEAT.latestVersion(), "client-id", 1), (RequestCompletionHandler)request.handler(), "0", this.time.milliseconds(), this.time.milliseconds(), false, null, null, (AbstractResponse)response);
    }

    private ClientResponse createHeartbeatResponseWithException(NetworkClientDelegate.UnsentRequest request, UnsupportedVersionException exception, boolean isFromClient) {
        ShareGroupHeartbeatResponse response = null;
        if (!isFromClient) {
            response = new ShareGroupHeartbeatResponse(null);
        }
        return new ClientResponse(new RequestHeader(ApiKeys.SHARE_GROUP_HEARTBEAT, ApiKeys.SHARE_GROUP_HEARTBEAT.latestVersion(), "client-id", 1), (RequestCompletionHandler)request.handler(), "0", this.time.milliseconds(), this.time.milliseconds(), false, exception, null, (AbstractResponse)response);
    }

    private ConsumerConfig config() {
        Properties prop = new Properties();
        prop.put("key.deserializer", StringDeserializer.class);
        prop.put("value.deserializer", StringDeserializer.class);
        prop.setProperty("bootstrap.servers", "localhost:9999");
        prop.setProperty("max.poll.interval.ms", String.valueOf(10000));
        prop.setProperty("retry.backoff.ms", String.valueOf(80L));
        prop.setProperty("retry.backoff.max.ms", String.valueOf(1000L));
        return new ConsumerConfig(prop);
    }

    private KafkaMetric getMetric(String name) {
        return (KafkaMetric)this.metrics.metrics().get(this.metrics.metricName(name, SHARE_CONSUMER_COORDINATOR_METRICS));
    }

    private ShareHeartbeatRequestManager createHeartbeatRequestManager(CoordinatorRequestManager coordinatorRequestManager, ShareMembershipManager membershipManager, ShareHeartbeatRequestManager.HeartbeatState heartbeatState, AbstractHeartbeatRequestManager.HeartbeatRequestState heartbeatRequestState, BackgroundEventHandler backgroundEventHandler) {
        LogContext logContext = new LogContext();
        this.pollTimer = this.time.timer(10000L);
        return new ShareHeartbeatRequestManager(logContext, this.pollTimer, this.config(), coordinatorRequestManager, membershipManager, heartbeatState, heartbeatRequestState, backgroundEventHandler, new Metrics());
    }

    private void mockJoiningMemberData() {
        Mockito.when((Object)this.membershipManager.state()).thenReturn((Object)MemberState.JOINING);
        Mockito.when((Object)this.membershipManager.groupId()).thenReturn((Object)DEFAULT_GROUP_ID);
        Mockito.when((Object)this.membershipManager.memberId()).thenReturn((Object)"");
        Mockito.when((Object)this.membershipManager.memberEpoch()).thenReturn((Object)0);
    }

    private void mockRejoiningMemberData() {
        Mockito.when((Object)this.membershipManager.state()).thenReturn((Object)MemberState.JOINING);
        Mockito.when((Object)this.membershipManager.memberEpoch()).thenReturn((Object)0);
    }

    private void mockStableMemberData() {
        Mockito.when((Object)this.membershipManager.currentAssignment()).thenReturn((Object)new AbstractMembershipManager.LocalAssignment(0L, Collections.emptyMap()));
        Mockito.when((Object)this.membershipManager.groupId()).thenReturn((Object)DEFAULT_GROUP_ID);
        Mockito.when((Object)this.membershipManager.memberId()).thenReturn((Object)DEFAULT_MEMBER_ID);
        Mockito.when((Object)this.membershipManager.memberEpoch()).thenReturn((Object)1);
    }
}

