/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.provider.EnvVarConfigProvider;
import org.apache.kafka.common.config.provider.FileConfigProvider;
import org.apache.kafka.common.config.provider.MockFileConfigProvider;
import org.apache.kafka.common.config.provider.MockVaultConfigProvider;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metrics.FakeMetricsReporter;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class AbstractConfigTest {
    private String propertyValue;

    @BeforeEach
    public void setup() {
        this.propertyValue = System.getProperty("org.apache.kafka.automatic.config.providers");
        System.clearProperty("org.apache.kafka.automatic.config.providers");
    }

    @AfterEach
    public void teardown() {
        if (this.propertyValue != null) {
            System.setProperty("org.apache.kafka.automatic.config.providers", this.propertyValue);
        } else {
            System.clearProperty("org.apache.kafka.automatic.config.providers");
        }
    }

    @Test
    public void testConfiguredInstances() {
        this.testValidInputs("    ");
        this.testValidInputs("");
        this.testValidInputs("org.apache.kafka.common.metrics.FakeMetricsReporter");
        this.testValidInputs(" org.apache.kafka.common.metrics.FakeMetricsReporter ");
        this.testValidInputs("org.apache.kafka.common.metrics.FakeMetricsReporter, org.apache.kafka.common.metrics.FakeMetricsReporter");
        this.testInvalidInputs(",");
        this.testInvalidInputs("org.apache.kafka.clients.producer.unknown-metrics-reporter");
        this.testInvalidInputs("test1,test2");
        this.testInvalidInputs("org.apache.kafka.common.metrics.FakeMetricsReporter,");
    }

    @Test
    public void testEmptyList() {
        ConfigDef configDef = new ConfigDef().define("a", ConfigDef.Type.LIST, (Object)"", (ConfigDef.Validator)new ConfigDef.NonNullValidator(), ConfigDef.Importance.HIGH, "doc");
        AbstractConfig conf = new AbstractConfig(configDef, Collections.emptyMap());
        Assertions.assertEquals(Collections.emptyList(), (Object)conf.getList("a"));
        conf = new AbstractConfig(configDef, Collections.singletonMap("a", ""));
        Assertions.assertEquals(Collections.emptyList(), (Object)conf.getList("a"));
        conf = new AbstractConfig(configDef, Collections.singletonMap("a", "b,c,d"));
        Assertions.assertEquals(Arrays.asList("b", "c", "d"), (Object)conf.getList("a"));
    }

    @Test
    public void testOriginalsWithPrefix() {
        Properties props = new Properties();
        props.put("foo.bar", "abc");
        props.put("setting", "def");
        TestConfig config = new TestConfig(props);
        Map originalsWithPrefix = config.originalsWithPrefix("foo.");
        Assertions.assertTrue((boolean)config.unused().contains("foo.bar"));
        originalsWithPrefix.get("bar");
        Assertions.assertFalse((boolean)config.unused().contains("foo.bar"));
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("bar", "abc");
        Assertions.assertEquals(expected, (Object)originalsWithPrefix);
    }

    @Test
    public void testValuesWithPrefixOverride() {
        String prefix = "prefix.";
        Properties props = new Properties();
        props.put("sasl.mechanism", "PLAIN");
        props.put("prefix.sasl.mechanism", "GSSAPI");
        props.put("prefix.sasl.kerberos.kinit.cmd", "/usr/bin/kinit2");
        props.put("prefix.ssl.truststore.location", "my location");
        props.put("sasl.kerberos.service.name", "service name");
        props.put("ssl.keymanager.algorithm", "algorithm");
        TestSecurityConfig config = new TestSecurityConfig(props);
        Map valuesWithPrefixOverride = config.valuesWithPrefixOverride(prefix);
        Assertions.assertTrue((boolean)config.unused().contains("prefix.sasl.mechanism"));
        Assertions.assertTrue((boolean)config.unused().contains("sasl.mechanism"));
        Assertions.assertEquals((Object)"GSSAPI", valuesWithPrefixOverride.get("sasl.mechanism"));
        Assertions.assertFalse((boolean)config.unused().contains("sasl.mechanism"));
        Assertions.assertFalse((boolean)config.unused().contains("prefix.sasl.mechanism"));
        Assertions.assertTrue((boolean)config.unused().contains("prefix.sasl.kerberos.kinit.cmd"));
        Assertions.assertFalse((boolean)config.unused().contains("sasl.kerberos.kinit.cmd"));
        Assertions.assertEquals((Object)"/usr/bin/kinit2", valuesWithPrefixOverride.get("sasl.kerberos.kinit.cmd"));
        Assertions.assertFalse((boolean)config.unused().contains("sasl.kerberos.kinit.cmd"));
        Assertions.assertFalse((boolean)config.unused().contains("prefix.sasl.kerberos.kinit.cmd"));
        Assertions.assertTrue((boolean)config.unused().contains("prefix.ssl.truststore.location"));
        Assertions.assertFalse((boolean)config.unused().contains("ssl.truststore.location"));
        Assertions.assertEquals((Object)"my location", valuesWithPrefixOverride.get("ssl.truststore.location"));
        Assertions.assertFalse((boolean)config.unused().contains("ssl.truststore.location"));
        Assertions.assertFalse((boolean)config.unused().contains("prefix.ssl.truststore.location"));
        Assertions.assertTrue((boolean)config.unused().contains("ssl.keymanager.algorithm"));
        Assertions.assertEquals((Object)"algorithm", valuesWithPrefixOverride.get("ssl.keymanager.algorithm"));
        Assertions.assertFalse((boolean)config.unused().contains("ssl.keymanager.algorithm"));
        Assertions.assertTrue((boolean)config.unused().contains("sasl.kerberos.service.name"));
        Assertions.assertEquals((Object)"service name", valuesWithPrefixOverride.get("sasl.kerberos.service.name"));
        Assertions.assertFalse((boolean)config.unused().contains("sasl.kerberos.service.name"));
        Assertions.assertFalse((boolean)config.unused().contains("sasl.kerberos.min.time.before.relogin"));
        Assertions.assertEquals((Object)60000L, valuesWithPrefixOverride.get("sasl.kerberos.min.time.before.relogin"));
        Assertions.assertFalse((boolean)config.unused().contains("sasl.kerberos.min.time.before.relogin"));
        Assertions.assertFalse((boolean)config.unused().contains("ssl.key.password"));
        Assertions.assertNull(valuesWithPrefixOverride.get("ssl.key.password"));
        Assertions.assertFalse((boolean)config.unused().contains("ssl.key.password"));
    }

    @Test
    public void testValuesWithSecondaryPrefix() {
        String prefix = "listener.name.listener1.";
        Password saslJaasConfig1 = new Password("test.myLoginModule1 required;");
        Password saslJaasConfig2 = new Password("test.myLoginModule2 required;");
        Password saslJaasConfig3 = new Password("test.myLoginModule3 required;");
        Properties props = new Properties();
        props.put("listener.name.listener1.test-mechanism.sasl.jaas.config", saslJaasConfig1.value());
        props.put("test-mechanism.sasl.jaas.config", saslJaasConfig2.value());
        props.put("sasl.jaas.config", saslJaasConfig3.value());
        props.put("listener.name.listener1.gssapi.sasl.kerberos.kinit.cmd", "/usr/bin/kinit2");
        props.put("listener.name.listener1.gssapi.sasl.kerberos.service.name", "testkafka");
        props.put("listener.name.listener1.gssapi.sasl.kerberos.min.time.before.relogin", "60000");
        props.put("ssl.provider", "TEST");
        TestSecurityConfig config = new TestSecurityConfig(props);
        Map valuesWithPrefixOverride = config.valuesWithPrefixOverride(prefix);
        Assertions.assertTrue((boolean)config.unused().contains("listener.name.listener1.test-mechanism.sasl.jaas.config"));
        Assertions.assertTrue((boolean)config.unused().contains("test-mechanism.sasl.jaas.config"));
        Assertions.assertEquals((Object)saslJaasConfig1, valuesWithPrefixOverride.get("test-mechanism.sasl.jaas.config"));
        Assertions.assertEquals((Object)saslJaasConfig3, valuesWithPrefixOverride.get("sasl.jaas.config"));
        Assertions.assertFalse((boolean)config.unused().contains("listener.name.listener1.test-mechanism.sasl.jaas.config"));
        Assertions.assertFalse((boolean)config.unused().contains("test-mechanism.sasl.jaas.config"));
        Assertions.assertFalse((boolean)config.unused().contains("sasl.jaas.config"));
        Assertions.assertFalse((boolean)config.unused().contains("sasl.kerberos.kinit.cmd"));
        Assertions.assertTrue((boolean)config.unused().contains("listener.name.listener1.gssapi.sasl.kerberos.kinit.cmd"));
        Assertions.assertFalse((boolean)config.unused().contains("gssapi.sasl.kerberos.kinit.cmd"));
        Assertions.assertFalse((boolean)config.unused().contains("sasl.kerberos.kinit.cmd"));
        Assertions.assertEquals((Object)"/usr/bin/kinit2", valuesWithPrefixOverride.get("gssapi.sasl.kerberos.kinit.cmd"));
        Assertions.assertFalse((boolean)config.unused().contains("listener.name.listener1.sasl.kerberos.kinit.cmd"));
        Assertions.assertFalse((boolean)config.unused().contains("sasl.kerberos.service.name"));
        Assertions.assertTrue((boolean)config.unused().contains("listener.name.listener1.gssapi.sasl.kerberos.service.name"));
        Assertions.assertFalse((boolean)config.unused().contains("gssapi.sasl.kerberos.service.name"));
        Assertions.assertFalse((boolean)config.unused().contains("sasl.kerberos.service.name"));
        Assertions.assertEquals((Object)"testkafka", valuesWithPrefixOverride.get("gssapi.sasl.kerberos.service.name"));
        Assertions.assertFalse((boolean)config.unused().contains("listener.name.listener1.gssapi.sasl.kerberos.service.name"));
        Assertions.assertTrue((boolean)config.unused().contains("ssl.provider"));
        Assertions.assertNull(valuesWithPrefixOverride.get("gssapi.ssl.provider"));
        Assertions.assertTrue((boolean)config.unused().contains("ssl.provider"));
    }

    @Test
    public void testValuesWithPrefixAllOrNothing() {
        String prefix1 = "prefix1.";
        String prefix2 = "prefix2.";
        Properties props = new Properties();
        props.put("sasl.mechanism", "PLAIN");
        props.put("prefix1.sasl.mechanism", "GSSAPI");
        props.put("prefix1.sasl.kerberos.kinit.cmd", "/usr/bin/kinit2");
        props.put("prefix1.ssl.truststore.location", "my location");
        props.put("sasl.kerberos.service.name", "service name");
        props.put("ssl.keymanager.algorithm", "algorithm");
        TestSecurityConfig config = new TestSecurityConfig(props);
        Map valuesWithPrefixAllOrNothing1 = config.valuesWithPrefixAllOrNothing(prefix1);
        Assertions.assertEquals((Object)"GSSAPI", valuesWithPrefixAllOrNothing1.get("sasl.mechanism"));
        Assertions.assertEquals((Object)"/usr/bin/kinit2", valuesWithPrefixAllOrNothing1.get("sasl.kerberos.kinit.cmd"));
        Assertions.assertEquals((Object)"my location", valuesWithPrefixAllOrNothing1.get("ssl.truststore.location"));
        Assertions.assertFalse((boolean)valuesWithPrefixAllOrNothing1.containsKey("sasl.kerberos.service.name"));
        Assertions.assertFalse((boolean)valuesWithPrefixAllOrNothing1.containsKey("ssl.keymanager.algorithm"));
        Map valuesWithPrefixAllOrNothing2 = config.valuesWithPrefixAllOrNothing(prefix2);
        Assertions.assertTrue((boolean)valuesWithPrefixAllOrNothing2.containsKey("sasl.kerberos.service.name"));
        Assertions.assertTrue((boolean)valuesWithPrefixAllOrNothing2.containsKey("ssl.keymanager.algorithm"));
    }

    @Test
    public void testUnusedConfigs() {
        Properties props = new Properties();
        String configValue = "org.apache.kafka.common.config.AbstractConfigTest$ConfiguredFakeMetricsReporter";
        props.put("metric.reporters", configValue);
        props.put("metric.extra_config", "my_value");
        TestConfig config = new TestConfig(props);
        Assertions.assertTrue((boolean)config.unused().contains("metric.extra_config"), (String)"metric.extra_config should be marked unused before getConfiguredInstances is called");
        config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
        Assertions.assertFalse((boolean)config.unused().contains("metric.extra_config"), (String)"metric.extra_config should be marked as used");
    }

    private void testValidInputs(String configValue) {
        Properties props = new Properties();
        props.put("metric.reporters", configValue);
        TestConfig config = new TestConfig(props);
        try {
            config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
        }
        catch (ConfigException e) {
            Assertions.fail((String)("No exceptions are expected here, valid props are :" + String.valueOf(props)));
        }
    }

    private void testInvalidInputs(String configValue) {
        Properties props = new Properties();
        props.put("metric.reporters", configValue);
        TestConfig config = new TestConfig(props);
        Assertions.assertThrows(KafkaException.class, () -> config.getConfiguredInstances("metric.reporters", MetricsReporter.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfiguredInstancesClosedOnFailure() {
        try {
            HashMap<String, Object> props = new HashMap<String, Object>();
            String threeConsumerInterceptors = MockConsumerInterceptor.class.getName() + ", " + MockConsumerInterceptor.class.getName() + ", " + MockConsumerInterceptor.class.getName();
            props.put("metric.reporters", threeConsumerInterceptors);
            props.put("client.id", "test");
            TestConfig testConfig = new TestConfig(props);
            MockConsumerInterceptor.setThrowOnConfigExceptionThreshold(3);
            Assertions.assertThrows(Exception.class, () -> testConfig.getConfiguredInstances("metric.reporters", Object.class));
            Assertions.assertEquals((int)3, (int)MockConsumerInterceptor.CONFIG_COUNT.get());
            Assertions.assertEquals((int)3, (int)MockConsumerInterceptor.CLOSE_COUNT.get());
        }
        finally {
            MockConsumerInterceptor.resetCounters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClassConfigs() {
        class RestrictedClassLoader
        extends ClassLoader {
            public RestrictedClassLoader() {
                super(null);
            }

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                if (name.equals(ClassTestConfig.DEFAULT_CLASS.getName()) || name.equals(ClassTestConfig.RESTRICTED_CLASS.getName())) {
                    throw new ClassNotFoundException();
                }
                return ClassTestConfig.class.getClassLoader().loadClass(name);
            }
        }
        RestrictedClassLoader restrictedClassLoader = new RestrictedClassLoader();
        ClassLoader defaultClassLoader = AbstractConfig.class.getClassLoader();
        ClassLoader originClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(defaultClassLoader);
            ClassTestConfig testConfig = new ClassTestConfig();
            testConfig.checkInstances(ClassTestConfig.DEFAULT_CLASS, ClassTestConfig.DEFAULT_CLASS);
            Thread.currentThread().setContextClassLoader(restrictedClassLoader);
            testConfig = new ClassTestConfig();
            testConfig.checkInstances(ClassTestConfig.DEFAULT_CLASS, ClassTestConfig.DEFAULT_CLASS);
            Thread.currentThread().setContextClassLoader(defaultClassLoader);
            ClassTestConfig.testOverrides();
            Thread.currentThread().setContextClassLoader(null);
            ClassTestConfig.testOverrides();
            Thread.currentThread().setContextClassLoader(restrictedClassLoader);
            testConfig = new ClassTestConfig(ClassTestConfig.RESTRICTED_CLASS, Collections.singletonList(ClassTestConfig.RESTRICTED_CLASS));
            testConfig.checkInstances(ClassTestConfig.RESTRICTED_CLASS, ClassTestConfig.RESTRICTED_CLASS);
            testConfig = new ClassTestConfig(ClassTestConfig.RESTRICTED_CLASS, Arrays.asList(ClassTestConfig.VISIBLE_CLASS, ClassTestConfig.RESTRICTED_CLASS));
            testConfig.checkInstances(ClassTestConfig.RESTRICTED_CLASS, ClassTestConfig.VISIBLE_CLASS, ClassTestConfig.RESTRICTED_CLASS);
            Assertions.assertThrows(ConfigException.class, () -> new ClassTestConfig(ClassTestConfig.RESTRICTED_CLASS.getName(), null), (String)"Config created with class property that cannot be loaded");
            ClassTestConfig config = new ClassTestConfig(null, Arrays.asList(ClassTestConfig.VISIBLE_CLASS.getName(), ClassTestConfig.RESTRICTED_CLASS.getName()));
            Assertions.assertThrows(KafkaException.class, () -> config.getConfiguredInstances("list.prop", MetricsReporter.class), (String)"Should have failed to load class");
            ClassTestConfig config2 = new ClassTestConfig(null, ClassTestConfig.VISIBLE_CLASS.getName() + "," + ClassTestConfig.RESTRICTED_CLASS.getName());
            Assertions.assertThrows(KafkaException.class, () -> config2.getConfiguredInstances("list.prop", MetricsReporter.class), (String)"Should have failed to load class");
        }
        finally {
            Thread.currentThread().setContextClassLoader(originClassLoader);
        }
    }

    @Test
    public void testOriginalWithOverrides() {
        Properties props = new Properties();
        props.put("config.providers", "file");
        TestIndirectConfigResolution config = new TestIndirectConfigResolution(props);
        Assertions.assertEquals(config.originals().get("config.providers"), (Object)"file");
        Assertions.assertEquals(config.originals(Collections.singletonMap("config.providers", "file2")).get("config.providers"), (Object)"file2");
    }

    @Test
    public void testOriginalsWithConfigProvidersProps() {
        Properties props = new Properties();
        props.put("config.providers", "file");
        props.put("config.providers.file.class", MockFileConfigProvider.class.getName());
        String id = UUID.randomUUID().toString();
        props.put("config.providers.file.param.testId", id);
        props.put("prefix.ssl.truststore.location.number", (Object)5);
        props.put("sasl.kerberos.service.name", "service name");
        props.put("sasl.kerberos.key", "${file:/usr/kerberos:key}");
        props.put("sasl.kerberos.password", "${file:/usr/kerberos:password}");
        TestIndirectConfigResolution config = new TestIndirectConfigResolution(props);
        Assertions.assertEquals((Object)"testKey", config.originals().get("sasl.kerberos.key"));
        Assertions.assertEquals((Object)"randomPassword", config.originals().get("sasl.kerberos.password"));
        Assertions.assertEquals((Object)5, config.originals().get("prefix.ssl.truststore.location.number"));
        Assertions.assertEquals((Object)"service name", config.originals().get("sasl.kerberos.service.name"));
        MockFileConfigProvider.assertClosed(id);
    }

    @Test
    public void testOriginalsWithConfigProvidersPropsExcluded() {
        System.setProperty("org.apache.kafka.automatic.config.providers", MockVaultConfigProvider.class.getName() + " , " + FileConfigProvider.class.getName());
        Properties props = new Properties();
        props.put("config.providers", "file");
        props.put("config.providers.file.class", MockFileConfigProvider.class.getName());
        String id = UUID.randomUUID().toString();
        props.put("config.providers.file.param.testId", id);
        props.put("prefix.ssl.truststore.location.number", (Object)5);
        props.put("sasl.kerberos.service.name", "service name");
        props.put("sasl.kerberos.key", "${file:/usr/kerberos:key}");
        props.put("sasl.kerberos.password", "${file:/usr/kerberos:password}");
        Assertions.assertThrows(ConfigException.class, () -> new TestIndirectConfigResolution(props, Collections.emptyMap()));
    }

    @Test
    public void testOriginalsWithConfigProvidersPropsIncluded() {
        System.setProperty("org.apache.kafka.automatic.config.providers", MockFileConfigProvider.class.getName() + " , " + FileConfigProvider.class.getName());
        Properties props = new Properties();
        props.put("config.providers", "file");
        props.put("config.providers.file.class", MockFileConfigProvider.class.getName());
        String id = UUID.randomUUID().toString();
        props.put("config.providers.file.param.testId", id);
        props.put("prefix.ssl.truststore.location.number", (Object)5);
        props.put("sasl.kerberos.service.name", "service name");
        props.put("sasl.kerberos.key", "${file:/usr/kerberos:key}");
        props.put("sasl.kerberos.password", "${file:/usr/kerberos:password}");
        TestIndirectConfigResolution config = new TestIndirectConfigResolution(props, Collections.emptyMap());
        Assertions.assertEquals((Object)"testKey", config.originals().get("sasl.kerberos.key"));
        Assertions.assertEquals((Object)"randomPassword", config.originals().get("sasl.kerberos.password"));
        MockFileConfigProvider.assertClosed(id);
    }

    @Test
    public void testConfigProvidersPropsAsParam() {
        Properties providers = new Properties();
        providers.put("config.providers", "file");
        providers.put("config.providers.file.class", MockFileConfigProvider.class.getName());
        String id = UUID.randomUUID().toString();
        providers.put("config.providers.file.param.testId", id);
        Properties props = new Properties();
        props.put("sasl.kerberos.key", "${file:/usr/kerberos:key}");
        props.put("sasl.kerberos.password", "${file:/usr/kerberos:password}");
        TestIndirectConfigResolution config = new TestIndirectConfigResolution(props, Utils.castToStringObjectMap((Map)providers));
        Assertions.assertEquals((Object)"testKey", config.originals().get("sasl.kerberos.key"));
        Assertions.assertEquals((Object)"randomPassword", config.originals().get("sasl.kerberos.password"));
        MockFileConfigProvider.assertClosed(id);
    }

    @Test
    public void testAutomaticConfigProvidersWithFullClassName() {
        System.setProperty("org.apache.kafka.automatic.config.providers", "file");
        Assertions.assertThrows(ConfigException.class, () -> new TestIndirectConfigResolution(Map.of("config.providers", "file", "config.providers.file.class", MockFileConfigProvider.class.getName()), Map.of()));
        System.setProperty("org.apache.kafka.automatic.config.providers", MockFileConfigProvider.class.getName());
        Map<String, String> props = Map.of("config.providers", "file", "config.providers.file.class", MockFileConfigProvider.class.getName(), "config.providers.file.param.testId", UUID.randomUUID().toString(), "test.key", "${file:/path:key}");
        Assertions.assertEquals((Object)"testKey", new TestIndirectConfigResolution(props, Map.of()).originals().get("test.key"));
        System.setProperty("org.apache.kafka.automatic.config.providers", MockFileConfigProvider.class.getName() + "," + EnvVarConfigProvider.class.getName());
        Assertions.assertEquals((Object)"testKey", new TestIndirectConfigResolution(props, Map.of()).originals().get("test.key"));
    }

    @Test
    public void testImmutableOriginalsWithConfigProvidersProps() {
        Properties providers = new Properties();
        providers.put("config.providers", "file");
        providers.put("config.providers.file.class", MockFileConfigProvider.class.getName());
        String id = UUID.randomUUID().toString();
        providers.put("config.providers.file.param.testId", id);
        Properties props = new Properties();
        props.put("sasl.kerberos.key", "${file:/usr/kerberos:key}");
        Map<Object, Object> immutableMap = Collections.unmodifiableMap(props);
        Map provMap = Utils.castToStringObjectMap((Map)providers);
        TestIndirectConfigResolution config = new TestIndirectConfigResolution(immutableMap, provMap);
        Assertions.assertEquals((Object)"testKey", config.originals().get("sasl.kerberos.key"));
        MockFileConfigProvider.assertClosed(id);
    }

    @Test
    public void testAutoConfigResolutionWithMultipleConfigProviders() {
        Properties providers = new Properties();
        providers.put("config.providers", "file,vault");
        providers.put("config.providers.file.class", MockFileConfigProvider.class.getName());
        String id = UUID.randomUUID().toString();
        providers.put("config.providers.file.param.testId", id);
        providers.put("config.providers.vault.class", MockVaultConfigProvider.class.getName());
        Properties props = new Properties();
        props.put("sasl.kerberos.key", "${file:/usr/kerberos:key}");
        props.put("sasl.kerberos.password", "${file:/usr/kerberos:password}");
        props.put("sasl.truststore.key", "${vault:/usr/truststore:truststoreKey}");
        props.put("sasl.truststore.password", "${vault:/usr/truststore:truststorePassword}");
        TestIndirectConfigResolution config = new TestIndirectConfigResolution(props, Utils.castToStringObjectMap((Map)providers));
        Assertions.assertEquals((Object)"testKey", config.originals().get("sasl.kerberos.key"));
        Assertions.assertEquals((Object)"randomPassword", config.originals().get("sasl.kerberos.password"));
        Assertions.assertEquals((Object)"testTruststoreKey", config.originals().get("sasl.truststore.key"));
        Assertions.assertEquals((Object)"randomtruststorePassword", config.originals().get("sasl.truststore.password"));
        MockFileConfigProvider.assertClosed(id);
    }

    @Test
    public void testAutoConfigResolutionWithInvalidConfigProviderClass() {
        Properties props = new Properties();
        props.put("config.providers", "file");
        props.put("config.providers.file.class", "org.apache.kafka.common.config.provider.InvalidConfigProvider");
        props.put("testKey", "${test:/foo/bar/testpath:testKey}");
        Assertions.assertThrows(KafkaException.class, () -> new TestIndirectConfigResolution(props));
    }

    @Test
    public void testAutoConfigResolutionWithInvalidConfigProviderClassExcluded() {
        String invalidConfigProvider = "org.apache.kafka.common.config.provider.InvalidConfigProvider";
        System.setProperty("org.apache.kafka.automatic.config.providers", "");
        Properties props = new Properties();
        props.put("config.providers", "file");
        props.put("config.providers.file.class", invalidConfigProvider);
        props.put("testKey", "${test:/foo/bar/testpath:testKey}");
        KafkaException e = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> new TestIndirectConfigResolution(props, Collections.emptyMap()));
        Assertions.assertTrue((boolean)e.getMessage().contains("org.apache.kafka.automatic.config.providers"));
    }

    @Test
    public void testAutoConfigResolutionWithInvalidConfigProviderClassIncluded() {
        String invalidConfigProvider = "org.apache.kafka.common.config.provider.InvalidConfigProvider";
        System.setProperty("org.apache.kafka.automatic.config.providers", invalidConfigProvider);
        Properties props = new Properties();
        props.put("config.providers", "file");
        props.put("config.providers.file.class", invalidConfigProvider);
        props.put("testKey", "${test:/foo/bar/testpath:testKey}");
        KafkaException e = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> new TestIndirectConfigResolution(props, Collections.emptyMap()));
        Assertions.assertFalse((boolean)e.getMessage().contains("org.apache.kafka.automatic.config.providers"));
    }

    @Test
    public void testAutoConfigResolutionWithMissingConfigProvider() {
        Properties props = new Properties();
        props.put("testKey", "${test:/foo/bar/testpath:testKey}");
        TestIndirectConfigResolution config = new TestIndirectConfigResolution(props);
        Assertions.assertEquals((Object)"${test:/foo/bar/testpath:testKey}", config.originals().get("testKey"));
    }

    @Test
    public void testAutoConfigResolutionWithMissingConfigKey() {
        Properties props = new Properties();
        props.put("config.providers", "test");
        props.put("config.providers.test.class", MockFileConfigProvider.class.getName());
        String id = UUID.randomUUID().toString();
        props.put("config.providers.test.param.testId", id);
        props.put("random", "${test:/foo/bar/testpath:random}");
        TestIndirectConfigResolution config = new TestIndirectConfigResolution(props);
        Assertions.assertEquals((Object)"${test:/foo/bar/testpath:random}", config.originals().get("random"));
        MockFileConfigProvider.assertClosed(id);
    }

    @Test
    public void testAutoConfigResolutionWithDuplicateConfigProvider() {
        Properties providers = new Properties();
        providers.put("config.providers", "test");
        providers.put("config.providers.test.class", MockVaultConfigProvider.class.getName());
        Properties props = new Properties();
        props.put("sasl.kerberos.key", "${file:/usr/kerberos:key}");
        props.put("config.providers", "file");
        props.put("config.providers.file.class", MockVaultConfigProvider.class.getName());
        TestIndirectConfigResolution config = new TestIndirectConfigResolution(props, Utils.castToStringObjectMap((Map)providers));
        Assertions.assertEquals((Object)"${file:/usr/kerberos:key}", config.originals().get("sasl.kerberos.key"));
    }

    @Test
    public void testConfigProviderConfigurationWithConfigParams() {
        System.setProperty("org.apache.kafka.automatic.config.providers", MockFileConfigProvider.class.getName());
        Properties providers = new Properties();
        providers.put("config.providers", "vault");
        providers.put("config.providers.vault.class", MockVaultConfigProvider.class.getName());
        providers.put("config.providers.vault.param.key", "randomKey");
        providers.put("config.providers.vault.param.location", "/usr/vault");
        Properties props = new Properties();
        props.put("sasl.truststore.key", "${vault:/usr/truststore:truststoreKey}");
        props.put("sasl.truststore.password", "${vault:/usr/truststore:truststorePassword}");
        props.put("sasl.truststore.location", "${vault:/usr/truststore:truststoreLocation}");
        TestIndirectConfigResolution config = new TestIndirectConfigResolution(props, Utils.castToStringObjectMap((Map)providers));
        Assertions.assertEquals((Object)"/usr/vault", config.originals().get("sasl.truststore.location"));
    }

    @Test
    public void testDocumentationOf() {
        Properties props = new Properties();
        TestIndirectConfigResolution config = new TestIndirectConfigResolution(props);
        Assertions.assertEquals((Object)"Variables whose values can be obtained from ConfigProviders", (Object)config.documentationOf("indirect.variables"));
    }

    @Test
    public void testDocumentationOfExpectNull() {
        Properties props = new Properties();
        TestIndirectConfigResolution config = new TestIndirectConfigResolution(props);
        Assertions.assertNull((Object)config.documentationOf("xyz"));
    }

    @ParameterizedTest
    @CsvSource(value={"true,false,false", "true,true,true", "false,false,false", "false,true,false"})
    public void testDoLog(boolean doLog, String configsLoggingEnabled, boolean expectedDoLog) {
        Properties props = new Properties();
        TestConfig config = new TestConfig(props, doLog);
        TestUtils.fieldValue((Object)config, AbstractConfig.class, "doLog");
        boolean actualDoLog = ConfigUtils.getDoLog((AbstractConfig)config);
        Assertions.assertEquals((Object)doLog, (Object)actualDoLog, (String)"actual doLog not same as passed doLog without configsLoggingEnabled property");
        props.put("confluent.configs.logging.enabled", configsLoggingEnabled);
        config = new TestConfig(props, doLog);
        actualDoLog = ConfigUtils.getDoLog((AbstractConfig)config);
        Assertions.assertEquals((Object)expectedDoLog, (Object)actualDoLog, (String)"Actual doLog not same as expected doLog with configsLoggingEnabled property");
    }

    private static class TestConfig
    extends AbstractConfig {
        private static final ConfigDef CONFIG = new ConfigDef().define("metric.reporters", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "A list of classes to use as metrics reporters.");
        public static final String METRIC_REPORTER_CLASSES_CONFIG = "metric.reporters";
        private static final String METRIC_REPORTER_CLASSES_DOC = "A list of classes to use as metrics reporters.";

        public TestConfig(Map<?, ?> props) {
            super(CONFIG, props);
        }

        public TestConfig(Map<?, ?> props, boolean doLog) {
            super(CONFIG, props, doLog);
        }
    }

    public static class ConfiguredFakeMetricsReporter
    extends FakeMetricsReporter {
        public static final String EXTRA_CONFIG = "metric.extra_config";

        @Override
        public void configure(Map<String, ?> configs) {
            configs.get(EXTRA_CONFIG);
        }
    }

    private static class ClassTestConfig
    extends AbstractConfig {
        static final Class<?> DEFAULT_CLASS = FakeMetricsReporter.class;
        static final Class<?> VISIBLE_CLASS = JmxReporter.class;
        static final Class<?> RESTRICTED_CLASS = ConfiguredFakeMetricsReporter.class;
        private static final ConfigDef CONFIG = new ConfigDef().define("class.prop", ConfigDef.Type.CLASS, DEFAULT_CLASS, ConfigDef.Importance.HIGH, "docs").define("list.prop", ConfigDef.Type.LIST, Collections.singletonList(DEFAULT_CLASS), ConfigDef.Importance.HIGH, "docs");

        public ClassTestConfig() {
            super(CONFIG, (Map)new Properties());
        }

        public ClassTestConfig(Object classPropOverride, Object listPropOverride) {
            super(CONFIG, ClassTestConfig.overrideProps(classPropOverride, listPropOverride));
        }

        void checkInstances(Class<?> expectedClassPropClass, Class<?> ... expectedListPropClasses) {
            Assertions.assertEquals(expectedClassPropClass, (Object)((MetricsReporter)this.getConfiguredInstance("class.prop", MetricsReporter.class)).getClass());
            List list = this.getConfiguredInstances("list.prop", MetricsReporter.class);
            for (int i = 0; i < list.size(); ++i) {
                Assertions.assertEquals(expectedListPropClasses[i], list.get(i).getClass());
            }
        }

        static void testOverrides() {
            ClassTestConfig testConfig1 = new ClassTestConfig(RESTRICTED_CLASS, Arrays.asList(VISIBLE_CLASS, RESTRICTED_CLASS));
            testConfig1.checkInstances(RESTRICTED_CLASS, VISIBLE_CLASS, RESTRICTED_CLASS);
            ClassTestConfig testConfig2 = new ClassTestConfig(RESTRICTED_CLASS.getName(), Arrays.asList(VISIBLE_CLASS.getName(), RESTRICTED_CLASS.getName()));
            testConfig2.checkInstances(RESTRICTED_CLASS, VISIBLE_CLASS, RESTRICTED_CLASS);
            ClassTestConfig testConfig3 = new ClassTestConfig(RESTRICTED_CLASS.getName(), VISIBLE_CLASS.getName() + "," + RESTRICTED_CLASS.getName());
            testConfig3.checkInstances(RESTRICTED_CLASS, VISIBLE_CLASS, RESTRICTED_CLASS);
        }

        private static Map<String, Object> overrideProps(Object classProp, Object listProp) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (classProp != null) {
                props.put("class.prop", classProp);
            }
            if (listProp != null) {
                props.put("list.prop", listProp);
            }
            return props;
        }
    }

    private static class TestIndirectConfigResolution
    extends AbstractConfig {
        private static final ConfigDef CONFIG = new ConfigDef().define("indirect.variables", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "Variables whose values can be obtained from ConfigProviders");
        public static final String INDIRECT_CONFIGS = "indirect.variables";
        private static final String INDIRECT_CONFIGS_DOC = "Variables whose values can be obtained from ConfigProviders";

        public TestIndirectConfigResolution(Map<?, ?> props) {
            super(CONFIG, props, true);
        }

        public TestIndirectConfigResolution(Map<?, ?> props, Map<String, ?> providers) {
            super(CONFIG, props, providers, true);
        }
    }
}

