/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.internals;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.mtls.MTlsTruststoreManager;
import org.apache.kafka.common.security.mtls.NoopMTlsConnectionManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class ConfluentConfigsTest {
    @Test
    public void testSslEnabledListenersNull() {
        Assertions.assertEquals(Collections.emptyList(), (Object)ConfluentConfigs.sslListenerNames(Collections.emptyMap()));
    }

    @Test
    public void testSslEnabledListenersEmpty() {
        Assertions.assertEquals(Collections.emptyList(), (Object)ConfluentConfigs.sslListenerNames(Collections.singletonMap("listener.security.protocol.map", "")));
    }

    @Test
    public void testSslEnabledListenersAllPlaintext() {
        Assertions.assertEquals(Collections.emptyList(), (Object)ConfluentConfigs.sslListenerNames(Collections.singletonMap("listener.security.protocol.map", "INTERNAL:PLAINTEXT,REPLICATION:PLAINTEXT")));
    }

    @Test
    public void testSslEnabledListenersSomeSsl() {
        Assertions.assertEquals(Arrays.asList("EXTERNAL", "INTERNAL_ROOT_SCOPED"), (Object)ConfluentConfigs.sslListenerNames(Collections.singletonMap("listener.security.protocol.map", "EXTERNAL:SASL_SSL,INTERNAL:PLAINTEXT,REPLICATION:PLAINTEXT,INTERNAL_ROOT_SCOPED:SSL")));
    }

    @Test
    public void testClientConfigsLoggingEnabled() {
        Assertions.assertTrue((boolean)ConfluentConfigs.clientConfigsLoggingEnabled(Collections.emptyMap()));
        Assertions.assertTrue((boolean)ConfluentConfigs.clientConfigsLoggingEnabled(Collections.singletonMap("confluent.configs.logging.enabled", "true")));
        Assertions.assertFalse((boolean)ConfluentConfigs.clientConfigsLoggingEnabled(Collections.singletonMap("confluent.configs.logging.enabled", "false")));
    }

    @Test
    public void testGetMTlsEnable() {
        Assertions.assertFalse((boolean)ConfluentConfigs.getMTlsEnable(new HashMap()));
        Map<String, Object> configs = Map.of("confluent.mtls.enable", "False");
        Assertions.assertFalse((boolean)ConfluentConfigs.getMTlsEnable(configs));
        configs = Map.of("confluent.mtls.enable", false);
        Assertions.assertFalse((boolean)ConfluentConfigs.getMTlsEnable(configs));
        configs = Map.of("confluent.mtls.enable", true);
        Assertions.assertTrue((boolean)ConfluentConfigs.getMTlsEnable(configs));
        configs = Map.of("confluent.mtls.enable", "True");
        Assertions.assertTrue((boolean)ConfluentConfigs.getMTlsEnable(configs));
    }

    @Test
    public void testGetMTlsListenerName() {
        Assertions.assertEquals((Object)"EXTERNAL", (Object)ConfluentConfigs.getMTlsListenerName(new HashMap()));
        Map<String, String> configs = Map.of("confluent.mtls.listener.name", "SSL_EXTERNAL");
        Assertions.assertEquals((Object)"SSL_EXTERNAL", (Object)ConfluentConfigs.getMTlsListenerName(configs));
    }

    @Test
    public void testGetMTlsTruststoreManagerClass() {
        Assertions.assertNull((Object)ConfluentConfigs.getMTlsTruststoreManagerClass(new HashMap()));
        Map<String, String> configs = Map.of("confluent.mtls.truststore.manager.class.name", StubMTlsTruststoreManager.class.getName());
        Assertions.assertEquals(StubMTlsTruststoreManager.class, (Object)ConfluentConfigs.getMTlsTruststoreManagerClass(configs));
        configs = Map.of("confluent.mtls.truststore.manager.class.name", "invalid.class.name");
        Assertions.assertThrows(ConfigException.class, () -> ConfluentConfigs.getMTlsTruststoreManagerClass((Map)configs));
        configs = Map.of("confluent.mtls.truststore.manager.class.name", ConfluentConfigsTest.class.getName());
        Assertions.assertThrows(ConfigException.class, () -> ConfluentConfigs.getMTlsTruststoreManagerClass((Map)configs));
    }

    @Test
    public void testBuildMTlsConnectionManager() {
        Assertions.assertInstanceOf(NoopMTlsConnectionManager.class, (Object)ConfluentConfigs.buildMTlsConnectionManager(new HashMap()));
    }

    @Test
    public void testGetMTlsSaslAuthenticatorRequestMaxBytes() {
        Assertions.assertEquals((int)0x6400000, (int)ConfluentConfigs.getMTlsSaslAuthenticatorRequestMaxBytes(new HashMap()));
        Map<String, Object> configs = Map.of("confluent.mtls.sasl.authenticator.request.max.bytes", 100);
        Assertions.assertEquals((int)100, (int)ConfluentConfigs.getMTlsSaslAuthenticatorRequestMaxBytes(configs));
        configs = Map.of("confluent.mtls.sasl.authenticator.request.max.bytes", "1000");
        Assertions.assertEquals((int)1000, (int)ConfluentConfigs.getMTlsSaslAuthenticatorRequestMaxBytes(configs));
        configs = Map.of("confluent.mtls.sasl.authenticator.request.max.bytes", "invalid");
        Assertions.assertThrows(ConfigException.class, () -> ConfluentConfigs.getMTlsSaslAuthenticatorRequestMaxBytes((Map)configs));
    }

    @Test
    public void testGetMTlsBuildClientCertChain() {
        Assertions.assertFalse((boolean)ConfluentConfigs.getMTlsBuildClientCertChain(new HashMap()));
        Map<String, Object> configs = Map.of("confluent.mtls.build.client.cert.chain.enable", "False");
        Assertions.assertFalse((boolean)ConfluentConfigs.getMTlsBuildClientCertChain(configs));
        configs = Map.of("confluent.mtls.build.client.cert.chain.enable", false);
        Assertions.assertFalse((boolean)ConfluentConfigs.getMTlsBuildClientCertChain(configs));
        configs = Map.of("confluent.mtls.build.client.cert.chain.enable", true);
        Assertions.assertTrue((boolean)ConfluentConfigs.getMTlsBuildClientCertChain(configs));
        configs = Map.of("confluent.mtls.build.client.cert.chain.enable", "True");
        Assertions.assertTrue((boolean)ConfluentConfigs.getMTlsBuildClientCertChain(configs));
    }

    @Test
    void testMultitenantSslListenerNames_noSsl() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("listener.security.protocol.map", "EXTERNAL:SASL_PLAINTEXT");
        props.put("confluent.multitenant.listener.names", "EXTERNAL");
        Assertions.assertTrue((boolean)ConfluentConfigs.multitenantSslListenerNames(props, (ListenerName)ListenerName.normalised((String)"INTER_BROKER")).isEmpty());
    }

    @Test
    void testMultitenantSslListenerNames_withSsl() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("confluent.multitenant.listener.names", "EXTERNAL");
        props.put("listener.security.protocol.map", "EXTERNAL:SASL_SSL");
        Assertions.assertEquals(Collections.singletonList("EXTERNAL"), (Object)ConfluentConfigs.multitenantSslListenerNames(props, (ListenerName)ListenerName.normalised((String)"INTER_BROKER")));
    }

    @Test
    void testMultitenantSslListenerNames_withSsl2() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("confluent.multitenant.listener.names", "INTERNAL_TENANT_SCOPED,EXTERNAL");
        props.put("listener.security.protocol.map", "EXTERNAL:SASL_SSL,INTERNAL_TENANT_SCOPED:SSL");
        Assertions.assertEquals(Arrays.asList("INTERNAL_TENANT_SCOPED", "EXTERNAL"), (Object)ConfluentConfigs.multitenantSslListenerNames(props, (ListenerName)ListenerName.normalised((String)"INTER_BROKER")));
    }

    @ParameterizedTest
    @CsvSource(value={"false,false", "false,true", "true,false", "true,true"})
    void testMultitenantSslListenerNames_withSsl_normalised(boolean mtLowercase, boolean sslLowercase) throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        if (mtLowercase) {
            props.put("confluent.multitenant.listener.names", "internal_tenant_scoped,external");
        } else {
            props.put("confluent.multitenant.listener.names", "INTERNAL_TENANT_SCOPED,EXTERNAL");
        }
        if (sslLowercase) {
            props.put("listener.security.protocol.map", "external:sasl_ssl,internal_tenant_scoped:ssl");
        } else {
            props.put("listener.security.protocol.map", "EXTERNAL:SASL_SSL,INTERNAL_TENANT_SCOPED:SSL");
        }
        Assertions.assertEquals(Arrays.asList("INTERNAL_TENANT_SCOPED", "EXTERNAL"), (Object)ConfluentConfigs.multitenantSslListenerNames(props, (ListenerName)ListenerName.normalised((String)"INTER_BROKER")));
    }

    @Test
    public void testGetMTlsTruststoreAlterConfigsTimeoutMs() {
        Assertions.assertEquals((int)ConfluentConfigs.MTLS_TRUSTSTORE_ALTER_CONFIGS_TIMEOUT_MS_DEFAULT, (int)ConfluentConfigs.getMTlsTruststoreAlterConfigsTimeoutMs(new HashMap()));
        Map<String, Object> configs = Map.of("confluent.mtls.truststore.alter.configs.timeout.ms", 100);
        Assertions.assertEquals((int)100, (int)ConfluentConfigs.getMTlsTruststoreAlterConfigsTimeoutMs(configs));
        configs = Map.of("confluent.mtls.truststore.alter.configs.timeout.ms", "1000");
        Assertions.assertEquals((int)1000, (int)ConfluentConfigs.getMTlsTruststoreAlterConfigsTimeoutMs(configs));
        configs = Map.of("confluent.mtls.truststore.alter.configs.timeout.ms", "invalid");
        Assertions.assertThrows(ConfigException.class, () -> ConfluentConfigs.getMTlsTruststoreAlterConfigsTimeoutMs((Map)configs));
    }

    private static class StubMTlsTruststoreManager
    implements MTlsTruststoreManager {
        private StubMTlsTruststoreManager() {
        }

        public void addCertificates(String organizationId, String providerId, X509Certificate[] certificates) {
        }

        public void removeCertificates(String organizationId, String providerId) {
        }
    }
}

