/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.kafka.common.network.BrokerFqdnBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BrokerFqdnBuilderTest {
    @Test
    public void testCreateBrokerToGatewayZoneMapping() {
        Assertions.assertThrows(NullPointerException.class, () -> BrokerFqdnBuilder.createBrokerToGatewayZoneMapping(null, new HashSet()));
        Assertions.assertThrows(NullPointerException.class, () -> BrokerFqdnBuilder.createBrokerToGatewayZoneMapping(new HashSet(), null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> BrokerFqdnBuilder.createBrokerToGatewayZoneMapping(new HashSet(), new HashSet()));
        HashMap<String, String> expectedZonalMapping = new HashMap<String, String>();
        expectedZonalMapping.put("B", "B");
        expectedZonalMapping.put("C", "C");
        expectedZonalMapping.put("A", "D");
        expectedZonalMapping.put("E", "B");
        expectedZonalMapping.put("F", "C");
        expectedZonalMapping.put("G", "D");
        Assertions.assertEquals(expectedZonalMapping, (Object)BrokerFqdnBuilder.createBrokerToGatewayZoneMapping(new HashSet<String>(Arrays.asList("B", "C", "D")), new HashSet<String>(Arrays.asList("A", "B", "C", "E", "F", "G"))));
    }
}

