/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.NioEchoServer;
import org.apache.kafka.common.network.PlaintextChannelBuilder;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TestProxyProtocolEngine;
import org.apache.kafka.common.security.DefaultRequestCallbackManager;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PlaintextTransportLayerTest {
    private static final int BUFFER_SIZE = 4096;
    private static final Time TIME = Time.SYSTEM;
    private static final String V1_PROXY_PROTOCOL_HEADER = NetworkTestUtils.toTcp4ProxyV1Header("200.200.200.200", "201.201.201.201", 8888, 9092);
    private NioEchoServer server;
    private Selector selector;
    private final ConfigDef proxyConfigDef = new ConfigDef().define("confluent.proxy.protocol.version", ConfigDef.Type.STRING, (Object)ConfluentConfigs.PROXY_PROTOCOL_VERSION_DEFAULT, ConfigDef.Importance.LOW, "The version of the PROXY protocol that the broker will use, or NONE if the PROXY protocol will not be used. Possible values include V1, V2, COMBINED, and NONE. If using the COMBINED value. The broker will check the header to determine V1 or V2. This value can be overridden for each listener by prefixing the config with the normalized listener name. For example, to enable V1 of the protocol for the EXTERNAL listener, set <code>listener.name.external.confluent.proxy.protocol.version=V1</code>.Because the inter-broker listener and any admin listeners will likely not be accessed through a proxy, the typical configuration would be to use the default value of NONE and enable the protocol explicitly for a subset of listeners. See http://www.haproxy.org/download/1.8/doc/proxy-protocol.txt for more information on the PROXY protocol.").define("confluent.proxy.protocol.fallback.enabled", ConfigDef.Type.BOOLEAN, (Object)ConfluentConfigs.PROXY_PROTOCOL_FALLBACK_ENABLED_DEFAULT, ConfigDef.Importance.LOW, "If true, and if <code>confluent.proxy.protocol.version</code> is not set to <code>NONE</code>, the network layer will accept both PROXY and non-PROXY protocol requests. If the PROXY header is present, it will parse it and interpret the specified client IP address and port appropriately; if not, it will fall back to a normal, non-PROXY request. This value can be overridden for each listener by prefixing the config with the normalized listener name.").defineInternal("confluent.multitenant.parse.sni.host.name.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "When enabled, parse the SNI host name upon SASL_SSL connection establishment.");

    @AfterEach
    public void tearDown() throws IOException, InterruptedException {
        if (this.server != null) {
            this.server.close();
        }
        if (this.selector != null) {
            this.selector.close();
        }
    }

    @Test
    public void testWithProxyProtocolEngine() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        AbstractConfig config = new AbstractConfig(new ConfigDef(), Collections.emptyMap());
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        InetAddress proxyAddr = InetAddress.getByName("192.168.5.5");
        ChannelBuilder serverChannelBuilder = ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (boolean)false, (SecurityProtocol)securityProtocol, (AbstractConfig)config, null, null, (Time)TIME, (LogContext)new LogContext(), version -> TestUtils.confluentCloudApiVersionsResponse(ApiMessageType.ListenerType.BROKER), (RequestCallback)new DefaultRequestCallbackManager(), (ProxyProtocolEngineFactory)new ProxyProtocolEngineFactory(() -> new TestProxyProtocolEngine(proxyAddr, 31313)));
        this.server = new NioEchoServer(listenerName, securityProtocol, config, "localhost", serverChannelBuilder, null, TIME);
        this.server.start();
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        String serverId = "0";
        this.selector = this.createSelector(config.originals());
        this.selector.connect(serverId, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, serverId, 100, 10);
        PlaintextTransportLayerTest.verifyServerProxyAddress(this.server, proxyAddr);
    }

    @Test
    public void testWithProxyProtocolV1Engine() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        AbstractConfig config = new AbstractConfig(this.proxyConfigDef, Collections.singletonMap("confluent.proxy.protocol.version", "V1"));
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        ChannelBuilder serverChannelBuilder = ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (boolean)false, (SecurityProtocol)securityProtocol, (AbstractConfig)config, null, null, (Time)TIME, (LogContext)new LogContext(), version -> TestUtils.confluentCloudApiVersionsResponse(ApiMessageType.ListenerType.BROKER), (RequestCallback)new DefaultRequestCallbackManager());
        this.server = new NioEchoServer(listenerName, securityProtocol, config, "localhost", serverChannelBuilder, null, TIME);
        this.server.start();
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        String serverId = "0";
        for (int i = 0; i < 3; ++i) {
            this.selector = this.createSelector(config.originals());
            this.selector.connect(serverId, addr, 4096, 4096);
            NetworkTestUtils.checkClientConnection(this.selector, serverId, 100, 10, V1_PROXY_PROTOCOL_HEADER);
            PlaintextTransportLayerTest.verifyServerProxyAddress(this.server, InetAddress.getByName("200.200.200.200"));
        }
    }

    @Test
    public void testProxyProtocolWithFallbackEnabled() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("confluent.proxy.protocol.version", "V1");
        configs.put("confluent.proxy.protocol.fallback.enabled", true);
        AbstractConfig config = new AbstractConfig(this.proxyConfigDef, configs);
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        ChannelBuilder serverChannelBuilder = ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (boolean)false, (SecurityProtocol)securityProtocol, (AbstractConfig)config, null, null, (Time)TIME, (LogContext)new LogContext(), version -> TestUtils.confluentCloudApiVersionsResponse(ApiMessageType.ListenerType.BROKER), (RequestCallback)new DefaultRequestCallbackManager());
        this.server = new NioEchoServer(listenerName, securityProtocol, config, "localhost", serverChannelBuilder, null, TIME);
        this.server.start();
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        String serverId = "0";
        for (int i = 0; i < 3; ++i) {
            Selector client = this.createSelector(config.originals());
            client.connect(serverId, addr, 4096, 4096);
            NetworkTestUtils.checkClientConnection(client, serverId, 100, 10);
        }
    }

    @Test
    public void testProxyProtocolWithFallbackDisabled() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("confluent.proxy.protocol.version", "V1");
        AbstractConfig config = new AbstractConfig(this.proxyConfigDef, configs);
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        ChannelBuilder serverChannelBuilder = ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (boolean)false, (SecurityProtocol)securityProtocol, (AbstractConfig)config, null, null, (Time)TIME, (LogContext)new LogContext(), version -> TestUtils.confluentCloudApiVersionsResponse(ApiMessageType.ListenerType.BROKER), (RequestCallback)new DefaultRequestCallbackManager());
        this.server = new NioEchoServer(listenerName, securityProtocol, config, "localhost", serverChannelBuilder, null, TIME);
        this.server.start();
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        String serverId = "0";
        Selector client = this.createSelector(config.originals());
        client.connect(serverId, addr, 4096, 4096);
        NetworkTestUtils.waitForChannelReady(client, serverId);
        String prefix = TestUtils.randomString(100);
        client.send(new NetworkSend(serverId, (Send)ByteBufferSend.sizePrefixed((ByteBuffer)ByteBuffer.wrap((prefix + "-0").getBytes(StandardCharsets.UTF_8)))));
        TestUtils.waitForCondition(() -> {
            client.poll(0L);
            return client.disconnected().size() == 1;
        }, "Client should have been disconnected because PROXY header was not sent");
    }

    @Test
    public void testDisconnectWhileProcessingHeaders() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        AbstractConfig config = new AbstractConfig(this.proxyConfigDef, Collections.singletonMap("confluent.proxy.protocol.version", "V1"));
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        InetAddress proxyAddr = InetAddress.getByName("192.168.5.5");
        TestProxyProtocolEngine testProxyProtocolEngine = new TestProxyProtocolEngine(proxyAddr, 31313, false);
        ChannelBuilder serverChannelBuilder = ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (boolean)false, (SecurityProtocol)securityProtocol, (AbstractConfig)config, null, null, (Time)TIME, (LogContext)new LogContext(), version -> TestUtils.confluentCloudApiVersionsResponse(ApiMessageType.ListenerType.BROKER), (RequestCallback)new DefaultRequestCallbackManager(), (ProxyProtocolEngineFactory)new ProxyProtocolEngineFactory(() -> testProxyProtocolEngine));
        this.server = new NioEchoServer(listenerName, securityProtocol, config, "localhost", serverChannelBuilder, null, TIME);
        this.server.start();
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        String serverId = "0";
        this.selector = this.createSelector(config.originals());
        this.selector.connect(serverId, addr, 4096, 4096);
        ByteBuffer header = ByteBuffer.wrap("PRO".getBytes(StandardCharsets.US_ASCII));
        this.selector.send(new NetworkSend(serverId, (Send)new ByteBufferSend(new ByteBuffer[]{header})));
        this.selector.close();
        TestUtils.waitForCondition(() -> this.server.selector().channels().isEmpty(), "Server should have closed connection");
        Assertions.assertTrue((testProxyProtocolEngine.processCallCount() <= 1 ? 1 : 0) != 0);
    }

    private Selector createSelector(Map<String, Object> configs) {
        LogContext logContext = new LogContext();
        PlaintextChannelBuilder channelBuilder = new PlaintextChannelBuilder(ConnectionMode.CLIENT, null, new ProxyProtocolEngineFactory(ProxyProtocol.NONE));
        channelBuilder.configure(configs);
        return new Selector(5000L, new Metrics(), TIME, "MetricGroup", (ChannelBuilder)channelBuilder, logContext);
    }

    private static void verifyServerProxyAddress(NioEchoServer server, InetAddress expectedAddress) {
        Selector serverSelector = server.selector();
        Assertions.assertNotEquals(Collections.emptyList(), (Object)serverSelector.channels());
        serverSelector.channels().forEach(proxyChannel -> Assertions.assertEquals((Object)expectedAddress, (Object)proxyChannel.socketAddress()));
    }
}

