/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.ListSerializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ListSerializerTest {
    private final ListSerializer<?> listSerializer = new ListSerializer();
    private final Map<String, Object> props = new HashMap<String, Object>();
    private final String nonExistingClass = "non.existing.class";

    @Test
    public void testListKeySerializerNoArgConstructorsWithClassName() {
        this.props.put("default.list.key.serde.inner", Serdes.StringSerde.class.getName());
        this.listSerializer.configure(this.props, true);
        Serializer inner = this.listSerializer.getInnerSerializer();
        Assertions.assertNotNull((Object)inner, (String)"Inner serializer should be not null");
        Assertions.assertInstanceOf(StringSerializer.class, (Object)inner, (String)"Inner serializer type should be StringSerializer");
    }

    @Test
    public void testListValueSerializerNoArgConstructorsWithClassName() {
        this.props.put("default.list.value.serde.inner", Serdes.StringSerde.class.getName());
        this.listSerializer.configure(this.props, false);
        Serializer inner = this.listSerializer.getInnerSerializer();
        Assertions.assertNotNull((Object)inner, (String)"Inner serializer should be not null");
        Assertions.assertInstanceOf(StringSerializer.class, (Object)inner, (String)"Inner serializer type should be StringSerializer");
    }

    @Test
    public void testListKeySerializerNoArgConstructorsWithClassObject() {
        this.props.put("default.list.key.serde.inner", Serdes.StringSerde.class);
        this.listSerializer.configure(this.props, true);
        Serializer inner = this.listSerializer.getInnerSerializer();
        Assertions.assertNotNull((Object)inner, (String)"Inner serializer should be not null");
        Assertions.assertInstanceOf(StringSerializer.class, (Object)inner, (String)"Inner serializer type should be StringSerializer");
    }

    @Test
    public void testListValueSerializerNoArgConstructorsWithClassObject() {
        this.props.put("default.list.value.serde.inner", Serdes.StringSerde.class);
        this.listSerializer.configure(this.props, false);
        Serializer inner = this.listSerializer.getInnerSerializer();
        Assertions.assertNotNull((Object)inner, (String)"Inner serializer should be not null");
        Assertions.assertInstanceOf(StringSerializer.class, (Object)inner, (String)"Inner serializer type should be StringSerializer");
    }

    @Test
    public void testListSerializerNoArgConstructorsShouldThrowConfigExceptionDueMissingProp() {
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> this.listSerializer.configure(this.props, true));
        Assertions.assertEquals((Object)"Not able to determine the serializer class because it was neither passed via the constructor nor set in the config.", (Object)exception.getMessage());
        exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> this.listSerializer.configure(this.props, false));
        Assertions.assertEquals((Object)"Not able to determine the serializer class because it was neither passed via the constructor nor set in the config.", (Object)exception.getMessage());
    }

    @Test
    public void testListKeySerializerNoArgConstructorsShouldThrowKafkaExceptionDueInvalidClass() {
        this.props.put("default.list.key.serde.inner", new FakeObject());
        KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> this.listSerializer.configure(this.props, true));
        Assertions.assertEquals((Object)"Could not create a serializer class instance using \"default.list.key.serde.inner\" property.", (Object)exception.getMessage());
    }

    @Test
    public void testListValueSerializerNoArgConstructorsShouldThrowKafkaExceptionDueInvalidClass() {
        this.props.put("default.list.value.serde.inner", new FakeObject());
        KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> this.listSerializer.configure(this.props, false));
        Assertions.assertEquals((Object)"Could not create a serializer class instance using \"default.list.value.serde.inner\" property.", (Object)exception.getMessage());
    }

    @Test
    public void testListKeySerializerNoArgConstructorsShouldThrowKafkaExceptionDueClassNotFound() {
        this.props.put("default.list.key.serde.inner", "non.existing.class");
        KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> this.listSerializer.configure(this.props, true));
        Assertions.assertEquals((Object)"Invalid value non.existing.class for configuration default.list.key.serde.inner: Serializer class non.existing.class could not be found.", (Object)exception.getMessage());
    }

    @Test
    public void testListValueSerializerNoArgConstructorsShouldThrowKafkaExceptionDueClassNotFound() {
        this.props.put("default.list.value.serde.inner", "non.existing.class");
        KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> this.listSerializer.configure(this.props, false));
        Assertions.assertEquals((Object)"Invalid value non.existing.class for configuration default.list.value.serde.inner: Serializer class non.existing.class could not be found.", (Object)exception.getMessage());
    }

    @Test
    public void testListKeySerializerShouldThrowConfigExceptionDueAlreadyInitialized() {
        this.props.put("default.list.key.serde.inner", Serdes.StringSerde.class);
        ListSerializer initializedListSerializer = new ListSerializer(Serdes.Integer().serializer());
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> initializedListSerializer.configure(this.props, true));
        Assertions.assertEquals((Object)"List serializer was already initialized using a non-default constructor", (Object)exception.getMessage());
    }

    @Test
    public void testListValueSerializerShouldThrowConfigExceptionDueAlreadyInitialized() {
        this.props.put("default.list.value.serde.inner", Serdes.StringSerde.class);
        ListSerializer initializedListSerializer = new ListSerializer(Serdes.Integer().serializer());
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> initializedListSerializer.configure(this.props, false));
        Assertions.assertEquals((Object)"List serializer was already initialized using a non-default constructor", (Object)exception.getMessage());
    }

    private static class FakeObject {
        private FakeObject() {
        }
    }
}

