/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.transaction.generated;

import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogKey;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogValue;

public enum CoordinatorRecordType {
    TRANSACTION_LOG("TransactionLog", 0, 0, 1);

    private final String name;
    private final short id;
    private final short lowestSupportedVersion;
    private final short highestSupportedVersion;

    private CoordinatorRecordType(String name, short id, short lowestSupportedVersion, short highestSupportedVersion) {
        this.name = name;
        this.id = id;
        this.lowestSupportedVersion = lowestSupportedVersion;
        this.highestSupportedVersion = highestSupportedVersion;
    }

    public static CoordinatorRecordType fromId(short id) {
        switch (id) {
            case 0: {
                return TRANSACTION_LOG;
            }
        }
        throw new UnsupportedVersionException("Unknown record id " + id);
    }

    public ApiMessage newRecordKey() {
        switch (this.id) {
            case 0: {
                return new TransactionLogKey();
            }
        }
        throw new UnsupportedVersionException("Unknown record id " + this.id);
    }

    public ApiMessage newRecordValue() {
        switch (this.id) {
            case 0: {
                return new TransactionLogValue();
            }
        }
        throw new UnsupportedVersionException("Unknown record id " + this.id);
    }

    public short id() {
        return this.id;
    }

    public short lowestSupportedVersion() {
        return this.lowestSupportedVersion;
    }

    public short highestSupportedVersion() {
        return this.highestSupportedVersion;
    }

    public String toString() {
        return this.name();
    }
}

