/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.common.utils;

import io.confluent.kafka.common.utils.ConfluentUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfluentUtilsTest {
    @Test
    public void testHasCCloudHostPatternWithDefaults() {
        HashMap brokerConfigs = new HashMap();
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"localhost"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"test.stag.cpdev.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"test.devel.cpdev.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"foo.bar.us-west2.aws.confluent.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"foo.bar.us-west2.aws.confluent.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"foo.bar.us-west2.aws.confluent.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"FOO.BAR.CONFLUENT.cloud"));
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"test.stag.cpdev.cloudxxx"));
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"test.devel.xxxxcpdev.cloud"));
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"foo.bar.us-west2.aws.confluent.cloud.xxx"));
    }

    @Test
    public void testHasCCloudHostPatternWithConfigs() {
        HashMap<String, String> brokerConfigs = new HashMap<String, String>();
        brokerConfigs.put("confluent.ccloud.host.suffixes", ".aws.confluent,.confluent.fedramp");
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"localhost"));
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"test.stag.cpdev.cloud"));
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"foo.bar.us-west2.aws.confluent.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"foo.bar.us-west2.aws.confluent"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"pkc-xxx.confluent.fedramp"));
    }

    @Test
    public void testHasCCloudIntranetHostPatternWithDefaults() {
        HashMap brokerConfigs = new HashMap();
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudIntranetHostPattern(brokerConfigs, (String)"localhost"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudIntranetHostPattern(brokerConfigs, (String)"test.intranet.stag.cpdev.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudIntranetHostPattern(brokerConfigs, (String)"test.intranet.devel.cpdev.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudIntranetHostPattern(brokerConfigs, (String)"foo.bar.us-west2.aws.intranet.confluent.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudIntranetHostPattern(brokerConfigs, (String)"foo.bar.us-west2.aws.intranet.confluent.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudIntranetHostPattern(brokerConfigs, (String)"foo.bar.us-west2.aws.intranet.confluent.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudIntranetHostPattern(brokerConfigs, (String)"FOO.BAR.intranet.CONFLUENT.cloud"));
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudIntranetHostPattern(brokerConfigs, (String)"test.intranet.stag.cpdev.cloudxxx"));
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudIntranetHostPattern(brokerConfigs, (String)"test.intranet.devel.xxxxcpdev.cloud"));
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudIntranetHostPattern(brokerConfigs, (String)"foo.bar.us-west2.aws.confluent.cloud.xxx"));
    }

    @Test
    public void testHasCCloudIntranetHostPatternWithConfigs() {
        HashMap<String, String> brokerConfigs = new HashMap<String, String>();
        brokerConfigs.put("confluent.ccloud.intranet.host.suffixes", ".intranet.aws.confluent,.intranet.confluent.fedramp");
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudIntranetHostPattern(brokerConfigs, (String)"localhost"));
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudIntranetHostPattern(brokerConfigs, (String)"test.stag.cpdev.cloud"));
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudIntranetHostPattern(brokerConfigs, (String)"foo.bar.us-west2.intranet.aws.confluent.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudIntranetHostPattern(brokerConfigs, (String)"foo.bar.us-west2.intranet.aws.confluent"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudIntranetHostPattern(brokerConfigs, (String)"pkc-xxx.intranet.confluent.fedramp"));
    }

    @Test
    public void testExtractClusterId() {
        Assertions.assertEquals((Object)"lkc-2v531", (Object)ConfluentUtils.extractClusterIdFromHost((String)"lkc-2v531-lg1y3.us-west-1.aws.glb.confluent.cloud:9092"));
        Assertions.assertEquals((Object)"lkc-abc123", (Object)ConfluentUtils.extractClusterIdFromHost((String)"lkc-abc123-9ae1-usw2-az2.us-west-2.aws.confluent.cloud:9092"));
        Assertions.assertEquals((Object)"lkc-2v531", (Object)ConfluentUtils.extractClusterIdFromHost((String)"lkc-2v531-lg1y3.use-west-1.aws.glb.confluent.cloud:9092"));
        Assertions.assertEquals((Object)"lkc-2v531", (Object)ConfluentUtils.extractClusterIdFromHost((String)"lkc-2v531.lg1y3.us-west-1.aws.confluent.cloud:9092"));
        Assertions.assertEquals((Object)"lkc-2v531", (Object)ConfluentUtils.extractClusterIdFromHost((String)"lkc-2v531-lg1y3.us-west-1.aws.glb.confluent.cloud:9092"));
        Assertions.assertEquals((Object)"lkc-2v531", (Object)ConfluentUtils.extractClusterIdFromHost((String)"lkc-2v531.domz6wj0p.us-west-1.aws.confluent.cloud:9092"));
        Assertions.assertEquals((Object)"lkc-abc123", (Object)ConfluentUtils.extractClusterIdFromHost((String)"lkc-abc123.us-west-2.aws.private.confluent.cloud:9092"));
        Assertions.assertEquals((Object)"lkc-abc123", (Object)ConfluentUtils.extractClusterIdFromHost((String)"lkc-abc123.us-west-2.aws.intranet.confluent.cloud:9078"));
        Assertions.assertNull((Object)ConfluentUtils.extractClusterIdFromHost((String)"pkc-2396y.us-east-1.aws.confluent.cloud:9092"));
    }

    @Test
    public void testMaybeParseRemoteClusterIdFromBootstrap() {
        Optional result = ConfluentUtils.maybeParseRemoteClusterIdFromBootstrap(Arrays.asList("", null));
        Assertions.assertFalse((boolean)result.isPresent());
        result = ConfluentUtils.maybeParseRemoteClusterIdFromBootstrap(Arrays.asList(null, "lkc-1234.us-east-1.aws.confluent.cloud:9092"));
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)"lkc-1234", result.orElse(null));
        result = ConfluentUtils.maybeParseRemoteClusterIdFromBootstrap(Arrays.asList("SASL_SSL://lkc-1234.us-east-1.aws.confluent.cloud:9092", "foo:9092"));
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)"lkc-1234", result.orElse(null));
        result = ConfluentUtils.maybeParseRemoteClusterIdFromBootstrap(Arrays.asList("lkc-1234.us-east-1.aws.confluent.cloud:9092", "localhost:9092"));
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)"lkc-1234", result.orElse(null));
        result = ConfluentUtils.maybeParseRemoteClusterIdFromBootstrap(Arrays.asList("LKC-1234.us-east-1.aws.confluent.cloud:9092", "localhost:9092"));
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)"lkc-1234", result.orElse(null));
        result = ConfluentUtils.maybeParseRemoteClusterIdFromBootstrap(Arrays.asList("", "localhost-lkc-dd:9092", "LKC-1234.us-east-1.aws.confluent.cloud:9092"));
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)"lkc-1234", result.orElse(null));
        result = ConfluentUtils.maybeParseRemoteClusterIdFromBootstrap(Collections.emptyList());
        Assertions.assertFalse((boolean)result.isPresent());
        result = ConfluentUtils.maybeParseRemoteClusterIdFromBootstrap(null);
        Assertions.assertFalse((boolean)result.isPresent());
        result = ConfluentUtils.maybeParseRemoteClusterIdFromBootstrap(Collections.singletonList("localhost:9092"));
        Assertions.assertFalse((boolean)result.isPresent());
    }
}

