/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.concurrent;

import io.confluent.kafka.concurrent.DefaultEventExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

final class DefaultEventExecutorTest {
    int defaultTimeoutSec = 10;

    DefaultEventExecutorTest() {
    }

    private DefaultEventExecutor createExecutor(int capacity) {
        return new DefaultEventExecutor(Executors.defaultThreadFactory(), capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSubmitRunnable() throws Exception {
        CompletableFuture shutdown;
        DefaultEventExecutor executor = this.createExecutor(1);
        try {
            AtomicBoolean executed = new AtomicBoolean(false);
            CompletableFuture future = executor.submit(() -> executed.set(true));
            Assertions.assertNull(future.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)executed.get());
        }
        finally {
            shutdown = executor.shutdown();
        }
        Assertions.assertNull(shutdown.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSubmitRunnableException() throws Exception {
        CompletableFuture shutdown;
        DefaultEventExecutor executor = this.createExecutor(1);
        try {
            CompletableFuture future = executor.submit(() -> {
                throw new RuntimeException();
            });
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> future.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
            Assertions.assertEquals(RuntimeException.class, exception.getCause().getClass());
        }
        finally {
            shutdown = executor.shutdown();
        }
        Assertions.assertNull(shutdown.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSubmitCallable() throws Exception {
        CompletableFuture shutdown;
        DefaultEventExecutor executor = this.createExecutor(1);
        try {
            int expected = 42;
            CompletableFuture future = executor.submit(() -> expected);
            Assertions.assertEquals((int)expected, (Integer)((Integer)future.get(this.defaultTimeoutSec, TimeUnit.SECONDS)));
        }
        finally {
            shutdown = executor.shutdown();
        }
        Assertions.assertNull(shutdown.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testScheduleRunnable() throws Exception {
        CompletableFuture shutdown;
        DefaultEventExecutor executor = this.createExecutor(1);
        try {
            AtomicBoolean executed = new AtomicBoolean(false);
            long delaySec = 1L;
            long start = Time.SYSTEM.milliseconds();
            CompletableFuture future = executor.schedule(() -> executed.set(true), delaySec, TimeUnit.SECONDS);
            Assertions.assertNull(future.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
            long now = Time.SYSTEM.milliseconds();
            Assertions.assertTrue((now - start >= TimeUnit.SECONDS.toMillis(delaySec) ? 1 : 0) != 0, (String)String.format("now (%s) ms - start (%s) ms (%s) is not greater than delay (%s) seconds", now, start, now - start, delaySec));
            Assertions.assertTrue((boolean)executed.get());
        }
        finally {
            shutdown = executor.shutdown();
        }
        Assertions.assertNull(shutdown.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testScheduleCallable() throws Exception {
        CompletableFuture shutdown;
        DefaultEventExecutor executor = this.createExecutor(1);
        try {
            long delaySec = 1L;
            int expected = 42;
            long start = Time.SYSTEM.milliseconds();
            CompletableFuture future = executor.schedule(() -> expected, delaySec, TimeUnit.SECONDS);
            Assertions.assertEquals((int)expected, (Integer)((Integer)future.get(this.defaultTimeoutSec, TimeUnit.SECONDS)));
            long now = Time.SYSTEM.milliseconds();
            Assertions.assertTrue((now - start >= TimeUnit.SECONDS.toMillis(delaySec) ? 1 : 0) != 0, (String)String.format("now (%s) ms - start (%s) ms (%s) is not greater than delay (%s) seconds", now, start, now - start, delaySec));
        }
        finally {
            shutdown = executor.shutdown();
        }
        Assertions.assertNull(shutdown.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testScheduleCallableException() throws Exception {
        CompletableFuture shutdown;
        DefaultEventExecutor executor = this.createExecutor(1);
        try {
            long delaySec = 1L;
            long start = Time.SYSTEM.milliseconds();
            CompletableFuture future = executor.schedule(() -> {
                throw new RuntimeException();
            }, delaySec, TimeUnit.SECONDS);
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> future.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
            Assertions.assertEquals(RuntimeException.class, exception.getCause().getClass());
            long now = Time.SYSTEM.milliseconds();
            Assertions.assertTrue((now - start >= TimeUnit.SECONDS.toMillis(delaySec) ? 1 : 0) != 0, (String)String.format("now (%s) ms - start (%s) ms (%s) is not greater than delay (%s) seconds", now, start, now - start, delaySec));
        }
        finally {
            shutdown = executor.shutdown();
        }
        Assertions.assertNull(shutdown.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCancelSubmit() throws Exception {
        CompletableFuture shutdown;
        DefaultEventExecutor executor = this.createExecutor(2);
        try {
            CountDownLatch startLatch = new CountDownLatch(1);
            CompletableFuture latchFuture = executor.submit(() -> Assertions.assertDoesNotThrow(() -> startLatch.await()));
            AtomicBoolean executed = new AtomicBoolean(false);
            CompletableFuture future = executor.submit(() -> executed.set(true));
            Assertions.assertFalse((boolean)executed.get());
            Assertions.assertFalse((boolean)future.isDone());
            future.cancel(false);
            startLatch.countDown();
            Assertions.assertNull(latchFuture.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)executed.get());
            Assertions.assertTrue((boolean)future.isDone());
            Assertions.assertTrue((boolean)future.isCancelled());
            Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        }
        finally {
            shutdown = executor.shutdown();
        }
        Assertions.assertNull(shutdown.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCancelSchedule() throws Exception {
        CompletableFuture shutdown;
        DefaultEventExecutor executor = this.createExecutor(2);
        try {
            CountDownLatch startLatch = new CountDownLatch(1);
            CompletableFuture latchFuture = executor.submit(() -> Assertions.assertDoesNotThrow(() -> startLatch.await()));
            AtomicBoolean executed = new AtomicBoolean(false);
            long delayMs = 100L;
            CompletableFuture future = executor.schedule(() -> executed.set(true), delayMs, TimeUnit.MILLISECONDS);
            Assertions.assertFalse((boolean)executed.get());
            Assertions.assertFalse((boolean)future.isDone());
            future.cancel(false);
            startLatch.countDown();
            Assertions.assertNull(latchFuture.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)executed.get());
            Assertions.assertTrue((boolean)future.isDone());
            Assertions.assertTrue((boolean)future.isCancelled());
            Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        }
        finally {
            shutdown = executor.shutdown();
        }
        Assertions.assertNull(shutdown.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCapacitySubmit() throws Exception {
        CompletableFuture shutdown;
        DefaultEventExecutor executor = this.createExecutor(1);
        try {
            CountDownLatch startLatch = new CountDownLatch(1);
            CountDownLatch scheduledLatch = new CountDownLatch(1);
            CompletableFuture latchFuture = executor.submit(() -> {
                scheduledLatch.countDown();
                Assertions.assertDoesNotThrow(() -> startLatch.await());
            });
            scheduledLatch.await();
            CompletableFuture future = executor.submit(() -> null);
            Assertions.assertThrows(RejectedExecutionException.class, () -> executor.submit(() -> null));
            Assertions.assertThrows(RejectedExecutionException.class, () -> executor.schedule(() -> null, 1L, TimeUnit.NANOSECONDS));
            startLatch.countDown();
            Assertions.assertNull(latchFuture.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
            Assertions.assertNull(future.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
            executor.submit(() -> null);
        }
        finally {
            shutdown = executor.shutdown();
        }
        Assertions.assertNull(shutdown.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCapacitySchedule() throws Exception {
        CompletableFuture shutdown;
        DefaultEventExecutor executor = this.createExecutor(1);
        try {
            CountDownLatch startLatch = new CountDownLatch(1);
            CountDownLatch scheduledLatch = new CountDownLatch(1);
            CompletableFuture latchFuture = executor.schedule(() -> {
                scheduledLatch.countDown();
                Assertions.assertDoesNotThrow(() -> startLatch.await());
            }, 1L, TimeUnit.NANOSECONDS);
            scheduledLatch.await();
            CompletableFuture future = executor.schedule(() -> null, 1L, TimeUnit.NANOSECONDS);
            Assertions.assertThrows(RejectedExecutionException.class, () -> executor.submit(() -> null));
            Assertions.assertThrows(RejectedExecutionException.class, () -> executor.schedule(() -> null, 1L, TimeUnit.NANOSECONDS));
            startLatch.countDown();
            Assertions.assertNull(latchFuture.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
            Assertions.assertNull(future.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
            executor.submit(() -> null);
        }
        finally {
            shutdown = executor.shutdown();
        }
        Assertions.assertNull(shutdown.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testShutdown() throws Exception {
        CompletableFuture shutdown;
        DefaultEventExecutor executor = this.createExecutor(1);
        try {
            AtomicBoolean executed = new AtomicBoolean(false);
            long delaySec = 1000L;
            CompletableFuture future = executor.schedule(() -> executed.set(true), delaySec, TimeUnit.SECONDS);
            shutdown = executor.shutdown();
            Assertions.assertThrows(RejectedExecutionException.class, () -> executor.submit(() -> null));
            Assertions.assertNull(shutdown.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)executed.get());
            Assertions.assertFalse((boolean)future.isDone());
            Assertions.assertFalse((boolean)future.isCancelled());
            Assertions.assertFalse((boolean)future.isCompletedExceptionally());
        }
        finally {
            shutdown = executor.shutdown();
        }
        Assertions.assertNull(shutdown.get(this.defaultTimeoutSec, TimeUnit.SECONDS));
    }
}

