/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Collections;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FinalizedFeaturesTest {
    FinalizedFeaturesTest() {
    }

    @Test
    public void testKRaftModeFeatures() {
        FinalizedFeatures finalizedFeatures = new FinalizedFeatures(MetadataVersion.MINIMUM_VERSION, Collections.singletonMap("foo", (short)2), 123L, true);
        Assertions.assertEquals((short)MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel(), (Short)((Short)finalizedFeatures.finalizedFeatures().get("confluent.metadata.version")));
        Assertions.assertEquals((short)2, (Short)((Short)finalizedFeatures.finalizedFeatures().get("foo")));
        Assertions.assertEquals((int)2, (int)finalizedFeatures.finalizedFeatures().size());
    }

    @Test
    public void testZkModeFeatures() {
        FinalizedFeatures finalizedFeatures = new FinalizedFeatures(MetadataVersion.MINIMUM_VERSION, Collections.singletonMap("foo", (short)2), 123L, false);
        Assertions.assertNull(finalizedFeatures.finalizedFeatures().get("confluent.metadata.version"));
        Assertions.assertEquals((short)2, (Short)((Short)finalizedFeatures.finalizedFeatures().get("foo")));
        Assertions.assertEquals((int)1, (int)finalizedFeatures.finalizedFeatures().size());
    }

    @Test
    public void testSetFinalizedLevel() {
        FinalizedFeatures finalizedFeatures = new FinalizedFeatures(MetadataVersion.MINIMUM_VERSION, Collections.singletonMap("foo", (short)2), 123L, true);
        FinalizedFeatures removedFeatures = finalizedFeatures.setFinalizedLevel("foo", (short)0);
        Assertions.assertNull(removedFeatures.finalizedFeatures().get("foo"));
        FinalizedFeatures sameFeatures = removedFeatures.setFinalizedLevel("foo", (short)0);
        Assertions.assertEquals((Object)sameFeatures.finalizedFeatures(), (Object)removedFeatures.finalizedFeatures());
    }
}

