/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.immutable;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;

public abstract class DelegationChecker<D, W, T> {
    private final D mock;
    private final W wrapper;
    private Consumer<D> mockConsumer;
    private Function<D, T> mockConfigurationFunction;
    private T mockFunctionReturnValue;
    private Consumer<W> wrapperConsumer;
    private Function<W, T> wrapperFunctionApplier;
    private Function<T, ?> mockFunctionReturnValueTransformation;
    private boolean expectWrapperToWrapMockFunctionReturnValue;
    private boolean persistentCollectionMethodInvokedCorrectly = false;

    protected DelegationChecker(D mock, Function<D, W> wrapperCreator) {
        this.mock = Objects.requireNonNull(mock);
        this.wrapper = Objects.requireNonNull(wrapperCreator).apply(mock);
    }

    public abstract D unwrap(W var1);

    public DelegationChecker<D, W, T> defineMockConfigurationForVoidMethodInvocation(Consumer<D> mockConsumer) {
        this.mockConsumer = Objects.requireNonNull(mockConsumer);
        return this;
    }

    public DelegationChecker<D, W, T> defineMockConfigurationForFunctionInvocation(Function<D, T> mockConfigurationFunction, T mockFunctionReturnValue) {
        this.mockConfigurationFunction = Objects.requireNonNull(mockConfigurationFunction);
        this.mockFunctionReturnValue = mockFunctionReturnValue;
        return this;
    }

    public DelegationChecker<D, W, T> defineMockConfigurationForUnsupportedFunction(Function<D, T> mockConfigurationFunction) {
        this.mockConfigurationFunction = Objects.requireNonNull(mockConfigurationFunction);
        return this;
    }

    public DelegationChecker<D, W, T> defineWrapperVoidMethodInvocation(Consumer<W> wrapperConsumer) {
        this.wrapperConsumer = Objects.requireNonNull(wrapperConsumer);
        return this;
    }

    public <R> DelegationChecker<D, W, T> defineWrapperFunctionInvocationAndMockReturnValueTransformation(Function<W, T> wrapperFunctionApplier, Function<T, R> expectedFunctionReturnValueTransformation) {
        this.wrapperFunctionApplier = Objects.requireNonNull(wrapperFunctionApplier);
        this.mockFunctionReturnValueTransformation = Objects.requireNonNull(expectedFunctionReturnValueTransformation);
        return this;
    }

    public DelegationChecker<D, W, T> defineWrapperUnsupportedFunctionInvocation(Function<W, T> wrapperFunctionApplier) {
        this.wrapperFunctionApplier = Objects.requireNonNull(wrapperFunctionApplier);
        return this;
    }

    public DelegationChecker<D, W, T> expectWrapperToWrapMockFunctionReturnValue() {
        this.expectWrapperToWrapMockFunctionReturnValue = true;
        return this;
    }

    public void doVoidMethodDelegationCheck() {
        if (this.mockConsumer == null || this.wrapperConsumer == null || this.mockConfigurationFunction != null || this.wrapperFunctionApplier != null || this.mockFunctionReturnValue != null || this.mockFunctionReturnValueTransformation != null) {
            DelegationChecker.throwExceptionForIllegalTestSetup();
        }
        this.mockConsumer.accept(Mockito.doAnswer(invocation -> {
            this.persistentCollectionMethodInvokedCorrectly = true;
            return null;
        }).when(this.mock));
        this.wrapperConsumer.accept(this.wrapper);
        Assertions.assertTrue((boolean)this.persistentCollectionMethodInvokedCorrectly);
    }

    public void doUnsupportedVoidFunctionDelegationCheck() {
        if (this.mockConsumer == null || this.wrapperConsumer == null) {
            DelegationChecker.throwExceptionForIllegalTestSetup();
        }
        this.mockConsumer.accept(Mockito.doCallRealMethod().when(this.mock));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.wrapperConsumer.accept(this.wrapper), (String)"Expected to Throw UnsupportedOperationException");
    }

    public void doFunctionDelegationCheck() {
        if (this.mockConfigurationFunction == null || this.wrapperFunctionApplier == null || this.mockFunctionReturnValueTransformation == null || this.mockConsumer != null || this.wrapperConsumer != null) {
            DelegationChecker.throwExceptionForIllegalTestSetup();
        }
        Mockito.when(this.mockConfigurationFunction.apply(this.mock)).thenAnswer(invocation -> {
            this.persistentCollectionMethodInvokedCorrectly = true;
            return this.mockFunctionReturnValue;
        });
        T wrapperReturnValue = this.wrapperFunctionApplier.apply(this.wrapper);
        Assertions.assertTrue((boolean)this.persistentCollectionMethodInvokedCorrectly);
        Object transformedMockFunctionReturnValue = this.mockFunctionReturnValueTransformation.apply(this.mockFunctionReturnValue);
        if (this.expectWrapperToWrapMockFunctionReturnValue) {
            Assertions.assertEquals(transformedMockFunctionReturnValue, this.unwrap(wrapperReturnValue));
        } else {
            Assertions.assertEquals(transformedMockFunctionReturnValue, wrapperReturnValue);
        }
    }

    public void doUnsupportedFunctionDelegationCheck() {
        if (this.mockConfigurationFunction == null || this.wrapperFunctionApplier == null) {
            DelegationChecker.throwExceptionForIllegalTestSetup();
        }
        Mockito.when(this.mockConfigurationFunction.apply(this.mock)).thenCallRealMethod();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.wrapperFunctionApplier.apply(this.wrapper), (String)"Expected to Throw UnsupportedOperationException");
    }

    private static void throwExceptionForIllegalTestSetup() {
        throw new IllegalStateException("test setup error: must define both mock and wrapper consumers or both mock and wrapper functions");
    }
}

