/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.Collections;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class TimelineLongTest {
    @Test
    public void testModifyValue() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineLong value = new TimelineLong(registry);
        Assertions.assertEquals((long)0L, (long)value.get());
        Assertions.assertEquals((long)0L, (long)value.get(Long.MAX_VALUE));
        value.set(1L);
        value.set(Long.MAX_VALUE);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)value.get());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)value.get(Long.MAX_VALUE));
    }

    @Test
    public void testToStringAndEquals() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineLong value = new TimelineLong(registry);
        Assertions.assertEquals((Object)"0", (Object)value.toString());
        value.set(1L);
        TimelineLong integer2 = new TimelineLong(registry);
        integer2.set(1L);
        Assertions.assertEquals((Object)"1", (Object)integer2.toString());
        Assertions.assertEquals((Object)value, (Object)integer2);
    }

    @Test
    public void testSnapshot() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineLong value = new TimelineLong(registry);
        registry.idempotentCreateSnapshot(2L);
        value.set(1L);
        registry.idempotentCreateSnapshot(3L);
        value.set(2L);
        value.increment();
        value.increment();
        value.decrement();
        registry.idempotentCreateSnapshot(4L);
        Assertions.assertEquals((long)0L, (long)value.get(2L));
        Assertions.assertEquals((long)1L, (long)value.get(3L));
        Assertions.assertEquals((long)3L, (long)value.get(4L));
        registry.revertToSnapshot(3L);
        Assertions.assertEquals((long)1L, (long)value.get());
        registry.revertToSnapshot(2L);
        Assertions.assertEquals((long)0L, (long)value.get());
    }

    @Test
    public void testReset() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineLong value = new TimelineLong(registry);
        registry.idempotentCreateSnapshot(2L);
        value.set(1L);
        registry.idempotentCreateSnapshot(3L);
        value.set(2L);
        registry.reset();
        Assertions.assertEquals(Collections.emptyList(), (Object)registry.epochsList());
        Assertions.assertEquals((long)0L, (long)value.get());
    }
}

