/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.airlift.airline.Cli;
import io.airlift.airline.Command;
import io.airlift.airline.Help;
import io.airlift.airline.Option;
import io.airlift.airline.ParseException;
import io.confluent.kafka.databalancing.CommandContext;
import io.confluent.kafka.databalancing.ProposedRebalance;
import io.confluent.kafka.databalancing.ReassignmentFailedException;
import io.confluent.kafka.databalancing.Rebalancer;
import io.confluent.kafka.databalancing.RebalancerConfig;
import io.confluent.kafka.databalancing.RebalancerFactory;
import io.confluent.kafka.databalancing.exception.NoRebalanceInProgressException;
import io.confluent.kafka.databalancing.exception.RebalanceInProgressException;
import io.confluent.kafka.databalancing.exception.ValidationException;
import io.confluent.kafka.databalancing.license.DefaultLicenseValidator;
import io.confluent.kafka.databalancing.license.LicenseValidator;
import io.confluent.kafka.databalancing.report.RebalanceReport;
import io.confluent.kafka.databalancing.topology.ClusterReassignment;
import io.confluent.kafka.databalancing.view.DefaultRebalancerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.AdminCommandFailedException;
import org.apache.kafka.server.common.AdminOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentRebalancerCommand {
    private static final Logger log = LoggerFactory.getLogger(ConfluentRebalancerCommand.class);

    public static void main(String ... args) {
        try {
            ConfluentRebalancerCommand.run(new DefaultRebalancerFactory(), null, args);
        }
        catch (ParseException | ValidationException | IllegalArgumentException | AdminCommandFailedException | AdminOperationException e) {
            System.out.println(String.format("Error: %s", e.getMessage()));
            System.exit(1);
        }
        catch (Throwable t) {
            System.out.println("Unexpected exception: " + t.getMessage());
            System.out.println(Utils.stackTrace((Throwable)t));
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(RebalancerFactory rebalancerFactory, LicenseValidator licenseValidator, String ... args) {
        Cli.CliBuilder builder = Cli.builder((String)"confluent-rebalancer").withDescription("Confluent Rebalancer Tool for Kafka").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{ProposedAssignment.class, Execute.class, Cancel.class, Status.class, Finish.class});
        Cli cli = builder.build();
        Runnable runnable = (Runnable)cli.parse(args);
        if (runnable instanceof BaseRebalanceCommand) {
            BaseRebalanceCommand command = (BaseRebalanceCommand)runnable;
            command.setRebalancerFactory(rebalancerFactory);
            command.setLicenseValidator(licenseValidator);
            try {
                command.run();
            }
            finally {
                command.close();
            }
        } else {
            runnable.run();
        }
    }

    @Command(name="proposed-assignment", description="Generate the proposed partition assignment and output it in JSON format")
    public static class ProposedAssignment
    extends BaseReassignCommand {
        @Override
        protected void doRun() {
            Rebalancer rebalancer = this.getOrCreateRebalancer();
            ProposedRebalance proposedRebalance = rebalancer.proposeRebalance(this.buildCommandContext());
            try {
                String json = proposedRebalance.proposedAssignmentChanges().toJson();
                System.out.println(json);
            }
            catch (JsonProcessingException e) {
                log.error("JSON encoding failure for proposed assignment changes {}", (Object)proposedRebalance.proposedAssignmentChanges().toString(), (Object)e);
                System.out.println("Encountered error while encoding the proposed assignment changes as JSON");
                Exit.exit((int)1);
            }
        }
    }

    @Command(name="execute", description="Kick off a cluster-wide rebalance operation")
    public static class Execute
    extends BaseReassignCommand {
        @Option(name={"--throttle"}, required=true, description="The maximum bandwidth, in bytes per second, allocated to moving replicas.")
        protected long replicationQuota;
        @Option(name={"--force"}, description="Suppress prompts if true")
        protected boolean force;
        @Option(name={"--verbose"}, description="Also output before/after per broker information (disk space usage, leader count, replica count, topic partitions)")
        private boolean verbose = false;
        @Option(name={"--incremental"}, description="Indicates that partitions should be moved incrementally. The rebalancer will reassign partitions in batches so that `max.concurrent.moves.per.leader` is not exceeded. The command will not return until all reassignments have completed. Note this option is only available for brokers with Confluent Platform 5.4 (Apache Kafka 2.4) or higher.")
        private boolean incremental = false;

        @Override
        protected void doRun() {
            CommandContext commandContext = this.buildCommandContext();
            Rebalancer rebalancer = this.getOrCreateRebalancer();
            boolean maybeUpdateQuota = rebalancer.maybeUpdateReplicationQuota(this.replicationQuota, this.excludeInternalTopics);
            if (maybeUpdateQuota) {
                return;
            }
            System.out.println("Computing the rebalance plan (this may take a while) ...");
            ProposedRebalance proposedRebalance = rebalancer.proposeRebalance(commandContext);
            if (!this.checkIfProceedWithRebalance(rebalancer, proposedRebalance)) {
                return;
            }
            RebalanceReport report = proposedRebalance.report();
            report.print(System.out, this.verbose);
            Scanner scanner = new Scanner(System.in, "UTF-8");
            if (this.force) {
                this.startRebalance(rebalancer, proposedRebalance);
            } else {
                Boolean startRebalance = null;
                do {
                    System.out.print("Would you like to continue? (y/n): ");
                    String line = scanner.nextLine();
                    if (line == null) continue;
                    if (line.equalsIgnoreCase("y")) {
                        startRebalance = true;
                        continue;
                    }
                    if (!line.equalsIgnoreCase("n")) continue;
                    startRebalance = false;
                } while (startRebalance == null);
                System.out.println();
                if (startRebalance.booleanValue()) {
                    this.startRebalance(rebalancer, proposedRebalance);
                } else {
                    System.out.println("OK, exiting");
                }
            }
        }

        @Override
        protected Rebalancer buildRebalancer(RebalancerFactory factory) {
            return factory.create(this.commandConfig(), this.incremental, this.rebalancerConfig);
        }

        private boolean checkIfProceedWithRebalance(Rebalancer rebalancer, ProposedRebalance proposedRebalance) {
            if (!proposedRebalance.shouldRebalance()) {
                if (rebalancer.disengageThrottle()) {
                    System.out.println("The throttle was removed.");
                }
                System.out.println("The cluster is already balanced, exiting.");
                return false;
            }
            if (proposedRebalance.topicsHavePlacementConstraint() && (this.bootstrapServers == null || this.bootstrapServers.isEmpty())) {
                System.out.println("ERROR: Topics have placement constraints but `--bootstrap-server` property hasn't been specified. Please specify the property before proceeding with rebalance.");
                return false;
            }
            return true;
        }

        private void startRebalance(Rebalancer rebalancer, ProposedRebalance proposedRebalance) {
            if (this.incremental) {
                this.startIncrementalRebalance(rebalancer, proposedRebalance);
            } else {
                rebalancer.startRebalance(proposedRebalance, this.replicationQuota);
                System.out.println("The rebalance has been started, run `status` to check progress.");
                System.out.println(String.format("%nWarning: You must run the `status` or `finish` command periodically, until the rebalance completes, to ensure the throttle is removed. You can also alter the throttle by re-running the execute command passing a new value.%n", new Object[0]));
            }
        }

        private void startIncrementalRebalance(Rebalancer rebalancer, ProposedRebalance proposedRebalance) {
            try {
                rebalancer.startRebalance(proposedRebalance, this.replicationQuota);
                System.out.println("The rebalance has completed");
            }
            catch (Exception e) {
                this.disenagageThrottleIfNoReassignment(rebalancer);
                throw new ReassignmentFailedException("Incremental reassignment failed. Use either  `cancel` to cancel or `finish` to await pending reassignments and disengage  replication quotas.", e);
            }
        }

        private void disenagageThrottleIfNoReassignment(Rebalancer rebalancer) {
            try {
                ClusterReassignment reassignment = rebalancer.currentReassignment();
                if (reassignment.isEmpty()) {
                    rebalancer.disengageThrottle();
                }
            }
            catch (Exception e) {
                log.error("Failed to remove quotas after reassignment failure", (Throwable)e);
            }
        }
    }

    @Command(name="cancel", description="Cancel an ongoing reassignment. Note this command is only available for brokers with Confluent Platform 5.4 (Apache Kafka 2.4) or higher.")
    public static class Cancel
    extends BaseRebalanceCommand {
        @Override
        protected void doRun() {
            Rebalancer rebalancer = this.getOrCreateRebalancer();
            rebalancer.cancelRebalance();
            rebalancer.disengageThrottle();
            System.out.println("The rebalance has been cancelled and the throttle disengaged");
        }
    }

    @Command(name="status", description="Show the status of the current rebalance operation (if there is one)")
    public static class Status
    extends BaseRebalanceCommand {
        @Override
        protected void doRun() {
            Rebalancer rebalancer = this.getOrCreateRebalancer();
            ClusterReassignment reassignment = rebalancer.currentReassignment();
            if (reassignment.isEmpty()) {
                throw new NoRebalanceInProgressException("No rebalance is currently in progress. If you have called `status` after a rebalance was started successfully, the rebalance has completed. Run the `execute` command to check if the cluster is balanced.");
            }
            System.out.println("Partitions being rebalanced:");
            reassignment.printPartitionsByTopic();
        }
    }

    @Command(name="finish", description="Performs clean-up activities (like disabling replication throttling) as the rebalance completes")
    public static class Finish
    extends BaseRebalanceCommand {
        @Override
        protected void doRun() {
            Rebalancer rebalancer = this.getOrCreateRebalancer();
            ClusterReassignment reassignment = rebalancer.currentReassignment();
            if (!reassignment.isEmpty()) {
                throw new RebalanceInProgressException(reassignment.size() + " partitions are being rebalanced");
            }
            System.out.println("The rebalance has completed and throttling has been disabled");
        }
    }

    static abstract class BaseRebalanceCommand
    implements Runnable,
    Closeable {
        @Option(name={"--bootstrap-server"}, description="The connection string for the cluster's broker(s) in the form host:port. Multiple URLS can be given to allow fail-over.", required=true)
        protected String bootstrapServers;
        @Option(name={"--command-config"}, description="Property file containing configs to be passed to Admin Client. This is used only with the --bootstrap-server option.")
        protected String commandConfig;
        @Option(name={"--config-file"}, description="Configuration file in properties format")
        protected String configFile;
        protected RebalancerConfig rebalancerConfig;
        private Rebalancer rebalancer;
        private RebalancerFactory rebalancerFactory;
        private LicenseValidator licenseValidator;

        BaseRebalanceCommand() {
        }

        protected Rebalancer getOrCreateRebalancer() {
            if (this.rebalancer == null) {
                if (this.rebalancerFactory == null) {
                    throw new IllegalStateException("rebalancerFactory has not been set");
                }
                this.rebalancer = this.buildRebalancer(this.rebalancerFactory);
            }
            return this.rebalancer;
        }

        public void setLicenseValidator(LicenseValidator validator) {
            this.licenseValidator = validator;
        }

        public void setRebalancerFactory(RebalancerFactory rebalancerFactory) {
            this.rebalancerFactory = rebalancerFactory;
        }

        protected Rebalancer buildRebalancer(RebalancerFactory factory) {
            return factory.create(this.commandConfig(), false, this.rebalancerConfig);
        }

        @Override
        public final void run() {
            this.rebalancerConfig = this.rebalancerConfig();
            if (this.licenseValidator == null) {
                this.licenseValidator = new DefaultLicenseValidator();
            }
            try {
                this.licenseValidator.validateLicense(this.rebalancerConfig);
            }
            catch (LicenseValidator.ValidationFailedException e) {
                throw new ValidationException("Could not validate your license", e);
            }
            this.doRun();
        }

        protected abstract void doRun();

        private Properties loadProps(String propsPath) {
            if (propsPath == null) {
                return new Properties();
            }
            try {
                return Utils.loadProps((String)propsPath);
            }
            catch (IOException e) {
                throw new ValidationException("Could not load configuration properties", e);
            }
        }

        protected Properties rebalancerProps() {
            Properties props = this.loadProps(this.configFile);
            if (this.bootstrapServers != null) {
                props.put("bootstrap.servers", this.bootstrapServers);
                props.putIfAbsent("confluent.license.bootstrap.servers", this.bootstrapServers);
            }
            return props;
        }

        protected Properties commandConfig() {
            if (this.bootstrapServers == null) {
                return null;
            }
            Properties props = this.loadProps(this.commandConfig);
            props.put("bootstrap.servers", this.bootstrapServers);
            return props;
        }

        protected RebalancerConfig rebalancerConfig() {
            return new RebalancerConfig(this.rebalancerProps());
        }

        @Override
        public void close() {
            if (this.rebalancer != null) {
                this.rebalancer.close();
            }
        }
    }

    static abstract class BaseReassignCommand
    extends BaseRebalanceCommand {
        @Option(name={"--metrics-bootstrap-server"}, description="A list of host:port pairs to use for establishing the initial connection to the metrics Kafka cluster.  If not set, the value for --bootstrap-server will be used.")
        protected String metricBootstrapServers;
        @Option(name={"--remove-broker-ids"}, description="Partitions will be moved away from the specified brokers (comma-separated). This option can be used to decommission brokers.")
        private String removeBrokerIds;
        @Option(name={"--topics"}, description="A comma-separated list of topics to consider for this rebalance. Note that it may not be possible to achieve globally optimum balance by restricting the topics that can be moved.")
        private String topicsToRebalance;
        @Option(name={"--min-free-volume-space-percentage"}, description="The log.dir volume will have at least the specified percentage of free space during and after the rebalance. For example, if the total volume space is 100 GB and this config is defined as 20, the rebalancer will use up to 80 GB during the rebalance .This is only supported in Confluent 3.2 (for both rebalancer and brokers) and if every broker in the cluster has a single log.dir. This is enabled by default if supported and disabled otherwise.")
        private String minFreeVolumeSpacePercentage;
        @Option(name={"--exclude-internal-topics"}, description="Exclude internal topics like __consumer_offsets while rebalancing. Note that this option is ignored when `--topics` is used to specify the topics to rebalance directly.")
        protected boolean excludeInternalTopics = false;
        @Option(name={"--replica-placement-only"}, description="Attempt to satisfy replica placement constraints without a deeper rebalance of the cluster.")
        private boolean replicaPlacementOnly = false;

        BaseReassignCommand() {
        }

        @Override
        protected Properties rebalancerProps() {
            Properties props = super.rebalancerProps();
            if (this.metricBootstrapServers != null) {
                props.put("confluent.rebalancer.metrics.bootstrap.servers", this.metricBootstrapServers);
            } else if (this.bootstrapServers != null) {
                props.putIfAbsent("confluent.rebalancer.metrics.bootstrap.servers", this.bootstrapServers);
            } else {
                throw new IllegalArgumentException("At least one of --metrics-bootstrap-server and --bootstrap-server must be specified");
            }
            if (this.minFreeVolumeSpacePercentage != null) {
                props.put("confluent.rebalancer.min.free.volume.space.percentage", this.minFreeVolumeSpacePercentage);
            }
            return props;
        }

        protected Set<String> topicsToRebalance() {
            if (this.topicsToRebalance == null) {
                return Collections.emptySet();
            }
            if (this.topicsToRebalance.trim().isEmpty()) {
                throw this.topicsToRebalanceException();
            }
            String[] values = this.topicsToRebalance.split(",");
            if (values.length == 0) {
                throw this.topicsToRebalanceException();
            }
            return new HashSet<String>(Arrays.asList(values));
        }

        protected List<Integer> removeBrokerIds() {
            if (this.removeBrokerIds == null) {
                return Collections.emptyList();
            }
            if (this.removeBrokerIds.trim().isEmpty()) {
                throw this.removeBrokerIdsException();
            }
            String[] values = this.removeBrokerIds.split(",");
            if (values.length == 0) {
                throw this.removeBrokerIdsException();
            }
            ArrayList<Integer> brokerIds = new ArrayList<Integer>();
            for (String value : values) {
                try {
                    brokerIds.add(Integer.parseInt(value.trim()));
                }
                catch (NumberFormatException e) {
                    throw this.removeBrokerIdsException();
                }
            }
            return brokerIds;
        }

        protected CommandContext buildCommandContext() {
            return new CommandContext(this.topicsToRebalance(), this.removeBrokerIds(), this.excludeInternalTopics, this.replicaPlacementOnly);
        }

        private ValidationException topicsToRebalanceException() {
            return new ValidationException("Expected a comma-separated list of topic names for option `--topics`, but received `" + this.topicsToRebalance + "`");
        }

        private ValidationException removeBrokerIdsException() {
            return new ValidationException("Expected a comma-separated list of numeric broker ids for option `--remove-broker-ids`, but received `" + this.removeBrokerIds + "`");
        }
    }
}

