/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing;

import com.google.common.base.Strings;
import io.confluent.kafka.databalancing.AbstractRebalancer;
import io.confluent.kafka.databalancing.CommandContext;
import io.confluent.kafka.databalancing.DefaultRebalanceContext;
import io.confluent.kafka.databalancing.MovesOptimisedRebalancePolicy;
import io.confluent.kafka.databalancing.MutableRebalanceContext;
import io.confluent.kafka.databalancing.ProposedRebalance;
import io.confluent.kafka.databalancing.RebalancePolicy;
import io.confluent.kafka.databalancing.RebalancerAdmin;
import io.confluent.kafka.databalancing.RebalancerConfig;
import io.confluent.kafka.databalancing.Utils;
import io.confluent.kafka.databalancing.metric.Metrics;
import io.confluent.kafka.databalancing.metric.MetricsCollector;
import io.confluent.kafka.databalancing.throttle.Throttle;
import io.confluent.kafka.databalancing.throttle.Throttler;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.BrokerMetadata;
import io.confluent.kafka.databalancing.topology.ClusterAssignment;
import io.confluent.kafka.databalancing.topology.ClusterReassignment;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.server.common.AdminCommandFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRebalancer
extends AbstractRebalancer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRebalancer.class);
    protected final RebalancerAdmin rebalancerAdmin;
    protected final Throttle throttle;
    private final MetricsCollector metricsCollector;
    private final RebalancePolicy rebalancePolicy = new MovesOptimisedRebalancePolicy();

    public DefaultRebalancer(RebalancerConfig config, RebalancerAdmin rebalancerAdmin) {
        this(config, rebalancerAdmin, new MetricsCollector(config), new Throttler(rebalancerAdmin));
    }

    public DefaultRebalancer(RebalancerConfig config, RebalancerAdmin rebalancerAdmin, MetricsCollector metricsCollector, Throttle throttler) {
        super(config);
        this.rebalancerAdmin = rebalancerAdmin;
        this.metricsCollector = metricsCollector;
        this.throttle = throttler;
    }

    private Map<Broker, BrokerMetadata> allBrokers(ClusterAssignment assignment) {
        List<BrokerMetadata> allBrokers = this.rebalancerAdmin.getAllBrokerMetadata();
        Map<Broker, BrokerMetadata> brokers = Utils.brokersMap(allBrokers);
        for (Broker broker : assignment.brokers()) {
            brokers.computeIfAbsent(broker, b -> BrokerMetadata.offline(b.id()));
        }
        return brokers;
    }

    @Override
    public ProposedRebalance proposeRebalance(CommandContext ctx) {
        Optional<Set<String>> filterTopics = ctx.topicsToRebalance.isEmpty() ? Optional.empty() : Optional.of(ctx.topicsToRebalance);
        ClusterAssignment currentAssignment = this.currentAssignment(filterTopics, ctx.excludeInternalTopics);
        Map<String, TopicPlacement> topicPlacement = this.getTopicPlacementMap(filterTopics);
        Map<Broker, BrokerMetadata> brokers = this.allBrokers(currentAssignment);
        List<Broker> brokersToRemove = DefaultRebalancer.brokersToRemove(brokers, currentAssignment, ctx);
        Set<Broker> aliveBrokers = brokers.entrySet().stream().filter(entry -> !((BrokerMetadata)entry.getValue()).isOffline()).map(Map.Entry::getKey).collect(Collectors.toSet());
        Metrics metrics = this.metrics(currentAssignment.topicPartitions(), aliveBrokers);
        RebalancePolicy.Config policyConfig = this.policyConfig(metrics, brokers);
        MutableRebalanceContext context = DefaultRebalanceContext.create(brokers, currentAssignment, currentAssignment.replicationFactors(), topicPlacement, metrics, policyConfig, brokersToRemove);
        ClusterAssignment proposedAssignment = ctx.replicaPlacementOnly ? this.rebalancePolicy.enforcePlacementConstraints(context) : this.rebalancePolicy.rebalancePartitions(context);
        return new ProposedRebalance(brokers, topicPlacement, currentAssignment, proposedAssignment, metrics, brokersToRemove, policyConfig);
    }

    @Override
    public void startRebalance(ProposedRebalance proposedRebalance, long replicationQuota) {
        this.throttle.engage(replicationQuota, proposedRebalance.aliveBrokers(), proposedRebalance.reassignment());
        this.createPartitionAssignment(proposedRebalance);
    }

    @Override
    public void cancelRebalance() {
        ClusterReassignment reassignment = this.currentReassignment();
        if (!reassignment.topicPartitions().isEmpty()) {
            this.rebalancerAdmin.cancelPartitionReassignment(reassignment.topicPartitions());
        }
    }

    private void createPartitionAssignment(ProposedRebalance proposedRebalance) {
        this.rebalancerAdmin.createPartitionReassignment(proposedRebalance.proposedAssignmentChanges().asNewPartitionReassignmentMap());
    }

    @Override
    public boolean maybeUpdateReplicationQuota(long replicationQuota, boolean excludeInternalTopics) {
        ClusterReassignment reassignment = this.currentReassignment();
        if (!reassignment.isEmpty()) {
            Set<Integer> aliveBrokers = this.rebalancerAdmin.getAllBrokersInCluster();
            this.throttle.engage(replicationQuota, aliveBrokers, reassignment);
            System.out.println("The throttle rate was updated to " + replicationQuota + " bytes/sec.");
            System.out.println("A rebalance is currently in progress for:");
            reassignment.printPartitionsByTopic();
            return true;
        }
        return false;
    }

    @Override
    public boolean disengageThrottle() {
        return this.throttle.disengage();
    }

    @Override
    public ClusterReassignment currentReassignment() {
        ClusterReassignment reassignment = this.rebalancerAdmin.currentReassignment();
        if (reassignment.isEmpty()) {
            this.disengageThrottle();
        }
        return reassignment;
    }

    private Metrics metrics(Set<TopicPartition> allPartitions, Set<Broker> allBrokers) {
        try {
            String clusterId = this.rebalancerAdmin.getClusterId();
            return this.metricsCollector.collectMetrics(allPartitions, clusterId, allBrokers);
        }
        catch (TimeoutException e) {
            throw new AdminCommandFailedException("Failed to retrieve metrics data. " + e.getMessage());
        }
    }

    ClusterAssignment currentAssignment(Optional<Set<String>> filterTopics, boolean excludeInternalTopics) {
        ClusterAssignment clusterAssignment = this.rebalancerAdmin.currentAssignment(filterTopics, excludeInternalTopics);
        Set<String> deletedTopics = this.rebalancerAdmin.getAllDeletedTopicsInCluster();
        if (!deletedTopics.isEmpty()) {
            logger.info("Ignoring topics marked for deletion: " + Utils.mkString(deletedTopics, ", "));
        }
        return clusterAssignment.cloneWithoutTopics(deletedTopics);
    }

    public static boolean isInternalTopic(String topic, Collection<String> nonInternalTopics) {
        String nonNullTopic = Strings.nullToEmpty((String)topic);
        return !nonInternalTopics.contains(nonNullTopic) || nonNullTopic.startsWith("_confluent");
    }

    private Map<String, TopicPlacement> getTopicPlacementMap(Optional<Set<String>> filterTopics) {
        Set<String> topics = filterTopics.orElse(this.rebalancerAdmin.getAllTopicsInCluster(true));
        Map<String, Map<String, Optional<String>>> topicConfigs = this.rebalancerAdmin.fetchTopicConfigs(topics);
        HashMap<String, TopicPlacement> placementConfigs = new HashMap<String, TopicPlacement>(topicConfigs.size());
        for (Map.Entry<String, Map<String, Optional<String>>> config : topicConfigs.entrySet()) {
            config.getValue().getOrDefault("confluent.placement.constraints", Optional.empty()).flatMap(TopicPlacement::parse).ifPresent(placement -> placementConfigs.put((String)config.getKey(), (TopicPlacement)placement));
        }
        return placementConfigs;
    }

    @Override
    public void close() {
        try {
            this.rebalancerAdmin.close();
        }
        catch (Throwable t) {
            logger.warn("An exception was thrown while closing rebalancerAdmin", t);
        }
    }
}

