/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing;

import io.confluent.kafka.databalancing.AbstractRebalancer;
import io.confluent.kafka.databalancing.CommandContext;
import io.confluent.kafka.databalancing.DefaultRebalanceContext;
import io.confluent.kafka.databalancing.MovesOptimisedRebalancePolicy;
import io.confluent.kafka.databalancing.MutableRebalanceContext;
import io.confluent.kafka.databalancing.ProposedRebalance;
import io.confluent.kafka.databalancing.RebalancePolicy;
import io.confluent.kafka.databalancing.RebalancerConfig;
import io.confluent.kafka.databalancing.metric.Metrics;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.BrokerMetadata;
import io.confluent.kafka.databalancing.topology.ClusterAssignment;
import io.confluent.kafka.databalancing.topology.ClusterReassignment;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InMemoryRebalancer
extends AbstractRebalancer {
    private final RebalancePolicy rebalancePolicy = new MovesOptimisedRebalancePolicy();
    private final Map<Broker, BrokerMetadata> brokers;
    private final Metrics metrics;
    private ClusterReassignment reassignment;
    private ClusterAssignment currentAssignment;

    public InMemoryRebalancer(RebalancerConfig config, List<BrokerMetadata> allBrokers, ClusterAssignment currentAssignment, Metrics metrics, ClusterReassignment reassignment) {
        super(config);
        this.currentAssignment = currentAssignment;
        this.brokers = allBrokers.stream().collect(Collectors.toMap(md -> new Broker(md.id()), md -> md));
        this.metrics = metrics;
        this.reassignment = reassignment;
    }

    @Override
    public boolean maybeUpdateReplicationQuota(long replicationQuota, boolean excludeInternalTopics) {
        if (!this.reassignment.isEmpty()) {
            System.out.println("The throttle rate was updated to " + replicationQuota + " bytes/sec.");
            return true;
        }
        return false;
    }

    @Override
    public ProposedRebalance proposeRebalance(CommandContext ctx) {
        if (!this.reassignment.isEmpty()) {
            throw InMemoryRebalancer.partitionsBeingReassignedException(this.reassignment.topicPartitions());
        }
        List<Broker> brokersToRemove = InMemoryRebalancer.brokersToRemove(this.brokers, this.currentAssignment, ctx);
        RebalancePolicy.Config policyConfig = this.policyConfig(this.metrics, this.brokers);
        MutableRebalanceContext context = DefaultRebalanceContext.create(this.brokers, this.currentAssignment, this.currentAssignment.replicationFactors(), Collections.emptyMap(), this.metrics, policyConfig, brokersToRemove);
        ClusterAssignment proposedAssignment = this.rebalancePolicy.rebalancePartitions(context);
        return new ProposedRebalance(this.brokers, Collections.emptyMap(), this.currentAssignment, proposedAssignment, this.metrics, brokersToRemove, policyConfig);
    }

    @Override
    public void startRebalance(ProposedRebalance proposedRebalance, long replicationQuota) {
        this.reassignment = proposedRebalance.reassignment();
    }

    @Override
    public void cancelRebalance() {
        this.reassignment = new ClusterReassignment(Collections.emptyMap());
    }

    @Override
    public boolean disengageThrottle() {
        return false;
    }

    @Override
    public ClusterReassignment currentReassignment() {
        return this.reassignment;
    }

    @Override
    public void close() {
    }
}

