/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing;

import io.confluent.kafka.databalancing.RebalancePolicy;
import io.confluent.kafka.databalancing.Utils;
import io.confluent.kafka.databalancing.metric.Metrics;
import io.confluent.kafka.databalancing.report.RebalanceReport;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.BrokerMetadata;
import io.confluent.kafka.databalancing.topology.ClusterAssignment;
import io.confluent.kafka.databalancing.topology.ClusterReassignment;
import io.confluent.kafka.databalancing.topology.PartitionAssignment;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.metadata.TopicPlacement;

public class ProposedRebalance {
    private final Map<String, TopicPlacement> topicPlacement;
    private final ClusterAssignment currentAssignment;
    private final ClusterAssignment proposedAssignment;
    private final Metrics metrics;
    private final Collection<Broker> brokersToRemove;
    private final Map<Broker, BrokerMetadata> brokers;
    private final RebalancePolicy.Config policyConfig;

    ProposedRebalance(Collection<BrokerMetadata> brokers, Map<String, TopicPlacement> topicPlacement, ClusterAssignment currentAssignment, ClusterAssignment proposedAssignment, Metrics metrics, Collection<Broker> brokersToRemove, RebalancePolicy.Config policyConfig) {
        this(Utils.brokersMap(brokers), topicPlacement, currentAssignment, proposedAssignment, metrics, brokersToRemove, policyConfig);
    }

    ProposedRebalance(Map<Broker, BrokerMetadata> brokers, Map<String, TopicPlacement> topicPlacement, ClusterAssignment currentAssignment, ClusterAssignment proposedAssignment, Metrics metrics, Collection<Broker> brokersToRemove, RebalancePolicy.Config policyConfig) {
        this.brokers = brokers;
        this.topicPlacement = topicPlacement;
        this.currentAssignment = currentAssignment;
        this.proposedAssignment = proposedAssignment;
        this.metrics = metrics;
        this.brokersToRemove = brokersToRemove;
        this.policyConfig = policyConfig;
    }

    public ClusterAssignment currentAssignment() {
        return this.currentAssignment;
    }

    ClusterAssignment proposedAssignment() {
        return this.proposedAssignment;
    }

    ClusterReassignment reassignment() {
        return this.currentAssignment.reassignTo(this.proposedAssignment);
    }

    Map<String, TopicPlacement> topicPlacement() {
        return this.topicPlacement;
    }

    long partitionSize(TopicPartition tp) {
        return this.metrics.partitionSize(tp);
    }

    RebalanceReport report() {
        return new RebalanceReport(this.brokers, this.topicPlacement, this.currentAssignment, this.proposedAssignment, this.metrics, this.brokersToRemove, this.policyConfig);
    }

    boolean topicsHavePlacementConstraint() {
        return !this.topicPlacement.isEmpty();
    }

    boolean shouldRebalance() {
        return !this.currentAssignment.equals(this.proposedAssignment);
    }

    ClusterAssignment proposedAssignmentChanges() {
        HashMap<TopicPartition, PartitionAssignment> result = new HashMap<TopicPartition, PartitionAssignment>();
        for (TopicPartition tp : this.proposedAssignment.topicPartitions()) {
            PartitionAssignment proposed;
            PartitionAssignment current = this.currentAssignment.assignment(tp);
            if (current.equals(proposed = this.proposedAssignment.assignment(tp))) continue;
            result.put(tp, proposed);
        }
        return new ClusterAssignment(result);
    }

    Set<Integer> aliveBrokers() {
        return this.brokers.values().stream().filter(broker -> !broker.isOffline()).map(BrokerMetadata::id).collect(Collectors.toSet());
    }
}

