/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing;

import io.confluent.kafka.databalancing.RebalancePolicy;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.ClusterAssignment;
import io.confluent.kafka.databalancing.topology.PartitionAssignment;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.metadata.TopicPlacement;

public interface RebalanceContext {
    public boolean isOffline(Broker var1);

    public Set<Broker> offlineBrokers();

    public List<Broker> brokers(TopicPartition var1, String var2);

    public List<Broker> brokers(TopicPartition var1);

    public List<Broker> syncReplicas(TopicPartition var1);

    public List<Broker> observers(TopicPartition var1);

    public PartitionAssignment assignment(TopicPartition var1);

    public Map<String, String> brokerProperties(Broker var1);

    public Set<String> allRacks();

    public Set<String> allRetainedRacks();

    public Collection<Broker> brokersOnRack(String var1);

    public Collection<Broker> brokersOnRacks(Collection<String> var1);

    public Collection<Broker> allBrokers();

    public ClusterAssignment buildAssignment();

    public Set<String> racks(List<Broker> var1);

    public int replicationFactor(String var1);

    public Collection<TopicPartition> allPartitions();

    public Broker leader(TopicPartition var1);

    public Optional<Broker> firstObserver(TopicPartition var1);

    public Optional<TopicPlacement> topicPlacement(String var1);

    public List<TopicPartition> followers(Broker var1);

    public List<TopicPartition> syncFollowers(Broker var1);

    public int brokerTopicReplicaCount(Broker var1, String var2);

    public int brokerTopicFirstObserverCount(Broker var1, String var2);

    public int brokerTopicLeaderCount(Broker var1, String var2);

    public long brokerSize(Broker var1);

    public long brokerTopicSize(Broker var1, String var2);

    public long brokerTopicLeadersSize(Broker var1, String var2);

    public long partitionSize(TopicPartition var1);

    public List<TopicPartition> replicas(Broker var1);

    public List<TopicPartition> leaders(Broker var1);

    public List<TopicPartition> firstObservers(Broker var1);

    public String brokerRack(Broker var1);

    public Set<Broker> brokersToBeRemoved();

    public Collection<String> topics();

    public Long brokerUsableBytes(Broker var1);

    public Long brokerUsableBytesAfterPartitionRemoval(Broker var1, TopicPartition var2);

    public Long brokerTotalBytes(Broker var1);

    public RebalancePolicy.Config policyConfig();

    public boolean hasBrokerSpaceInfo();
}

