/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.fairness;

import io.confluent.kafka.databalancing.CompareResult;
import io.confluent.kafka.databalancing.RebalanceContext;
import io.confluent.kafka.databalancing.Utils;
import io.confluent.kafka.databalancing.fairness.Fairness;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.TopologyUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;

public abstract class BaseFairness
implements Fairness {
    protected final RebalanceContext context;
    protected final String rack;
    protected final String topic;
    private final Map<String, Long> rackValueMap;
    private final Map<Broker, Long> brokerValueMap;
    private final double brokerFairValue;
    private final double rackFairValue;
    private List<String> aboveParRacks;
    private List<String> belowParRacks;
    private List<Broker> aboveParBrokers;
    private List<Broker> belowParBrokers;

    protected BaseFairness(RebalanceContext context, String rack, String topic) {
        this.context = context;
        this.topic = topic;
        this.rack = rack;
        this.brokerValueMap = this.createBrokerValueMap(context, rack, topic);
        this.rackValueMap = this.createRackValueMap(context, rack, topic);
        long replicaTotal = 0L;
        for (long value : this.brokerValueMap.values()) {
            replicaTotal += value;
        }
        this.brokerFairValue = (double)replicaTotal / (double)this.brokerValueMap.size();
        this.rackFairValue = (double)replicaTotal / (double)(rack == null ? context.allRetainedRacks().size() : 1);
    }

    protected abstract Map<Broker, Long> createBrokerValueMap(RebalanceContext var1, String var2, String var3);

    protected abstract Map<String, Long> createRackValueMap(RebalanceContext var1, String var2, String var3);

    protected long brokerValue(Broker broker) {
        return this.brokerValueMap.get(broker);
    }

    protected long rackValue(Broker broker) {
        return this.rackValueMap.get(this.context.brokerRack(broker));
    }

    public double rackFairValue() {
        return this.rackFairValue;
    }

    public double brokerFairValue() {
        return this.brokerFairValue;
    }

    @Override
    public List<String> aboveParRacks() {
        if (this.aboveParRacks == null) {
            this.createAboveAndBelowParRacks();
        }
        return this.aboveParRacks;
    }

    @Override
    public List<String> belowParRacks() {
        if (this.belowParRacks == null) {
            this.createAboveAndBelowParRacks();
        }
        return this.belowParRacks;
    }

    private void createAboveAndBelowParRacks() {
        ArrayList<String> aboveParRacks = new ArrayList<String>();
        ArrayList<String> belowParRacks = new ArrayList<String>();
        Comparator<String> comparator = this.topic == null ? TopologyUtils.rackComparator(this.rackValueMap) : TopologyUtils.rackTopicComparator(this.rackValueMap, this.createRackValueMap(this.context, this.rack, null));
        List<String> sortedRacks = Utils.sorted(this.rackValueMap.keySet(), comparator);
        for (String r : sortedRacks) {
            long value = this.rackValueMap.get(r);
            if ((double)value > Math.floor(this.rackFairValue)) {
                aboveParRacks.add(r);
            }
            if (!((double)value < Math.ceil(this.rackFairValue))) continue;
            belowParRacks.add(r);
        }
        Collections.reverse(aboveParRacks);
        this.aboveParRacks = Collections.unmodifiableList(aboveParRacks);
        this.belowParRacks = Collections.unmodifiableList(belowParRacks);
    }

    @Override
    public List<Broker> aboveParBrokers() {
        if (this.aboveParBrokers == null) {
            this.createAboveAndBelowParBrokers();
        }
        return this.aboveParBrokers;
    }

    @Override
    public List<Broker> belowParBrokers() {
        if (this.belowParBrokers == null) {
            this.createAboveAndBelowParBrokers();
        }
        return this.belowParBrokers;
    }

    private void createAboveAndBelowParBrokers() {
        ArrayList<Broker> aboveParBrokers = new ArrayList<Broker>();
        ArrayList<Broker> belowParBrokers = new ArrayList<Broker>();
        Comparator<Broker> comparator = this.topic == null ? TopologyUtils.brokerComparator(this.brokerValueMap) : TopologyUtils.brokerTopicComparator(this.brokerValueMap, this.createBrokerValueMap(this.context, this.rack, null));
        List<Broker> sortedBrokers = Utils.sorted(this.brokerValueMap.keySet(), comparator);
        for (Broker broker : sortedBrokers) {
            long value = this.brokerValueMap.get(broker);
            if ((double)value > Math.floor(this.brokerFairValue)) {
                aboveParBrokers.add(broker);
            }
            if (!((double)value < Math.ceil(this.brokerFairValue))) continue;
            belowParBrokers.add(broker);
        }
        Collections.reverse(aboveParBrokers);
        this.aboveParBrokers = Collections.unmodifiableList(aboveParBrokers);
        this.belowParBrokers = Collections.unmodifiableList(belowParBrokers);
    }

    @Override
    public CompareResult compareBrokerFairness(TopicPartition tp, Broker b1, Broker b2) {
        return this.compareBrokerFairness(b1, tp, b2, null);
    }

    @Override
    public CompareResult compareBrokerFairness(Broker b1, TopicPartition tp1, Broker b2, TopicPartition tp2) {
        long tp2Size;
        long tp1Size = this.partitionValue(tp1);
        long l = tp2Size = tp2 == null ? 0L : this.partitionValue(tp2);
        if (tp1Size == 0L && tp2Size == 0L) {
            return CompareResult.EQUAL;
        }
        long b1Size = this.brokerValue(b1);
        long b2Size = this.brokerValue(b2);
        double mean = this.brokerFairValue();
        return TopologyUtils.compareSizeFairness(b1Size, tp1Size, b2Size, tp2Size, mean);
    }

    protected abstract long partitionValue(TopicPartition var1);

    @Override
    public CompareResult compareRackFairness(TopicPartition tp, Broker b1, Broker b2) {
        return this.compareRackFairness(b1, tp, b2, null);
    }

    @Override
    public CompareResult compareRackFairness(Broker b1, TopicPartition tp1, Broker b2, TopicPartition tp2) {
        long tp2Size;
        long tp1Size = this.partitionValue(tp1);
        long l = tp2Size = tp2 == null ? 0L : this.partitionValue(tp2);
        if (tp1Size == 0L && tp2Size == 0L) {
            return CompareResult.EQUAL;
        }
        long r1Size = this.rackValue(b1);
        long r2Size = this.rackValue(b2);
        double mean = this.rackFairValue();
        return TopologyUtils.compareSizeFairness(r1Size, tp1Size, r2Size, tp2Size, mean);
    }
}

