/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.fairness;

import io.confluent.kafka.databalancing.RebalanceContext;
import io.confluent.kafka.databalancing.fairness.FirstObserverFairness;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.TopologyUtils;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;

public class FirstObserverSizeFairness
extends FirstObserverFairness {
    public FirstObserverSizeFairness(RebalanceContext context, String rack, String topic) {
        super(context, rack, topic);
    }

    @Override
    protected Map<Broker, Long> createBrokerValueMap(RebalanceContext context, String rack, String topic) {
        List<Broker> brokers = TopologyUtils.availableBrokersOnRack(context, rack);
        return TopologyUtils.brokerSizes(context, brokers, topic);
    }

    @Override
    protected Map<String, Long> createRackValueMap(RebalanceContext context, String rack, String topic) {
        return TopologyUtils.rackSizes(context, rack, topic);
    }

    @Override
    protected long partitionValue(TopicPartition tp) {
        if (this.topic == null || this.topic.equals(tp.topic())) {
            return this.context.partitionSize(tp);
        }
        return 0L;
    }
}

