/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.metric;

import io.confluent.kafka.databalancing.metric.MetricReader;
import io.confluent.metrics.record.ConfluentMetric;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.TopicPartition;

public class LogSizeMetricReader
implements MetricReader<Long> {
    private static final String METRIC_GROUP = "kafka.log";
    private static final String METRIC_NAME = "Size";
    private static final String METRIC_TYPE = "Log";
    private static final Pattern MBEAN_NAME_PATTERN = Pattern.compile("^.*,topic=(.*?),partition=(\\d+)$");

    @Override
    public Map<TopicPartition, Long> metricValues(ConfluentMetric.MetricsMessage message) {
        HashMap<TopicPartition, Long> metricValues = new HashMap<TopicPartition, Long>();
        for (ConfluentMetric.YammerGauge gauge : message.getYammerGaugeList()) {
            String beanName;
            Matcher matcher;
            ConfluentMetric.YammerMetricName metricName = gauge.getMetricName();
            if (!metricName.getGroup().equals(METRIC_GROUP) || !metricName.getName().equals(METRIC_NAME) || !metricName.getType().equals(METRIC_TYPE) || !(matcher = MBEAN_NAME_PATTERN.matcher(beanName = metricName.getMBeanName())).find()) continue;
            try {
                int partition = Integer.parseInt(matcher.group(2));
                String topic = matcher.group(1);
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                String value = gauge.getValue();
                if (value == null || value.isEmpty()) continue;
                metricValues.put(topicPartition, switch (gauge.getNumericValueCase()) {
                    case ConfluentMetric.YammerGauge.NumericValueCase.LONGVALUE -> gauge.getLongValue();
                    default -> Long.parseLong(value);
                });
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to read log size metric \"" + beanName + "\" " + gauge.toString() + ": " + t.getMessage(), t);
            }
        }
        return metricValues;
    }
}

