/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.metric;

import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.metrics.record.ConfluentMetric;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;

public class Metrics {
    private final Map<TopicPartition, Long> partitionToSize;
    private final Map<Broker, List<ConfluentMetric.VolumeMetrics>> brokerToVolumeMetrics;

    public Metrics(Map<TopicPartition, Long> partitionToSize, Map<Broker, List<ConfluentMetric.VolumeMetrics>> brokerToVolumeMetrics) {
        this.partitionToSize = Collections.unmodifiableMap(partitionToSize);
        this.brokerToVolumeMetrics = Collections.unmodifiableMap(brokerToVolumeMetrics);
    }

    public Map<TopicPartition, Long> partitionToSize() {
        return this.partitionToSize;
    }

    public Map<Broker, List<ConfluentMetric.VolumeMetrics>> brokerToVolumeMetrics() {
        return this.brokerToVolumeMetrics;
    }

    public long partitionSize(TopicPartition partition) {
        Long result = this.partitionToSize.get(partition);
        return result == null ? 0L : result;
    }

    public String toString() {
        return "Metrics(partitionToSize=" + String.valueOf(this.partitionToSize) + ", brokerToVolumeMetrics=" + String.valueOf(this.brokerToVolumeMetrics) + ")";
    }
}

