/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.topology;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class BrokerMetadata {
    private final int id;
    private final Optional<String> rack;
    private final boolean isOffline;

    public static BrokerMetadata online(int id, Optional<String> rack) {
        return new BrokerMetadata(id, rack, false);
    }

    public static BrokerMetadata offline(int id) {
        return new BrokerMetadata(id, Optional.empty(), true);
    }

    private BrokerMetadata(int id, Optional<String> rack, boolean isOffline) {
        this.id = id;
        this.rack = Objects.requireNonNull(rack);
        this.isOffline = isOffline;
    }

    public int id() {
        return this.id;
    }

    public Optional<String> rack() {
        return this.rack;
    }

    public boolean isOffline() {
        return this.isOffline;
    }

    public Map<String, String> properties() {
        if (this.rack.isPresent()) {
            return Collections.singletonMap("rack", this.rack.get());
        }
        return Collections.emptyMap();
    }

    public boolean matchesRack(String rack) {
        return rack.equals(this.rack.orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerMetadata that = (BrokerMetadata)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.isOffline != that.isOffline) {
            return false;
        }
        return this.rack.equals(that.rack);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.rack.hashCode();
        result = 31 * result + (this.isOffline ? 1 : 0);
        return result;
    }

    public String toString() {
        return "BrokerMetadata{id=" + this.id + ", rack=" + String.valueOf(this.rack) + ", isOffline=" + this.isOffline + "}";
    }
}

