/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.topology;

import io.confluent.kafka.databalancing.Utils;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.PartitionReassignment;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;

public class ClusterReassignment {
    private final Map<String, Map<TopicPartition, PartitionReassignment>> reassignments;
    private final Set<Broker> brokers;

    public ClusterReassignment(Map<TopicPartition, PartitionReassignment> reassignments) {
        this.reassignments = ClusterReassignment.groupByTopic(reassignments);
        this.brokers = ClusterReassignment.collectBrokers(reassignments);
    }

    public Set<Broker> brokers() {
        return Collections.unmodifiableSet(this.brokers);
    }

    public Set<String> topics() {
        return Collections.unmodifiableSet(this.reassignments.keySet());
    }

    public Map<TopicPartition, SortedSet<Integer>> moveSources(String topic) {
        return this.mapTopicPartitions(topic, PartitionReassignment::moveSources);
    }

    public Map<TopicPartition, SortedSet<Integer>> moveDestinations(String topic) {
        return this.mapTopicPartitions(topic, PartitionReassignment::moveDestinations);
    }

    public boolean isEmpty() {
        return this.reassignments.isEmpty();
    }

    public Set<TopicPartition> topicPartitions() {
        HashSet<TopicPartition> res = new HashSet<TopicPartition>();
        this.reassignments.values().forEach(map -> res.addAll(map.keySet()));
        return res;
    }

    public int size() {
        int size = 0;
        for (Map<TopicPartition, PartitionReassignment> topicReassignment : this.reassignments.values()) {
            size += topicReassignment.size();
        }
        return size;
    }

    public void printPartitionsByTopic() {
        for (String topic : Utils.sorted(this.reassignments.keySet())) {
            List partitions = Utils.sorted(this.reassignments.get(topic).keySet().stream().map(TopicPartition::partition).collect(Collectors.toList()));
            String line = "Topic " + topic + ": " + Utils.mkString(partitions, ",");
            System.out.println("\t" + line);
        }
    }

    private <T> Map<TopicPartition, T> mapTopicPartitions(String topic, Function<PartitionReassignment, T> func) {
        Map<TopicPartition, PartitionReassignment> reassigningPartitions = this.reassignments.get(topic);
        if (reassigningPartitions == null) {
            return Collections.emptyMap();
        }
        return reassigningPartitions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> func.apply((PartitionReassignment)entry.getValue())));
    }

    private static Map<String, Map<TopicPartition, PartitionReassignment>> groupByTopic(Map<TopicPartition, PartitionReassignment> reassignments) {
        HashMap<String, Map<TopicPartition, PartitionReassignment>> res = new HashMap<String, Map<TopicPartition, PartitionReassignment>>();
        for (Map.Entry<TopicPartition, PartitionReassignment> reassignment : reassignments.entrySet()) {
            TopicPartition tp = reassignment.getKey();
            Map partitionMap = res.computeIfAbsent(tp.topic(), topic -> new HashMap());
            partitionMap.put(tp, reassignment.getValue());
        }
        return res;
    }

    private static Set<Broker> collectBrokers(Map<TopicPartition, PartitionReassignment> reassignments) {
        HashSet<Integer> res = new HashSet<Integer>();
        for (PartitionReassignment reassignment : reassignments.values()) {
            res.addAll(reassignment.originalReplicas);
            res.addAll(reassignment.targetReplicas);
        }
        return res.stream().map(Broker::new).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterReassignment that = (ClusterReassignment)o;
        if (this.reassignments != null ? !this.reassignments.equals(that.reassignments) : that.reassignments != null) {
            return false;
        }
        return this.brokers != null ? this.brokers.equals(that.brokers) : that.brokers == null;
    }

    public int hashCode() {
        int result = this.reassignments != null ? this.reassignments.hashCode() : 0;
        result = 31 * result + (this.brokers != null ? this.brokers.hashCode() : 0);
        return result;
    }
}

