/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.topology;

import io.confluent.kafka.databalancing.topology.Broker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class PartitionAssignment {
    public final List<Broker> replicas;
    public final List<Broker> observers;

    private PartitionAssignment(List<Broker> replicas, List<Broker> observers) {
        this.replicas = replicas;
        this.observers = observers;
    }

    public static PartitionAssignment create(List<Integer> replicaIds, List<Integer> observerIds) {
        List<Broker> replicas = PartitionAssignment.asBrokerList(replicaIds);
        List<Broker> observers = PartitionAssignment.asBrokerList(observerIds);
        return new PartitionAssignment(replicas, observers);
    }

    public static PartitionAssignment create(List<Integer> replicaIds) {
        return PartitionAssignment.create(replicaIds, Collections.emptyList());
    }

    private static List<Broker> asBrokerList(List<Integer> brokerIds) {
        return Objects.requireNonNull(brokerIds).stream().map(Broker::new).collect(Collectors.toList());
    }

    public Optional<Broker> preferredLeader() {
        if (this.replicas.size() > this.observers.size()) {
            return Optional.of(this.replicas.get(0));
        }
        return Optional.empty();
    }

    public Optional<Broker> firstObserver() {
        return this.observers.stream().findFirst();
    }

    public boolean isEmpty() {
        return this.replicas.isEmpty();
    }

    public void addSyncReplica(Broker replica) {
        if (this.contains(replica)) {
            throw new IllegalArgumentException("Cannot add sync replica " + String.valueOf(replica) + " to " + String.valueOf(this) + " since it is already a replica");
        }
        this.replicas.add(this.replicas.size() - this.observers.size(), replica);
    }

    public List<Integer> replicaIds() {
        return this.replicas.stream().map(Broker::id).collect(Collectors.toList());
    }

    public List<Integer> observerIds() {
        return this.observers.stream().map(Broker::id).collect(Collectors.toList());
    }

    public void addObserver(Broker observer) {
        if (this.contains(observer)) {
            throw new IllegalArgumentException("Cannot add observer " + String.valueOf(observer) + " to " + String.valueOf(this) + " since it is already a replica");
        }
        this.replicas.add(observer);
        this.observers.add(observer);
    }

    public boolean removeReplica(Broker replica) {
        boolean removed = this.replicas.remove(replica);
        this.observers.remove(replica);
        return removed;
    }

    public void replace(Broker oldReplica, Broker newReplica) {
        if (!this.contains(oldReplica)) {
            throw new IllegalArgumentException("Cannot replace " + String.valueOf(oldReplica) + " in assignment " + String.valueOf(this) + " since it is not present");
        }
        if (this.contains(newReplica)) {
            throw new IllegalArgumentException("Cannot replace " + String.valueOf(oldReplica) + " in assignment " + String.valueOf(this) + " with new broker " + String.valueOf(newReplica) + " since it is already present");
        }
        int replicaIndex = this.replicas.indexOf(oldReplica);
        this.replicas.set(replicaIndex, newReplica);
        int observerIndex = this.observers.indexOf(oldReplica);
        if (observerIndex >= 0) {
            this.observers.set(observerIndex, newReplica);
        }
    }

    public Broker makeLeader(Broker replica) {
        if (!this.contains(replica)) {
            throw new IllegalArgumentException("Cannot make " + String.valueOf(replica) + " the leader of " + String.valueOf(this) + " since it is not a replica");
        }
        if (this.observers.contains(replica)) {
            throw new IllegalArgumentException("Cannot make " + String.valueOf(replica) + " the leader of " + String.valueOf(this) + " since it is an observer");
        }
        Broker currentLeader = this.preferredLeader().get();
        if (currentLeader.equals(replica)) {
            throw new IllegalArgumentException("Cannot make " + String.valueOf(replica) + " the leader of " + String.valueOf(this) + " since it is already leader");
        }
        this.replicas.remove(replica);
        this.replicas.add(0, replica);
        return currentLeader;
    }

    public Broker makeFirstObserver(Broker observer) {
        if (this.replicas.contains(observer) && !this.observers.contains(observer)) {
            throw new IllegalArgumentException("Cannot make " + String.valueOf(observer) + " the first observer of " + String.valueOf(this) + " since it is part of the ISR set");
        }
        Broker currentFirstObserver = this.firstObserver().orElse(null);
        if (observer.equals(currentFirstObserver)) {
            throw new IllegalArgumentException("Cannot make " + String.valueOf(observer) + " the first observer of " + String.valueOf(this) + " since it is already the first observer");
        }
        int currentFirstObserverIndex = this.replicas.indexOf(currentFirstObserver);
        this.replicas.remove(currentFirstObserverIndex);
        this.replicas.add(currentFirstObserverIndex, observer);
        this.observers.set(0, observer);
        return currentFirstObserver;
    }

    public Broker swapObservers(Broker observer) {
        if (!this.observers.contains(observer)) {
            throw new IllegalArgumentException("Cannot swap observers as " + String.valueOf(observer) + " is not part of this observer set. The partition assignment is " + String.valueOf(this));
        }
        if (this.replicas.contains(observer) && !this.observers.contains(observer)) {
            throw new IllegalArgumentException("Cannot make " + String.valueOf(observer) + " the first observer of " + String.valueOf(this) + " since it is part of the ISR set");
        }
        Broker currentFirstObserver = this.firstObserver().orElse(null);
        if (observer.equals(currentFirstObserver)) {
            throw new IllegalArgumentException("Cannot make " + String.valueOf(observer) + " the first observer of " + String.valueOf(this) + " since it is already the first observer");
        }
        int currentFirstObserverIndexInReplicaList = this.replicas.indexOf(currentFirstObserver);
        int newFirstObserverIndexInReplicaList = this.replicas.indexOf(observer);
        int newFirstObserverIndexInObserverList = this.observers.indexOf(observer);
        Collections.swap(this.replicas, currentFirstObserverIndexInReplicaList, newFirstObserverIndexInReplicaList);
        Collections.swap(this.observers, 0, newFirstObserverIndexInObserverList);
        return currentFirstObserver;
    }

    public boolean contains(Broker replica) {
        return this.replicas.contains(replica);
    }

    public PartitionAssignment dup() {
        ArrayList<Broker> replicas = new ArrayList<Broker>(this.replicas);
        ArrayList<Broker> observers = new ArrayList<Broker>(this.observers);
        return new PartitionAssignment(replicas, observers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionAssignment that = (PartitionAssignment)o;
        if (!this.replicas.equals(that.replicas)) {
            return false;
        }
        return this.observers.equals(that.observers);
    }

    public int hashCode() {
        int result = this.replicas.hashCode();
        result = 31 * result + this.observers.hashCode();
        return result;
    }

    public String toString() {
        return "(replicas=" + String.valueOf(this.replicaIds()) + (String)(this.observers.isEmpty() ? "" : ", observers=" + String.valueOf(this.observerIds())) + ")";
    }

    public List<Broker> syncReplicas() {
        return this.replicas.subList(0, this.replicas.size() - this.observers.size());
    }

    public List<Integer> syncReplicaIds() {
        return this.syncReplicas().stream().map(Broker::id).collect(Collectors.toList());
    }

    public List<Broker> observers() {
        return this.observers;
    }
}

