/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.topology;

import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class PartitionReassignment {
    public final List<Integer> originalReplicas;
    public final List<Integer> targetReplicas;

    public PartitionReassignment(List<Integer> originalReplicas, List<Integer> targetReplicas) {
        this.originalReplicas = originalReplicas;
        this.targetReplicas = targetReplicas;
    }

    SortedSet<Integer> moveDestinations() {
        TreeSet<Integer> proposedReplicas = new TreeSet<Integer>(this.targetReplicas);
        proposedReplicas.removeAll(this.originalReplicas);
        return proposedReplicas;
    }

    SortedSet<Integer> moveSources() {
        TreeSet<Integer> sources = new TreeSet<Integer>();
        if (this.hasDataMove()) {
            sources.addAll(this.originalReplicas);
        }
        return sources;
    }

    private boolean hasDataMove() {
        return !new HashSet<Integer>(this.originalReplicas).equals(new HashSet<Integer>(this.targetReplicas));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionReassignment that = (PartitionReassignment)o;
        if (this.originalReplicas != null ? !this.originalReplicas.equals(that.originalReplicas) : that.originalReplicas != null) {
            return false;
        }
        return this.targetReplicas != null ? this.targetReplicas.equals(that.targetReplicas) : that.targetReplicas == null;
    }

    public int hashCode() {
        int result = this.originalReplicas != null ? this.originalReplicas.hashCode() : 0;
        result = 31 * result + (this.targetReplicas != null ? this.targetReplicas.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PartitionReassignment{originalReplicas=" + String.valueOf(this.originalReplicas) + ", targetReplicas=" + String.valueOf(this.targetReplicas) + "}";
    }
}

