/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwe.kdf;

import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import org.jose4j.jwe.kdf.ConcatenationKeyDerivationFunctionWithSha256;
import org.jose4j.lang.ByteUtil;
import org.jose4j.lang.HashUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcatKeyDerivationFunction
implements ConcatenationKeyDerivationFunctionWithSha256 {
    private static final Logger log = LoggerFactory.getLogger(ConcatKeyDerivationFunction.class);
    private int digestLength;
    private MessageDigest messageDigest;

    public ConcatKeyDerivationFunction(String hashAlgoritm) {
        this.messageDigest = HashUtil.getMessageDigest(hashAlgoritm);
        this.init();
    }

    public ConcatKeyDerivationFunction(String hashAlgoritm, String provider) {
        this.messageDigest = HashUtil.getMessageDigest(hashAlgoritm, provider);
        this.init();
    }

    private void init() {
        this.digestLength = ByteUtil.bitLength(this.messageDigest.getDigestLength());
        if (this.traceLog()) {
            log.trace("Hash Algorithm: {} with hashlen: {} bits", (Object)this.messageDigest.getAlgorithm(), (Object)this.digestLength);
        }
    }

    public byte[] kdf(byte[] sharedSecret, int keydatalen, byte[] algorithmId, byte[] partyUInfo, byte[] partyVInfo, byte[] suppPubInfo, byte[] suppPrivInfo) {
        if (this.traceLog()) {
            StringBuilder msg = new StringBuilder();
            msg.append("KDF:").append("\n");
            msg.append("  z: ").append(ByteUtil.toDebugString(sharedSecret)).append("\n");
            msg.append("  keydatalen: ").append(keydatalen);
            msg.append("  algorithmId: ").append(ByteUtil.toDebugString(algorithmId)).append("\n");
            msg.append("  partyUInfo: ").append(ByteUtil.toDebugString(partyUInfo)).append("\n");
            msg.append("  partyVInfo: ").append(ByteUtil.toDebugString(partyVInfo)).append("\n");
            msg.append("  suppPubInfo: ").append(ByteUtil.toDebugString(suppPubInfo)).append("\n");
            msg.append("  suppPrivInfo: ").append(ByteUtil.toDebugString(suppPrivInfo));
            log.trace(msg.toString());
        }
        byte[] otherInfo = ByteUtil.concat(algorithmId, partyUInfo, partyVInfo, suppPubInfo, suppPrivInfo);
        return this.kdf(sharedSecret, keydatalen, otherInfo);
    }

    @Override
    public byte[] kdf(byte[] sharedSecret, int keydatalen, byte[] otherInfo) {
        long reps = this.getReps(keydatalen);
        if (this.traceLog()) {
            log.trace("reps: {}", (Object)String.valueOf(reps));
            log.trace("otherInfo: {}", (Object)ByteUtil.toDebugString(otherInfo));
        }
        ByteArrayOutputStream derivedByteOutputStream = new ByteArrayOutputStream();
        int i = 1;
        while ((long)i <= reps) {
            byte[] counterBytes = ByteUtil.getBytes(i);
            if (this.traceLog()) {
                log.trace("rep {} hashing ", (Object)i);
                log.trace(" counter: {}", (Object)ByteUtil.toDebugString(counterBytes));
                log.trace(" z: {}", (Object)ByteUtil.toDebugString(sharedSecret));
                log.trace(" otherInfo: {}", (Object)ByteUtil.toDebugString(otherInfo));
            }
            this.messageDigest.update(counterBytes);
            this.messageDigest.update(sharedSecret);
            this.messageDigest.update(otherInfo);
            byte[] digest = this.messageDigest.digest();
            if (this.traceLog()) {
                log.trace(" k({}): {}", (Object)i, (Object)ByteUtil.toDebugString(digest));
            }
            derivedByteOutputStream.write(digest, 0, digest.length);
            ++i;
        }
        int keyDateLenInBytes = ByteUtil.byteLength(keydatalen);
        byte[] derivedKeyMaterial = derivedByteOutputStream.toByteArray();
        if (this.traceLog()) {
            log.trace("derived key material: {}", (Object)ByteUtil.toDebugString(derivedKeyMaterial));
        }
        if (derivedKeyMaterial.length != keyDateLenInBytes) {
            byte[] newKeyMaterial = ByteUtil.subArray(derivedKeyMaterial, 0, keyDateLenInBytes);
            if (this.traceLog()) {
                log.trace("first {} bits of derived key material: {}", (Object)keydatalen, (Object)ByteUtil.toDebugString(newKeyMaterial));
            }
            derivedKeyMaterial = newKeyMaterial;
        }
        if (this.traceLog()) {
            log.trace("final derived key material: {}", (Object)ByteUtil.toDebugString(derivedKeyMaterial));
        }
        return derivedKeyMaterial;
    }

    long getReps(int keydatalen) {
        double repsD = (float)keydatalen / (float)this.digestLength;
        repsD = Math.ceil(repsD);
        return (int)repsD;
    }

    private boolean traceLog() {
        return false;
    }
}

