/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.metrics.AbstractConnectionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.ConnectionSensors;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.server.metrics.AbstractSensorCreator;

public class IpConnectionSensorBuilder
extends AbstractConnectionSensorBuilder {
    static final String AUTH_RATE = "successful-authentication-by-ip";
    static final String AUTH_CONNECTION_COUNT = "active-authenticated-connection-by-ip";
    private static final Map<String, AbstractSensorCreator> CONNECTION_SENSOR_CREATORS = new HashMap<String, AbstractSensorCreator>();

    public IpConnectionSensorBuilder(Metrics metrics, MultiTenantPrincipal principal, InetAddress clientAddress) {
        super(metrics, new TenantMetrics.TenantIpMetricsContext(principal, clientAddress));
    }

    public ConnectionSensors build() {
        Map sensors = this.getOrCreateSuffixedSensors();
        return new ConnectionSensors((Sensor)sensors.get(AUTH_RATE), (Sensor)sensors.get(AUTH_CONNECTION_COUNT));
    }

    protected Map<String, ? extends AbstractSensorCreator> sensorCreators() {
        return CONNECTION_SENSOR_CREATORS;
    }

    static {
        CONNECTION_SENSOR_CREATORS.put(AUTH_RATE, new AbstractConnectionSensorBuilder.ConnectionMeterSensorCreator(AUTH_RATE, "successful-authentications-by-ip"));
        CONNECTION_SENSOR_CREATORS.put(AUTH_CONNECTION_COUNT, new AbstractConnectionSensorBuilder.ConnectionCountSensorCreator(AUTH_CONNECTION_COUNT, "active-authenticated-connections-by-ip"));
    }
}

