/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
@Confluent
public class DescribeMirrorsResult {
    private final Map<String, KafkaFuture<MirrorTopicDescription>> result;

    public DescribeMirrorsResult(Map<String, KafkaFuture<MirrorTopicDescription>> result) {
        this.result = result;
    }

    public Map<String, KafkaFuture<MirrorTopicDescription>> result() {
        return this.result;
    }

    public KafkaFuture<Map<String, MirrorTopicDescription>> all() {
        return KafkaFuture.allOf(this.result.values().toArray(new KafkaFuture[0])).thenApply(v -> {
            try {
                HashMap<String, MirrorTopicDescription> descriptions = new HashMap<String, MirrorTopicDescription>(this.result.size());
                for (Map.Entry<String, KafkaFuture<MirrorTopicDescription>> entry : this.result.entrySet()) {
                    MirrorTopicDescription desc = entry.getValue().get();
                    if (desc == null) continue;
                    descriptions.put(entry.getKey(), desc);
                }
                return descriptions;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

