/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.common.Node;

public class PartitionInfo {
    private final String topic;
    private final int partition;
    private final Node leader;
    private final Node[] replicas;
    private final Node[] observers;
    private final Node[] inSyncReplicas;
    private final Node[] offlineReplicas;

    public PartitionInfo(String topic, int partition, Node leader, Node[] replicas, Node[] inSyncReplicas) {
        this(topic, partition, leader, replicas, inSyncReplicas, new Node[0]);
    }

    public PartitionInfo(String topic, int partition, Node leader, Node[] replicas, Node[] inSyncReplicas, Node[] offlineReplicas) {
        this(topic, partition, leader, replicas, new Node[0], inSyncReplicas, offlineReplicas);
    }

    private PartitionInfo(String topic, int partition, Node leader, Node[] replicas, Node[] observers, Node[] inSyncReplicas, Node[] offlineReplicas) {
        this.topic = topic;
        this.partition = partition;
        this.leader = leader;
        this.replicas = replicas;
        this.observers = observers;
        this.inSyncReplicas = inSyncReplicas;
        this.offlineReplicas = offlineReplicas;
    }

    @Confluent
    public static PartitionInfo of(String topic, int partition, Node leader, Node[] replicas, Node[] observers, Node[] inSyncReplicas, Node[] offlineReplicas) {
        return new PartitionInfo(topic, partition, leader, replicas, observers, inSyncReplicas, offlineReplicas);
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public Node leader() {
        return this.leader;
    }

    public Node[] replicas() {
        return this.replicas;
    }

    public Node[] observers() {
        return this.observers;
    }

    public Node[] inSyncReplicas() {
        return this.inSyncReplicas;
    }

    public Node[] offlineReplicas() {
        return this.offlineReplicas;
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.partition, this.leader, Arrays.hashCode(this.replicas), Arrays.hashCode(this.observers), Arrays.hashCode(this.inSyncReplicas), Arrays.hashCode(this.offlineReplicas));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartitionInfo other = (PartitionInfo)obj;
        return Objects.equals(this.topic, other.topic) && this.partition == other.partition && Objects.equals(this.leader, other.leader) && Objects.deepEquals(this.replicas, other.replicas) && Objects.deepEquals(this.observers, other.observers) && Objects.deepEquals(this.inSyncReplicas, other.inSyncReplicas) && Objects.deepEquals(this.offlineReplicas, other.offlineReplicas);
    }

    public String toString() {
        return String.format("Partition(topic = %s, partition = %d, leader = %s, replicas = %s, observers = %s, isr = %s, offlineReplicas = %s)", this.topic, this.partition, this.leader == null ? "none" : this.leader.idString(), this.formatNodeIds(this.replicas), this.formatNodeIds(this.observers), this.formatNodeIds(this.inSyncReplicas), this.formatNodeIds(this.offlineReplicas));
    }

    private String formatNodeIds(Node[] nodes) {
        StringBuilder b = new StringBuilder("[");
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                b.append(nodes[i].idString());
                if (i >= nodes.length - 1) continue;
                b.append(',');
            }
        }
        b.append("]");
        return b.toString();
    }
}

