/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql.types;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.utils.DataException;
import io.confluent.ksql.schema.utils.FormatOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Immutable
public final class SqlStruct
extends SqlType {
    private static final String PREFIX = "STRUCT<";
    private static final String POSTFIX = ">";
    private static final String EMPTY_STRUCT = "STRUCT< >";
    private final ImmutableList<Field> fields;
    private final ImmutableMap<String, Field> byName;

    public static Builder builder() {
        return new Builder();
    }

    private SqlStruct(List<Field> fields, Map<String, Field> byName) {
        super(SqlBaseType.STRUCT);
        this.fields = ImmutableList.copyOf((Collection)Objects.requireNonNull(fields, "fields"));
        this.byName = ImmutableMap.copyOf(Objects.requireNonNull(byName, "byName"));
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="fields is ImmutableList")
    public List<Field> fields() {
        return this.fields;
    }

    public Optional<Field> field(String name) {
        return Optional.ofNullable((Field)this.byName.get((Object)name));
    }

    public Optional<UnionType> unionType() {
        if (UnionType.ONE_OF_TYPE.matches(this.fields)) {
            return Optional.of(UnionType.ONE_OF_TYPE);
        }
        if (UnionType.GENERALIZED_TYPE.matches(this.fields)) {
            return Optional.of(UnionType.GENERALIZED_TYPE);
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlStruct struct = (SqlStruct)o;
        return this.fields.equals(struct.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public String toString() {
        return this.toString(FormatOptions.none());
    }

    @Override
    public String toString(FormatOptions formatOptions) {
        if (this.fields.isEmpty()) {
            return EMPTY_STRUCT;
        }
        return this.fields.stream().map(f -> f.toString(formatOptions)).collect(Collectors.joining(", ", PREFIX, POSTFIX));
    }

    public static final class Builder {
        private final List<Field> fields = new ArrayList<Field>();
        private final Map<String, Field> byName = new HashMap<String, Field>();

        public Builder field(String fieldName, SqlType fieldType) {
            Field field = new Field(fieldName, fieldType, this.fields.size());
            if (this.byName.putIfAbsent(field.name(), field) != null) {
                throw new DataException("Duplicate field names found in STRUCT: '" + String.valueOf(this.byName.get(field.name())) + "' and '" + String.valueOf(field) + "'");
            }
            this.fields.add(field);
            return this;
        }

        public Builder field(Field field) {
            this.field(field.name(), field.type());
            return this;
        }

        public Builder fields(Iterable<? extends Field> fields) {
            fields.forEach(this::field);
            return this;
        }

        public SqlStruct build() {
            return new SqlStruct(this.fields, this.byName);
        }
    }

    @Immutable
    public static final class Field {
        private final String name;
        private final SqlType type;
        private final int index;

        @VisibleForTesting
        Field(String name, SqlType type, int index) {
            this.name = Objects.requireNonNull(name, "name");
            this.type = Objects.requireNonNull(type, "type");
            this.index = index;
            if (!name.trim().equals(name)) {
                throw new IllegalArgumentException("name is not trimmed: '" + name + "'");
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException("name is empty");
            }
            if (index < 0) {
                throw new IllegalArgumentException("negative index: " + index);
            }
        }

        public SqlType type() {
            return this.type;
        }

        public String name() {
            return this.name;
        }

        public int index() {
            return this.index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Field that = (Field)o;
            return this.index == that.index && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.index, this.name, this.type);
        }

        public String toString() {
            return this.toString(FormatOptions.none());
        }

        public String toString(FormatOptions formatOptions) {
            return formatOptions.escape(this.name) + " " + this.type.toString(formatOptions);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum UnionType {
        GENERALIZED_TYPE{

            @Override
            public boolean matches(ImmutableList<Field> fields) {
                Predicate<Field> isConnectUnionTypeField = field -> field.name.startsWith("connect_union_field_");
                return !fields.isEmpty() && fields.stream().allMatch(isConnectUnionTypeField);
            }
        }
        ,
        ONE_OF_TYPE{

            @Override
            public boolean matches(ImmutableList<Field> fields) {
                Predicate<Field> isOneOfUnionTypeField = field -> field.name.startsWith("io.confluent.connect.json.OneOf.field");
                return !fields.isEmpty() && fields.stream().allMatch(isOneOfUnionTypeField);
            }
        };


        public abstract boolean matches(ImmutableList<Field> var1);
    }
}

