/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.function.sdk.v1;

import io.confluent.function.sdk.v1.AuthTokenProvider;
import io.confluent.function.sdk.v1.CfltFunctionClient;
import io.confluent.function.sdk.v1.types.CfltFunction;
import io.confluent.function.sdk.v1.types.ObjectMetadata;
import io.confluent.secure.compute.function.runtime.v2.FunctionRuntimeGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;

public class CfltFunctionClientBuilder {
    private static final String dataPlaneDevelPublicGatewayServerEndpoint = "a21a03708f2bb4b6abf41678779c7847-1648523723.us-west-2.elb.amazonaws.com:50051";
    private String clientId;
    private String invocationEndpoint;
    private AuthTokenProvider authTokenProvider;
    private ObjectMetadata funcMetadata;
    private boolean useExperimentalV2Routing;
    private boolean useExperimentalDevelPublicGateway;
    private ManagedChannel channel;

    public CfltFunctionClientBuilder withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public CfltFunctionClientBuilder withFunction(CfltFunction cfltFunction) {
        return this.withFunctionMetadata(cfltFunction.getMetadata()).withInvocationEndpoint(cfltFunction.getStatus().getEndpoint().getHost() + ":" + cfltFunction.getStatus().getEndpoint().getPort());
    }

    public CfltFunctionClientBuilder withAuthTokenProvider(AuthTokenProvider authTokenProvider) {
        this.authTokenProvider = authTokenProvider;
        return this;
    }

    public CfltFunctionClientBuilder withInvocationEndpoint(String invocationEndpoint) {
        this.invocationEndpoint = invocationEndpoint;
        return this;
    }

    public CfltFunctionClientBuilder withFunctionMetadata(ObjectMetadata funcMetadata) {
        this.funcMetadata = funcMetadata;
        return this;
    }

    public CfltFunctionClientBuilder useExperimentalV2Routing() {
        this.useExperimentalV2Routing = true;
        return this;
    }

    public CfltFunctionClientBuilder useExperimentalDevelPublicGateway() {
        this.useExperimentalDevelPublicGateway = true;
        return this;
    }

    public CfltFunctionClientBuilder withExperimentalRuntimeClientConnection(ManagedChannel channel) {
        this.channel = channel;
        return this;
    }

    public CfltFunctionClient build() {
        ManagedChannel channel;
        String invocationEndpoint = this.invocationEndpoint;
        boolean useInsecure = false;
        if (this.useExperimentalDevelPublicGateway) {
            invocationEndpoint = dataPlaneDevelPublicGatewayServerEndpoint;
            useInsecure = true;
        }
        if ((channel = this.channel) == null) {
            String[] parts = invocationEndpoint.split(":");
            NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)parts[0], (int)Integer.parseInt(parts[1]));
            if (useInsecure) {
                builder.usePlaintext();
            }
            channel = builder.build();
        }
        FunctionRuntimeGrpc.FunctionRuntimeBlockingStub blockingStub = FunctionRuntimeGrpc.newBlockingStub((Channel)channel);
        return new CfltFunctionClient(this.clientId, invocationEndpoint, this.authTokenProvider, this.funcMetadata, this.useExperimentalV2Routing, blockingStub, channel);
    }
}

