/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;

public class ParsedDockerfile {
    private static final Logger log = LoggerFactory.getLogger(ParsedDockerfile.class);
    private static final Pattern FROM_LINE_PATTERN = Pattern.compile("FROM (?<arg>--[^\\s]+\\s)*(?<image>[^\\s]+).*", 2);
    private final Path dockerFilePath;
    private Set<String> dependencyImageNames = Collections.emptySet();

    public ParsedDockerfile(Path dockerFilePath) {
        this.dockerFilePath = dockerFilePath;
        this.parse(this.read());
    }

    @VisibleForTesting
    ParsedDockerfile(List<String> lines) {
        this.dockerFilePath = Paths.get("dummy.Dockerfile", new String[0]);
        this.parse(lines);
    }

    private List<String> read() {
        if (!Files.exists(this.dockerFilePath, new LinkOption[0])) {
            log.warn("Tried to parse Dockerfile at path {} but none was found", (Object)this.dockerFilePath);
            return Collections.emptyList();
        }
        try {
            return Files.readAllLines(this.dockerFilePath);
        }
        catch (IOException e) {
            log.warn("Unable to read Dockerfile at path {}", (Object)this.dockerFilePath, (Object)e);
            return Collections.emptyList();
        }
    }

    private void parse(List<String> lines) {
        this.dependencyImageNames = lines.stream().map(FROM_LINE_PATTERN::matcher).filter(Matcher::matches).map(matcher -> matcher.group("image")).collect(Collectors.toSet());
        if (!this.dependencyImageNames.isEmpty()) {
            log.debug("Found dependency images in Dockerfile {}: {}", (Object)this.dockerFilePath, this.dependencyImageNames);
        }
    }

    public Set<String> getDependencyImageNames() {
        return this.dependencyImageNames;
    }
}

