/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class DescribeTopicPartitionsResponseData
implements ApiMessage {
    int throttleTimeMs;
    DescribeTopicPartitionsResponseTopicCollection topics;
    Cursor nextCursor;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new CompactArrayOf(DescribeTopicPartitionsResponseTopic.SCHEMA_0), "Each topic in the response."), new Field("next_cursor", Cursor.SCHEMA_0, "The next topic and partition index to fetch details for."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public DescribeTopicPartitionsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeTopicPartitionsResponseData() {
        this.throttleTimeMs = 0;
        this.topics = new DescribeTopicPartitionsResponseTopicCollection(0);
        this.nextCursor = null;
    }

    @Override
    public short apiKey() {
        return 75;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        DescribeTopicPartitionsResponseTopicCollection newCollection = new DescribeTopicPartitionsResponseTopicCollection(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new DescribeTopicPartitionsResponseTopic(_readable, _version, _context));
        }
        this.topics = newCollection;
        this.nextCursor = _readable.readByte() < 0 ? null : new Cursor(_readable, _version, _context);
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        for (DescribeTopicPartitionsResponseTopic topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version, _context);
        }
        if (this.nextCursor == null) {
            _writable.writeByte((byte)-1);
        } else {
            _writable.writeByte((byte)1);
            this.nextCursor.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        for (DescribeTopicPartitionsResponseTopic topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version, _context);
        }
        if (this.nextCursor == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(1);
            this.nextCursor.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeTopicPartitionsResponseData)) {
            return false;
        }
        DescribeTopicPartitionsResponseData other = (DescribeTopicPartitionsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.nextCursor == null ? other.nextCursor != null : !this.nextCursor.equals(other.nextCursor)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + (this.nextCursor == null ? 0 : this.nextCursor.hashCode());
        return hashCode;
    }

    @Override
    public DescribeTopicPartitionsResponseData duplicate() {
        DescribeTopicPartitionsResponseData _duplicate = new DescribeTopicPartitionsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        DescribeTopicPartitionsResponseTopicCollection newTopics = new DescribeTopicPartitionsResponseTopicCollection(this.topics.size());
        for (DescribeTopicPartitionsResponseTopic _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        _duplicate.nextCursor = this.nextCursor == null ? null : this.nextCursor.duplicate();
        return _duplicate;
    }

    public String toString() {
        return "DescribeTopicPartitionsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", nextCursor=" + (this.nextCursor == null ? "null" : this.nextCursor.toString()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public DescribeTopicPartitionsResponseTopicCollection topics() {
        return this.topics;
    }

    public Cursor nextCursor() {
        return this.nextCursor;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeTopicPartitionsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeTopicPartitionsResponseData setTopics(DescribeTopicPartitionsResponseTopicCollection v) {
        this.topics = v;
        return this;
    }

    public DescribeTopicPartitionsResponseData setNextCursor(Cursor v) {
        this.nextCursor = v;
        return this;
    }

    public static class DescribeTopicPartitionsResponseTopicCollection
    extends ImplicitLinkedHashMultiCollection<DescribeTopicPartitionsResponseTopic> {
        public DescribeTopicPartitionsResponseTopicCollection() {
        }

        public DescribeTopicPartitionsResponseTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public DescribeTopicPartitionsResponseTopicCollection(Iterator<DescribeTopicPartitionsResponseTopic> iterator) {
            super(iterator);
        }

        @Override
        public DescribeTopicPartitionsResponseTopic find(String name) {
            DescribeTopicPartitionsResponseTopic _key = new DescribeTopicPartitionsResponseTopic();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<DescribeTopicPartitionsResponseTopic> findAll(String name) {
            DescribeTopicPartitionsResponseTopic _key = new DescribeTopicPartitionsResponseTopic();
            _key.setName(name);
            return this.findAll(_key);
        }

        public DescribeTopicPartitionsResponseTopicCollection duplicate() {
            DescribeTopicPartitionsResponseTopicCollection _duplicate = new DescribeTopicPartitionsResponseTopicCollection(this.size());
            for (DescribeTopicPartitionsResponseTopic _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class Cursor
    implements Message {
        String topicName;
        int partitionIndex;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The name for the first topic to process."), new Field("partition_index", Type.INT32, "The partition index to start with."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Cursor(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public Cursor() {
            this.topicName = "";
            this.partitionIndex = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Cursor");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            this.partitionIndex = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.topicName);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeInt(this.partitionIndex);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Cursor");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topicName).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topicName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Cursor)) {
                return false;
            }
            Cursor other = (Cursor)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.partitionIndex;
            return hashCode;
        }

        @Override
        public Cursor duplicate() {
            Cursor _duplicate = new Cursor();
            _duplicate.topicName = this.topicName;
            _duplicate.partitionIndex = this.partitionIndex;
            return _duplicate;
        }

        public String toString() {
            return "Cursor(topicName=" + (String)(this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitionIndex=" + this.partitionIndex + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Cursor setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public Cursor setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }
    }

    public static class DescribeTopicPartitionsResponseTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        short errorCode;
        String name;
        Uuid topicId;
        boolean isInternal;
        List<DescribeTopicPartitionsResponsePartition> partitions;
        int topicAuthorizedOperations;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", Type.COMPACT_NULLABLE_STRING, "The topic name."), new Field("topic_id", Type.UUID, "The topic id."), new Field("is_internal", Type.BOOLEAN, "True if the topic is internal."), new Field("partitions", new CompactArrayOf(DescribeTopicPartitionsResponsePartition.SCHEMA_0), "Each partition in the topic."), new Field("topic_authorized_operations", Type.INT32, "32-bit bitfield to represent authorized operations for this topic."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public DescribeTopicPartitionsResponseTopic(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public DescribeTopicPartitionsResponseTopic() {
            this.errorCode = 0;
            this.name = "";
            this.topicId = Uuid.ZERO_UUID;
            this.isInternal = false;
            this.partitions = new ArrayList<DescribeTopicPartitionsResponsePartition>(0);
            this.topicAuthorizedOperations = Integer.MIN_VALUE;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeTopicPartitionsResponseTopic");
            }
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.name = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field name had invalid length " + length);
                }
                this.name = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            }
            this.topicId = _readable.readUuid();
            this.isInternal = _readable.readByte() != 0;
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<DescribeTopicPartitionsResponsePartition> newCollection = new ArrayList<DescribeTopicPartitionsResponsePartition>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribeTopicPartitionsResponsePartition(_readable, _version, _context));
            }
            this.partitions = newCollection;
            this.topicAuthorizedOperations = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.name == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.name);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            _writable.writeUuid(this.topicId);
            _writable.writeByte(this.isInternal ? (byte)1 : 0);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                DescribeTopicPartitionsResponsePartition partitionsElement = (DescribeTopicPartitionsResponsePartition)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version, _context);
            }
            _writable.writeInt(this.topicAuthorizedOperations);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeTopicPartitionsResponseTopic");
            }
            _size.addBytes(2);
            if (this.name == null) {
                _size.addBytes(1);
            } else {
                byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.name).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'name' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.name, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _size.addBytes(16);
            _size.addBytes(1);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (DescribeTopicPartitionsResponsePartition partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version, _context);
            }
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof DescribeTopicPartitionsResponseTopic)) {
                return false;
            }
            DescribeTopicPartitionsResponseTopic other = (DescribeTopicPartitionsResponseTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeTopicPartitionsResponseTopic)) {
                return false;
            }
            DescribeTopicPartitionsResponseTopic other = (DescribeTopicPartitionsResponseTopic)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.isInternal != other.isInternal) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            if (this.topicAuthorizedOperations != other.topicAuthorizedOperations) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public DescribeTopicPartitionsResponseTopic duplicate() {
            DescribeTopicPartitionsResponseTopic _duplicate = new DescribeTopicPartitionsResponseTopic();
            _duplicate.errorCode = this.errorCode;
            _duplicate.name = this.name == null ? null : this.name;
            _duplicate.topicId = this.topicId;
            _duplicate.isInternal = this.isInternal;
            ArrayList<DescribeTopicPartitionsResponsePartition> newPartitions = new ArrayList<DescribeTopicPartitionsResponsePartition>(this.partitions.size());
            for (DescribeTopicPartitionsResponsePartition _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            _duplicate.topicAuthorizedOperations = this.topicAuthorizedOperations;
            return _duplicate;
        }

        public String toString() {
            return "DescribeTopicPartitionsResponseTopic(errorCode=" + this.errorCode + ", name=" + (String)(this.name == null ? "null" : "'" + this.name.toString() + "'") + ", topicId=" + this.topicId.toString() + ", isInternal=" + (this.isInternal ? "true" : "false") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ", topicAuthorizedOperations=" + this.topicAuthorizedOperations + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String name() {
            return this.name;
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public List<DescribeTopicPartitionsResponsePartition> partitions() {
            return this.partitions;
        }

        public int topicAuthorizedOperations() {
            return this.topicAuthorizedOperations;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeTopicPartitionsResponseTopic setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DescribeTopicPartitionsResponseTopic setName(String v) {
            this.name = v;
            return this;
        }

        public DescribeTopicPartitionsResponseTopic setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public DescribeTopicPartitionsResponseTopic setIsInternal(boolean v) {
            this.isInternal = v;
            return this;
        }

        public DescribeTopicPartitionsResponseTopic setPartitions(List<DescribeTopicPartitionsResponsePartition> v) {
            this.partitions = v;
            return this;
        }

        public DescribeTopicPartitionsResponseTopic setTopicAuthorizedOperations(int v) {
            this.topicAuthorizedOperations = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class DescribeTopicPartitionsResponsePartition
    implements Message {
        short errorCode;
        int partitionIndex;
        int leaderId;
        int leaderEpoch;
        List<Integer> replicaNodes;
        List<Integer> observers;
        List<Integer> isrNodes;
        List<Integer> eligibleLeaderReplicas;
        List<Integer> lastKnownElr;
        List<Integer> offlineReplicas;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The partition error, or 0 if there was no error."), new Field("partition_index", Type.INT32, "The partition index."), new Field("leader_id", Type.INT32, "The ID of the leader broker."), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition."), new Field("replica_nodes", new CompactArrayOf(Type.INT32), "The set of all nodes that host this partition."), new Field("isr_nodes", new CompactArrayOf(Type.INT32), "The set of nodes that are in sync with the leader for this partition."), new Field("eligible_leader_replicas", CompactArrayOf.nullable(Type.INT32), "The new eligible leader replicas otherwise."), new Field("last_known_elr", CompactArrayOf.nullable(Type.INT32), "The last known ELR."), new Field("offline_replicas", new CompactArrayOf(Type.INT32), "The set of offline replicas of this partition."), Field.TaggedFieldsSection.of(10000, new Field("observers", new CompactArrayOf(Type.INT32), "The brokers in ReplicaNodes that are observers in a partition.")));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public DescribeTopicPartitionsResponsePartition(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public DescribeTopicPartitionsResponsePartition() {
            this.errorCode = 0;
            this.partitionIndex = 0;
            this.leaderId = 0;
            this.leaderEpoch = -1;
            this.replicaNodes = new ArrayList<Integer>(0);
            this.observers = new ArrayList<Integer>(0);
            this.isrNodes = new ArrayList<Integer>(0);
            this.eligibleLeaderReplicas = null;
            this.lastKnownElr = null;
            this.offlineReplicas = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeTopicPartitionsResponsePartition");
            }
            this.errorCode = _readable.readShort();
            this.partitionIndex = _readable.readInt();
            this.leaderId = _readable.readInt();
            this.leaderEpoch = _readable.readInt();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field replicaNodes was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.replicaNodes = newCollection;
            this.observers = new ArrayList<Integer>(0);
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field isrNodes was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.isrNodes = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.eligibleLeaderReplicas = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readInt());
                }
                this.eligibleLeaderReplicas = newCollection;
            }
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.lastKnownElr = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readInt());
                }
                this.lastKnownElr = newCollection;
            }
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field offlineReplicas was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.offlineReplicas = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            block8: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 10000: {
                        int arrayLength2 = _readable.readUnsignedVarint() - 1;
                        if (arrayLength2 < 0) {
                            throw new RuntimeException("non-nullable field observers was serialized as null");
                        }
                        if (arrayLength2 > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        ArrayList<Integer> newCollection2 = new ArrayList<Integer>(arrayLength2);
                        for (int i2 = 0; i2 < arrayLength2; ++i2) {
                            newCollection2.add(_readable.readInt());
                        }
                        this.observers = newCollection2;
                        continue block8;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            _writable.writeInt(this.partitionIndex);
            _writable.writeInt(this.leaderId);
            _writable.writeInt(this.leaderEpoch);
            _writable.writeUnsignedVarint(this.replicaNodes.size() + 1);
            for (Integer replicaNodesElement : this.replicaNodes) {
                _writable.writeInt(replicaNodesElement);
            }
            if (!this.observers.isEmpty()) {
                ++_numTaggedFields;
            }
            _writable.writeUnsignedVarint(this.isrNodes.size() + 1);
            for (Integer isrNodesElement : this.isrNodes) {
                _writable.writeInt(isrNodesElement);
            }
            if (this.eligibleLeaderReplicas == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.eligibleLeaderReplicas.size() + 1);
                for (Integer eligibleLeaderReplicasElement : this.eligibleLeaderReplicas) {
                    _writable.writeInt(eligibleLeaderReplicasElement);
                }
            }
            if (this.lastKnownElr == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.lastKnownElr.size() + 1);
                for (Integer lastKnownElrElement : this.lastKnownElr) {
                    _writable.writeInt(lastKnownElrElement);
                }
            }
            _writable.writeUnsignedVarint(this.offlineReplicas.size() + 1);
            for (Integer offlineReplicasElement : this.offlineReplicas) {
                _writable.writeInt(offlineReplicasElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, 10000);
            if (!this.observers.isEmpty()) {
                _writable.writeUnsignedVarint(10000);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.observers));
                _writable.writeUnsignedVarint(this.observers.size() + 1);
                for (Integer observersElement : this.observers) {
                    _writable.writeInt(observersElement);
                }
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeTopicPartitionsResponsePartition");
            }
            _size.addBytes(2);
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.replicaNodes.size() + 1));
            _size.addBytes(this.replicaNodes.size() * 4);
            if (!this.observers.isEmpty()) {
                ++_numTaggedFields;
                _size.addBytes(2);
                int _sizeBeforeArray = _size.totalSize();
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.observers.size() + 1));
                _size.addBytes(this.observers.size() * 4);
                int _arraySize = _size.totalSize() - _sizeBeforeArray;
                _cache.setArraySizeInBytes(this.observers, _arraySize);
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.isrNodes.size() + 1));
            _size.addBytes(this.isrNodes.size() * 4);
            if (this.eligibleLeaderReplicas == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.eligibleLeaderReplicas.size() + 1));
                _size.addBytes(this.eligibleLeaderReplicas.size() * 4);
            }
            if (this.lastKnownElr == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.lastKnownElr.size() + 1));
                _size.addBytes(this.lastKnownElr.size() * 4);
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.offlineReplicas.size() + 1));
            _size.addBytes(this.offlineReplicas.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeTopicPartitionsResponsePartition)) {
                return false;
            }
            DescribeTopicPartitionsResponsePartition other = (DescribeTopicPartitionsResponsePartition)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.leaderId != other.leaderId) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.replicaNodes == null ? other.replicaNodes != null : !this.replicaNodes.equals(other.replicaNodes)) {
                return false;
            }
            if (this.observers == null ? other.observers != null : !this.observers.equals(other.observers)) {
                return false;
            }
            if (this.isrNodes == null ? other.isrNodes != null : !this.isrNodes.equals(other.isrNodes)) {
                return false;
            }
            if (this.eligibleLeaderReplicas == null ? other.eligibleLeaderReplicas != null : !this.eligibleLeaderReplicas.equals(other.eligibleLeaderReplicas)) {
                return false;
            }
            if (this.lastKnownElr == null ? other.lastKnownElr != null : !this.lastKnownElr.equals(other.lastKnownElr)) {
                return false;
            }
            if (this.offlineReplicas == null ? other.offlineReplicas != null : !this.offlineReplicas.equals(other.offlineReplicas)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.leaderId;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + (this.replicaNodes == null ? 0 : this.replicaNodes.hashCode());
            hashCode = 31 * hashCode + (this.observers == null ? 0 : this.observers.hashCode());
            hashCode = 31 * hashCode + (this.isrNodes == null ? 0 : this.isrNodes.hashCode());
            hashCode = 31 * hashCode + (this.eligibleLeaderReplicas == null ? 0 : this.eligibleLeaderReplicas.hashCode());
            hashCode = 31 * hashCode + (this.lastKnownElr == null ? 0 : this.lastKnownElr.hashCode());
            hashCode = 31 * hashCode + (this.offlineReplicas == null ? 0 : this.offlineReplicas.hashCode());
            return hashCode;
        }

        @Override
        public DescribeTopicPartitionsResponsePartition duplicate() {
            DescribeTopicPartitionsResponsePartition _duplicate = new DescribeTopicPartitionsResponsePartition();
            _duplicate.errorCode = this.errorCode;
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.leaderId = this.leaderId;
            _duplicate.leaderEpoch = this.leaderEpoch;
            ArrayList<Integer> newReplicaNodes = new ArrayList<Integer>(this.replicaNodes.size());
            for (Integer n : this.replicaNodes) {
                newReplicaNodes.add(n);
            }
            _duplicate.replicaNodes = newReplicaNodes;
            ArrayList<Integer> newObservers = new ArrayList<Integer>(this.observers.size());
            for (Integer n : this.observers) {
                newObservers.add(n);
            }
            _duplicate.observers = newObservers;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(this.isrNodes.size());
            for (Integer _element : this.isrNodes) {
                arrayList.add(_element);
            }
            _duplicate.isrNodes = arrayList;
            if (this.eligibleLeaderReplicas == null) {
                _duplicate.eligibleLeaderReplicas = null;
            } else {
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>(this.eligibleLeaderReplicas.size());
                for (Integer _element : this.eligibleLeaderReplicas) {
                    arrayList2.add(_element);
                }
                _duplicate.eligibleLeaderReplicas = arrayList2;
            }
            if (this.lastKnownElr == null) {
                _duplicate.lastKnownElr = null;
            } else {
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>(this.lastKnownElr.size());
                for (Integer _element : this.lastKnownElr) {
                    arrayList3.add(_element);
                }
                _duplicate.lastKnownElr = arrayList3;
            }
            ArrayList<Integer> arrayList4 = new ArrayList<Integer>(this.offlineReplicas.size());
            for (Integer _element : this.offlineReplicas) {
                arrayList4.add(_element);
            }
            _duplicate.offlineReplicas = arrayList4;
            return _duplicate;
        }

        public String toString() {
            return "DescribeTopicPartitionsResponsePartition(errorCode=" + this.errorCode + ", partitionIndex=" + this.partitionIndex + ", leaderId=" + this.leaderId + ", leaderEpoch=" + this.leaderEpoch + ", replicaNodes=" + MessageUtil.deepToString(this.replicaNodes.iterator()) + ", observers=" + MessageUtil.deepToString(this.observers.iterator()) + ", isrNodes=" + MessageUtil.deepToString(this.isrNodes.iterator()) + ", eligibleLeaderReplicas=" + (this.eligibleLeaderReplicas == null ? "null" : MessageUtil.deepToString(this.eligibleLeaderReplicas.iterator())) + ", lastKnownElr=" + (this.lastKnownElr == null ? "null" : MessageUtil.deepToString(this.lastKnownElr.iterator())) + ", offlineReplicas=" + MessageUtil.deepToString(this.offlineReplicas.iterator()) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int leaderId() {
            return this.leaderId;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<Integer> replicaNodes() {
            return this.replicaNodes;
        }

        public List<Integer> observers() {
            return this.observers;
        }

        public List<Integer> isrNodes() {
            return this.isrNodes;
        }

        public List<Integer> eligibleLeaderReplicas() {
            return this.eligibleLeaderReplicas;
        }

        public List<Integer> lastKnownElr() {
            return this.lastKnownElr;
        }

        public List<Integer> offlineReplicas() {
            return this.offlineReplicas;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeTopicPartitionsResponsePartition setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DescribeTopicPartitionsResponsePartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public DescribeTopicPartitionsResponsePartition setLeaderId(int v) {
            this.leaderId = v;
            return this;
        }

        public DescribeTopicPartitionsResponsePartition setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public DescribeTopicPartitionsResponsePartition setReplicaNodes(List<Integer> v) {
            this.replicaNodes = v;
            return this;
        }

        public DescribeTopicPartitionsResponsePartition setObservers(List<Integer> v) {
            this.observers = v;
            return this;
        }

        public DescribeTopicPartitionsResponsePartition setIsrNodes(List<Integer> v) {
            this.isrNodes = v;
            return this;
        }

        public DescribeTopicPartitionsResponsePartition setEligibleLeaderReplicas(List<Integer> v) {
            this.eligibleLeaderReplicas = v;
            return this;
        }

        public DescribeTopicPartitionsResponsePartition setLastKnownElr(List<Integer> v) {
            this.lastKnownElr = v;
            return this;
        }

        public DescribeTopicPartitionsResponsePartition setOfflineReplicas(List<Integer> v) {
            this.offlineReplicas = v;
            return this;
        }
    }
}

