/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.cli.Cli;
import io.confluent.ksql.cli.Options;
import io.confluent.ksql.cli.console.OutputFormat;
import io.confluent.ksql.properties.PropertiesUtil;
import io.confluent.ksql.rest.client.KsqlRestClient;
import io.confluent.ksql.security.AuthType;
import io.confluent.ksql.security.BasicCredentials;
import io.confluent.ksql.security.Credentials;
import io.confluent.ksql.security.CredentialsFactory;
import io.confluent.ksql.util.ErrorMessageUtil;
import io.confluent.ksql.util.KsqlException;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Ksql {
    private static final Logger LOGGER = LogManager.getLogger(Ksql.class);
    private static final Predicate<String> NOT_CLIENT_SIDE_CONFIG = key -> !key.startsWith("ssl.") && !key.equals("security.protocol") && !key.startsWith("sasl.");
    private final Options options;
    private final KsqlClientBuilder clientBuilder;
    private final Properties systemProps;
    private final CliBuilder cliBuilder;

    @VisibleForTesting
    Ksql(Options options, Properties systemProps, KsqlClientBuilder clientBuilder, CliBuilder cliBuilder) {
        this.options = Objects.requireNonNull(options, "options");
        this.systemProps = Objects.requireNonNull(systemProps, "systemProps");
        this.clientBuilder = Objects.requireNonNull(clientBuilder, "clientBuilder");
        this.cliBuilder = Objects.requireNonNull(cliBuilder, "cliBuilder");
    }

    public static void main(String[] args) throws IOException {
        Options options = Options.parse(args);
        if (options == null) {
            System.exit(-1);
        }
        if (options.requiresPassword()) {
            options.setPassword(Ksql.readPassword());
        }
        int errorCode = 0;
        try {
            errorCode = new Ksql(options, System.getProperties(), KsqlRestClient::create, Cli::build).run();
        }
        catch (Exception e) {
            String msg = ErrorMessageUtil.buildErrorMessage((Throwable)e);
            LOGGER.error(msg);
            System.err.println(msg);
            System.exit(-1);
        }
        System.exit(errorCode);
    }

    private static String readPassword() {
        Console console = System.console();
        if (console == null) {
            System.err.println("Could not get console for enter password; use -p option instead.");
            System.exit(-1);
        }
        String password = "";
        while (password.isEmpty()) {
            password = new String(console.readPassword("Enter password: ", new Object[0]));
            if (!password.isEmpty()) continue;
            console.writer().println("Error: password can not be empty");
        }
        return password;
    }

    /*
     * Unable to fully structure code
     */
    int run() {
        configProps = this.options.getConfigFile().map((Function<String, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, loadProperties(java.lang.String ), (Ljava/lang/String;)Ljava/util/Map;)()).orElseGet((Supplier<Map>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, emptyMap(), ()Ljava/util/Map;)());
        sessionVariables = this.options.getVariables();
        restClient = this.buildClient(configProps);
        try {
            block20: {
                block19: {
                    cli = this.cliBuilder.build(this.options.getStreamedQueryRowLimit(), this.options.getStreamedQueryTimeoutMs(), this.options.getOutputFormat(), restClient);
                    try {
                        cli.addSessionVariables(sessionVariables);
                        if (!this.options.getExecute().isPresent()) break block19;
                        var5_6 = cli.runCommand(this.options.getExecute().get());
                        if (cli != null) {
                            cli.close();
                        }
                        return var5_6;
                    }
                    catch (Throwable var5_9) {
                        if (cli != null) {
                            try {
                                cli.close();
                            }
                            catch (Throwable var6_12) {
                                var5_9.addSuppressed(var6_12);
                            }
                        }
                        throw var5_9;
                    }
                }
                if (!this.options.getScriptFile().isPresent()) ** GOTO lbl36
                scriptFile = new File(this.options.getScriptFile().get());
                if (!scriptFile.exists() || !scriptFile.isFile()) break block20;
                var6_11 = cli.runScript(scriptFile.getPath());
                if (cli != null) {
                    cli.close();
                }
                return var6_11;
            }
            throw new KsqlException("No such script file: " + scriptFile.getPath());
lbl36:
            // 1 sources

            var5_8 = cli.runInteractively();
            if (cli != null) {
                cli.close();
            }
            return var5_8;
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    private KsqlRestClient buildClient(Map<String, String> configProps) {
        Map<String, String> localProps = Ksql.stripClientSideProperties(configProps);
        Map clientProps = PropertiesUtil.applyOverrides(configProps, (Properties)this.systemProps);
        String server = this.options.getServer();
        Optional<Credentials> creds = this.getCredentials();
        Optional<BasicCredentials> ccloudApiKey = this.options.getCCloudApiKey();
        return this.clientBuilder.build(server, localProps, clientProps, creds, ccloudApiKey);
    }

    private Optional<Credentials> getCredentials() {
        this.options.validateCredentials();
        AuthType authType = AuthType.NONE;
        String userName = this.options.getUserName();
        String password = this.options.getPassword();
        String token = this.options.getToken();
        HashMap<String, String> configProps = new HashMap<String, String>();
        if (userName != null && !userName.isEmpty() && password != null && !password.isEmpty()) {
            authType = AuthType.BASIC;
            configProps.put("ksql.auth.basic.username", userName);
            configProps.put("ksql.auth.basic.password", password);
        } else if (token != null && !token.isEmpty()) {
            authType = AuthType.STATIC_TOKEN;
            configProps.put("bearer.auth.token", token);
        }
        return Optional.ofNullable(CredentialsFactory.createCredentials((AuthType)authType, (String)((String)configProps.get("custom.token.credentials.class")))).map(credentials -> {
            credentials.configure(configProps);
            return credentials;
        });
    }

    private static Map<String, String> stripClientSideProperties(Map<String, String> props) {
        return PropertiesUtil.filterByKey(props, NOT_CLIENT_SIDE_CONFIG);
    }

    private static Map<String, String> loadProperties(String propertiesFile) {
        return PropertiesUtil.loadProperties((File)new File(propertiesFile));
    }

    static interface KsqlClientBuilder {
        public KsqlRestClient build(String var1, Map<String, ?> var2, Map<String, String> var3, Optional<Credentials> var4, Optional<BasicCredentials> var5);
    }

    static interface CliBuilder {
        public Cli build(Long var1, Long var2, OutputFormat var3, KsqlRestClient var4);
    }
}

