/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli;

import com.github.rvesse.airline.HelpOption;
import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.Once;
import com.github.rvesse.airline.annotations.restrictions.ranges.LongRange;
import com.github.rvesse.airline.help.Help;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.parser.errors.ParseException;
import io.confluent.ksql.cli.console.OutputFormat;
import io.confluent.ksql.parser.VariableParser;
import io.confluent.ksql.security.BasicCredentials;
import io.confluent.ksql.security.Credentials;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.kafka.common.config.ConfigException;

@Command(name="ksql", description="KSQL CLI")
public class Options {
    private static final String STREAMED_QUERY_ROW_LIMIT_OPTION_NAME = "--query-row-limit";
    private static final String STREAMED_QUERY_TIMEOUT_OPTION_NAME = "--query-timeout";
    private static final String USERNAME_OPTION = "--user";
    private static final String USERNAME_SHORT_OPTION = "-u";
    private static final String PASSWORD_OPTION = "--password";
    private static final String PASSWORD_SHORT_OPTION = "-p";
    private static final String OUTPUT_FORMAT_OPTION_NAME = "--output";
    private static final String EXECUTE_OPTION = "--execute";
    private static final String EXECUTE_SHORT_OPTION = "-e";
    private static final String FILE_OPTION = "--file";
    private static final String FILE_SHORT_OPTION = "-f";
    private static final String DEFINE_OPTION = "--define";
    private static final String DEFINE_SHORT_OPTION = "-d";
    private static final String CONFIGURATION_FILE_OPTION_NAME = "--config-file";
    private static final String CONFLUENT_API_KEY_OPTION = "--confluent-api-key";
    private static final String CONFLUENT_API_SECRET_OPTION = "--confluent-api-secret";
    private static final String CONFLUENT_TOKEN_OPTION = "--token";
    private static final String CONFLUENT_TOKEN_SHORT_OPTION = "-t";
    @Inject
    public HelpOption<?> help;
    @Once
    @Arguments(title={"server"}, description="The address of the Ksql server to connect to (ex: http://confluent.io:9098)")
    private String server = "http://localhost:8088";
    @Option(name={"--config-file"}, description="A file specifying configs for Ksql and its underlying Kafka Streams instance(s). Refer to KSQL documentation for a list of available configs.")
    private String configFile;
    @Option(name={"--user", "-u"}, description="If your KSQL server is configured for authentication, then provide your user name here. The password must be specified separately with the -p/--password flag")
    private String userName = "";
    @Option(name={"--password", "-p"}, description="If your KSQL server is configured for authentication, then provide your password here. The username must be specified separately with the -u/--user flag")
    private String password = "";
    @Option(name={"--query-row-limit"}, description="An optional maximum number of rows to read from streamed queries")
    @LongRange(min=1L)
    private Long streamedQueryRowLimit;
    @Option(name={"--query-timeout"}, description="An optional time limit (in milliseconds) for streamed queries")
    @LongRange(min=1L)
    private Long streamedQueryTimeoutMs;
    @Option(name={"--output"}, description="The output format to use (either 'JSON' or 'TABULAR'; can be changed during REPL as well; defaults to TABULAR)")
    private String outputFormat = OutputFormat.TABULAR.name();
    @Option(name={"--execute", "-e"}, description="Execute one or more SQL statements and quit.")
    private String execute = null;
    @Option(name={"--file", "-f"}, description="Execute commands from a file and exit.")
    private String scriptFile = null;
    @Option(name={"--define", "-d"}, description="Define variables for the CLI session (equivalent to the DEFINE statement).")
    private List<String> definedVars = null;
    @Option(name={"--confluent-api-key"}, description="If you're connecting to a Confluent Cloud ksqlDB server and would like to use ksqlDB's connector management capabilities, then provide your Confluent Cloud API key here. The API key secret must be specified separately with the --confluent-api-secret flag")
    private String ccloudApiKey = "";
    @Option(name={"--confluent-api-secret"}, description="If you're connecting to a Confluent Cloud ksqlDB server and would like to use ksqlDB's connector management capabilities, then provide your Confluent Cloud API key secret here. The API key itself must be specified separately with the --confluent-api-key flag")
    private String ccloudApiSecret = "";
    @Option(name={"--token", "-t"}, description="If your KSQL server is configured for authentication, then provide the confluent token retrieved from confluent cli here.")
    private String token = "";

    public static Options parse(String ... args) throws IOException {
        SingleCommand optionsParser = SingleCommand.singleCommand(Options.class);
        for (String arg : args) {
            if (!"--help".equals(arg) && !"-h".equals(arg)) continue;
            Help.help((CommandMetadata)optionsParser.getCommandMetadata());
            return null;
        }
        try {
            return (Options)optionsParser.parse(args);
        }
        catch (ParseException exception) {
            if (exception.getMessage() != null) {
                System.err.println(exception.getMessage());
            } else {
                System.err.println("Options parsing failed for an unknown reason");
            }
            System.err.println("See the -h or --help flags for usage information");
            return null;
        }
    }

    public String getServer() {
        return this.server;
    }

    public Optional<String> getConfigFile() {
        return Optional.ofNullable(this.configFile);
    }

    public Long getStreamedQueryRowLimit() {
        return this.streamedQueryRowLimit;
    }

    public Long getStreamedQueryTimeoutMs() {
        return this.streamedQueryTimeoutMs;
    }

    public OutputFormat getOutputFormat() {
        return OutputFormat.valueOf(this.outputFormat);
    }

    public boolean requiresPassword() {
        if (this.userName.isEmpty()) {
            return false;
        }
        return this.password.trim().isEmpty();
    }

    public void setPassword(String password) {
        if (password.isEmpty()) {
            throw new IllegalArgumentException("Password must not be empty");
        }
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public Optional<Credentials> getUserNameAndPassword() {
        this.validateCredentials();
        if (this.userName.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(BasicCredentials.of((String)this.userName, (String)this.password));
    }

    public String getToken() {
        return this.token;
    }

    public void validateCredentials() {
        if (!(this.userName.isEmpty() || this.password.isEmpty() || this.token.isEmpty())) {
            throw new ConfigException("Only one of username/password or token can be provided");
        }
        if (this.userName.isEmpty() != this.password.isEmpty()) {
            throw new ConfigException("You must specify both a username and a password. If you don't want to use an authenticated session, don't specify either of the --user or the --password flags on the command line");
        }
    }

    public Optional<BasicCredentials> getCCloudApiKey() {
        if (this.ccloudApiKey.isEmpty() != this.ccloudApiSecret.isEmpty()) {
            throw new ConfigException("You must specify both an API key and the associated secret. If you are not connecting to a Confluent Cloud ksqlDB server or do not plan to use ksqlDB's connector management capabilities, then do not specify eitherof the --confluent-api-key or the --confluent-api-secret flags on the command line");
        }
        if (this.ccloudApiKey.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(BasicCredentials.of((String)this.ccloudApiKey, (String)this.ccloudApiSecret));
    }

    public Optional<String> getExecute() {
        if (this.execute == null || this.execute.isEmpty()) {
            return Optional.empty();
        }
        char lastChar = this.execute.charAt(this.execute.length() - 1);
        return Optional.of(lastChar != ';' ? this.execute + ";" : this.execute);
    }

    public Optional<String> getScriptFile() {
        return Optional.ofNullable(this.scriptFile);
    }

    public Map<String, String> getVariables() {
        return VariableParser.getVariables(this.definedVars);
    }
}

