/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.cmd;

import io.confluent.ksql.cli.console.cmd.CliCmdUtil;
import io.confluent.ksql.cli.console.cmd.CliSpecificCommand;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.client.KsqlRestClient;
import io.confluent.ksql.rest.client.RestResponse;
import io.confluent.ksql.rest.client.exception.KsqlRestClientException;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.ServerInfo;
import io.confluent.ksql.util.ErrorMessageUtil;
import io.confluent.ksql.util.Event;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public final class RemoteServerSpecificCommand
implements CliSpecificCommand {
    private static final int CONSOLE_WIDTH = 80;
    private static final String HELP = "server:" + System.lineSeparator() + "\tShow the current server" + System.lineSeparator() + "\nserver <server>:" + System.lineSeparator() + "\tChange the current server to <server>" + System.lineSeparator() + "\t example: \"server http://my.awesome.server.com:9098;\"";
    private static final String CCLOUD_KSQL_SERVICE_ID_PREFIX = "pksqlc-";
    private static final String CCLOUD_KSQL_ADDRESS_SUBSTRING = ".cloud";
    private final KsqlRestClient restClient;
    private final Event resetCliForNewServer;

    public static RemoteServerSpecificCommand create(KsqlRestClient restClient, Event resetCliForNewServer) {
        return new RemoteServerSpecificCommand(restClient, resetCliForNewServer);
    }

    private RemoteServerSpecificCommand(KsqlRestClient restClient, Event resetCliForNewServer) {
        this.restClient = Objects.requireNonNull(restClient, "restClient");
        this.resetCliForNewServer = Objects.requireNonNull(resetCliForNewServer, "resetCliForNewServer");
    }

    @Override
    public String getName() {
        return "server";
    }

    @Override
    public String getHelpMessage() {
        return HELP;
    }

    @Override
    public void execute(List<String> args, PrintWriter terminal) {
        CliCmdUtil.ensureArgCountBounds(args, 0, 1, HELP);
        if (args.isEmpty()) {
            terminal.println(this.restClient.getServerAddress());
            return;
        }
        String serverAddress = args.get(0);
        this.restClient.setServerAddress(serverAddress);
        terminal.println("Server now: " + serverAddress);
        this.resetCliForNewServer.fire();
        RemoteServerSpecificCommand.validateClient(terminal, this.restClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateClient(PrintWriter writer, KsqlRestClient restClient) {
        try {
            RestResponse restResponse = restClient.getServerInfo();
            if (restResponse.isErroneous()) {
                KsqlErrorMessage ksqlError = restResponse.getErrorMessage();
                if (Errors.toStatusCode((int)ksqlError.getErrorCode()) == HttpResponseStatus.NOT_ACCEPTABLE.code()) {
                    writer.format("This CLI version no longer supported: %s%n%n", ksqlError);
                    return;
                }
                writer.format("Couldn't connect to the KSQL server: %s%n%n", ksqlError.getMessage());
            } else {
                RemoteServerSpecificCommand.maybeSetIsCCloudServer(restClient, (ServerInfo)restResponse.getResponse());
            }
        }
        catch (IllegalArgumentException exception) {
            writer.println("Server URL must begin with protocol (e.g., http:// or https://)");
        }
        catch (KsqlRestClientException exception) {
            writer.println();
            writer.println(StringUtils.center((String)"ERROR", (int)80, (String)"*"));
            String errorMsg = exception.getCause().getCause() instanceof SSLException ? " looks to be configured to use HTTPS / SSL. Please refer to the KSQL documentation on how to configure the CLI for SSL: https://docs.ksqldb.io/en/latest/operate-and-deploy/installation/server-config/security/#configure-the-cli-for-https" : " does not appear to be a valid KSQL server. Please ensure that the URL provided is for an active KSQL server.";
            writer.println(WordUtils.wrap((String)("Remote server at " + String.valueOf(restClient.getServerAddress()) + errorMsg), (int)80));
            writer.println("");
            writer.println("The server responded with the following error: ");
            writer.println(ErrorMessageUtil.buildErrorMessage((Throwable)exception));
            writer.println(StringUtils.repeat((char)'*', (int)80));
            writer.println();
        }
        finally {
            writer.flush();
        }
    }

    private static void maybeSetIsCCloudServer(KsqlRestClient restClient, ServerInfo serverInfo) {
        String ksqlServiceId = serverInfo.getKsqlServiceId();
        String ksqlServerAddress = restClient.getServerAddress().toString();
        restClient.setIsCCloudServer(RemoteServerSpecificCommand.isCCloudServer(ksqlServiceId, ksqlServerAddress));
    }

    private static boolean isCCloudServer(String ksqlServiceId, String ksqlServerAddress) {
        return ksqlServiceId.startsWith(CCLOUD_KSQL_SERVICE_ID_PREFIX) && ksqlServerAddress.contains(CCLOUD_KSQL_ADDRESS_SUBSTRING) && ksqlServerAddress.contains(ksqlServiceId);
    }
}

