/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.table.builder;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.cli.console.table.Table;
import io.confluent.ksql.cli.console.table.builder.TableBuilder;
import io.confluent.ksql.rest.entity.ConnectorList;
import io.confluent.ksql.rest.entity.ConnectorType;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class ConnectorListTableBuilder
implements TableBuilder<ConnectorList> {
    private static final List<String> HEADERS = ImmutableList.of((Object)"Connector Name", (Object)"Type", (Object)"Class", (Object)"Status");

    @Override
    public Table buildTable(ConnectorList entity) {
        return new Table.Builder().withColumnHeaders(HEADERS).withRows(entity.getConnectors().stream().map(info -> ImmutableList.of((Object)info.getName(), (Object)((ConnectorType)ObjectUtils.defaultIfNull((Object)info.getType(), (Object)ConnectorType.UNKNOWN)).name(), (Object)((String)ObjectUtils.defaultIfNull((Object)info.getClassName(), (Object)"")), (Object)((String)ObjectUtils.defaultIfNull((Object)info.getState(), (Object)""))))).build();
    }
}

