/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.table.builder;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.cli.console.table.Table;
import io.confluent.ksql.cli.console.table.builder.TableBuilder;
import io.confluent.ksql.rest.entity.KafkaTopicsList;
import io.confluent.ksql.rest.entity.KafkaTopicsListExtended;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class KafkaTopicsListTableBuilder {
    private static String getTopicReplicaInfo(List<Integer> replicaSizes) {
        if (replicaSizes.isEmpty()) {
            return "0";
        }
        if (replicaSizes.stream().distinct().limit(2L).count() <= 1L) {
            return String.valueOf(replicaSizes.get(0));
        }
        return StringUtils.join(replicaSizes, (String)", ");
    }

    public static class ExtendedBuilder
    implements TableBuilder<KafkaTopicsListExtended> {
        private static final List<String> HEADERS = ImmutableList.of((Object)"Kafka Topic", (Object)"Partitions", (Object)"Partition Replicas", (Object)"Consumers", (Object)"ConsumerGroups");

        @Override
        public Table buildTable(KafkaTopicsListExtended entity) {
            Stream<List<String>> rows = entity.getTopics().stream().map(t -> ImmutableList.of((Object)t.getName(), (Object)Integer.toString(t.getReplicaInfo().size()), (Object)KafkaTopicsListTableBuilder.getTopicReplicaInfo(t.getReplicaInfo()), (Object)Integer.toString(t.getConsumerCount()), (Object)Integer.toString(t.getConsumerGroupCount())));
            return new Table.Builder().withColumnHeaders(HEADERS).withRows(rows).build();
        }
    }

    public static class SimpleBuilder
    implements TableBuilder<KafkaTopicsList> {
        private static final List<String> HEADERS = ImmutableList.of((Object)"Kafka Topic", (Object)"Partitions", (Object)"Partition Replicas");

        @Override
        public Table buildTable(KafkaTopicsList entity) {
            Stream<List<String>> rows = entity.getTopics().stream().map(t -> ImmutableList.of((Object)t.getName(), (Object)Integer.toString(t.getReplicaInfo().size()), (Object)KafkaTopicsListTableBuilder.getTopicReplicaInfo(t.getReplicaInfo())));
            return new Table.Builder().withColumnHeaders(HEADERS).withRows(rows).build();
        }
    }
}

