/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.table.builder;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.cli.console.table.Table;
import io.confluent.ksql.cli.console.table.builder.TableBuilder;
import io.confluent.ksql.rest.entity.SourceInfo;
import io.confluent.ksql.rest.entity.StreamsList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class StreamsListTableBuilder
implements TableBuilder<StreamsList> {
    private static final List<String> HEADERS = ImmutableList.of((Object)"Stream Name", (Object)"Kafka Topic", (Object)"Key Format", (Object)"Value Format", (Object)"Windowed");

    @Override
    public Table buildTable(StreamsList entity) {
        Stream<List<String>> rows = entity.getStreams().stream().sorted(Comparator.comparing(SourceInfo::getName)).map(s -> ImmutableList.of((Object)s.getName(), (Object)s.getTopic(), (Object)s.getKeyFormat(), (Object)s.getValueFormat(), (Object)Boolean.toString(s.isWindowed())));
        return new Table.Builder().withColumnHeaders(HEADERS).withRows(rows).build();
    }
}

