/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.config.v2;

import com.google.common.base.MoreObjects;
import io.confluent.telemetry.config.v2.AttributeRule;
import java.util.List;
import java.util.Objects;

public abstract class MetricRule {
    private static final boolean DEFAULT_ALLOW_EXTRA_ATTRIBUTES = true;
    private final List<AttributeRule> attributeRules;
    private final boolean allowExtraAttributes;

    public MetricRule(List<AttributeRule> attributeRules, Boolean allowExtraAttributes) {
        this.attributeRules = Objects.requireNonNull(attributeRules, "attributes cannot be empty");
        this.allowExtraAttributes = allowExtraAttributes == null ? true : allowExtraAttributes;
    }

    public List<AttributeRule> getAttributeRules() {
        return this.attributeRules;
    }

    public boolean getAllowExtraAttributes() {
        return this.allowExtraAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricRule)) {
            return false;
        }
        MetricRule that = (MetricRule)o;
        return Objects.equals(this.attributeRules, that.attributeRules);
    }

    public int hashCode() {
        return Objects.hash(this.attributeRules);
    }

    public String toString() {
        return this.toString(MoreObjects.toStringHelper((Object)this).add("attributes", this.attributeRules)).toString();
    }

    abstract MoreObjects.ToStringHelper toString(MoreObjects.ToStringHelper var1);
}

