/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.storage;

import io.confluent.kafka.secretregistry.storage.LookupCache;
import io.confluent.kafka.secretregistry.storage.exceptions.StoreException;
import io.confluent.kafka.secretregistry.storage.exceptions.StoreInitializationException;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class InMemoryCache<K, V>
implements LookupCache<K, V> {
    protected final ConcurrentNavigableMap<K, V> store;

    public InMemoryCache() {
        this(new ConcurrentSkipListMap());
    }

    public InMemoryCache(ConcurrentNavigableMap<K, V> store) {
        this.store = store;
    }

    @Override
    public void init() throws StoreInitializationException {
    }

    @Override
    public V get(K key) {
        return this.store.get(key);
    }

    @Override
    public void put(K key, V value) throws StoreException {
        this.store.put(key, value);
    }

    @Override
    public Iterator<V> getAll(K key1, K key2) {
        SortedMap<K, V> subMap = key1 == null && key2 == null ? this.store : this.store.subMap((Object)key1, (Object)key2);
        return subMap.values().iterator();
    }

    @Override
    public void putAll(Map<K, V> entries) {
        this.store.putAll(entries);
    }

    @Override
    public void delete(K key) throws StoreException {
        this.store.remove(key);
    }

    @Override
    public Iterator<K> getAllKeys() throws StoreException {
        return this.store.keySet().iterator();
    }

    @Override
    public void close() {
        this.store.clear();
    }
}

