/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.function.sdk.v1;

import io.confluent.function.sdk.v1.AuthTokenProvider;
import io.confluent.function.sdk.v1.types.ObjectMetadata;
import io.confluent.secure.compute.function.runtime.v2.FunctionRuntimeGrpc;
import io.confluent.secure.compute.function.runtime.v2.InvokeRequest;
import io.confluent.secure.compute.function.runtime.v2.InvokeRequestBatch;
import io.confluent.secure.compute.function.runtime.v2.InvokeResponse;
import io.confluent.secure.compute.function.runtime.v2.InvokeResponseBatch;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.stub.MetadataUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CfltFunctionClient
implements Closeable {
    private final Logger logger = Logger.getLogger(CfltFunctionClient.class.getName());
    private final String clientId;
    private final String invocationEndpoint;
    private final AuthTokenProvider authTokenProvider;
    private final ObjectMetadata funcMetadata;
    private final boolean useExperimentalV2Routing;
    private FunctionRuntimeGrpc.FunctionRuntimeBlockingStub blockingStub;
    private ManagedChannel channel;

    CfltFunctionClient(String clientId, String invocationEndpoint, AuthTokenProvider authTokenProvider, ObjectMetadata funcMetadata, boolean useExperimentalV2Routing, FunctionRuntimeGrpc.FunctionRuntimeBlockingStub blockingStub, ManagedChannel channel) {
        this.clientId = clientId;
        this.invocationEndpoint = invocationEndpoint;
        this.authTokenProvider = authTokenProvider;
        this.funcMetadata = funcMetadata;
        this.useExperimentalV2Routing = useExperimentalV2Routing;
        this.blockingStub = blockingStub;
        this.channel = channel;
    }

    public InvokeResponse invoke(InvokeRequest request) throws IOException, InterruptedException {
        Metadata header = new Metadata();
        header.put(Metadata.Key.of((String)"x-cfltfaas-request-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)UUID.randomUUID().toString());
        header.put(Metadata.Key.of((String)"x-cfltfaas-function-name", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)this.funcMetadata.getName());
        header.put(Metadata.Key.of((String)"x-cfltfaas-client-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)this.clientId);
        if (this.authTokenProvider != null) {
            header.put(Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)("Bearer " + this.authTokenProvider.get()));
        }
        if (this.useExperimentalV2Routing) {
            header.put(Metadata.Key.of((String)"x-cfltfaas-use-manager-routing", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)"true");
        }
        InvokeResponse resp = ((FunctionRuntimeGrpc.FunctionRuntimeBlockingStub)this.blockingStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)header)})).invoke(request);
        this.logger.log(Level.FINE, "invoke: func={0}, invocationEndpoint={1}, err={2}, input.payload.size()={3}, output.payload.size()={4}", new Object[]{this.funcMetadata, this.invocationEndpoint, resp.getError(), request.getPayload().size(), resp.getPayload().size()});
        return resp;
    }

    public InvokeResponseBatch invokeBatch(InvokeRequestBatch request) throws IOException, InterruptedException {
        Metadata header = new Metadata();
        header.put(Metadata.Key.of((String)"x-cfltfaas-request-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)UUID.randomUUID().toString());
        header.put(Metadata.Key.of((String)"x-cfltfaas-function-name", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)this.funcMetadata.getName());
        header.put(Metadata.Key.of((String)"x-cfltfaas-client-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)this.clientId);
        if (this.authTokenProvider != null) {
            header.put(Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)("Bearer " + this.authTokenProvider.get()));
        }
        if (this.useExperimentalV2Routing) {
            header.put(Metadata.Key.of((String)"x-cfltfaas-use-manager-routing", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)"true");
        }
        InvokeResponseBatch resp = ((FunctionRuntimeGrpc.FunctionRuntimeBlockingStub)this.blockingStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)header)})).invokeBatch(request);
        this.logger.log(Level.FINE, "invoke: func={0}, invocationEndpoint={1}, requestsCount={2}, responsesCount={3}", new Object[]{this.funcMetadata, this.invocationEndpoint, request.getRequestsCount(), resp.getResponsesCount()});
        return resp;
    }

    @Override
    public void close() {
        if (this.channel != null) {
            this.channel.shutdown();
        }
    }
}

